package com.bcxin.ars.service.approve.impl;

import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.approve.ApproveTempDao;
import com.bcxin.ars.dao.approve.ApproveTempLinkRelaDao;
import com.bcxin.ars.dto.approve.ApproveTempDto;
import com.bcxin.ars.dto.approve.CheckTempConfigDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.approve.ApproveTemp;
import com.bcxin.ars.service.approve.ApproveTempService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author：wangcy @date：2018/01/16 0016 19:44 @description：
 */
@Service
@Transactional
public class ApproveTempServiceImpl implements ApproveTempService {
	@Autowired
	private ApproveTempDao approveTempDao;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private PoliceDao policeDao;

	@Autowired
	private ApproveTempLinkRelaDao approveTempLinkRelaDao;

	/**
	 * 获取市级模板数据
	 *
	 * @return
	 */
	@Override
	public List<ApproveTempDto> findDto() {
		User currentUser = arsUtil.getCurrentUser();
		Police currentPolice = currentUser.getPolice();
		List<ApproveTempDto> resultApproveTempDtoList = new ArrayList<ApproveTempDto>();
		List<ApproveTempDto> resultTempList = new ArrayList<ApproveTempDto>();
		if (currentPolice != null) {
			String orgtype = currentPolice.getOrgtype();// 机构类型
			String areacode = currentPolice.getAreacode();// 地区编码
			Long orgId = null; // 机构编码
			// 获取省级机构、市级机构模板列表
			if (StringUtils.isEmpty(areacode)) {
				throw new ArsException("获取当前用户地区编码失败！");
			}

			if (!Constants.POLICE_ORGTYPE_SHENG.equals(orgtype)) {
				// 非省级账号
				List<Police> polices = null;
				Police policeQuery = new Police();
				policeQuery.setOrgtype(Constants.ORGTYPE_CITY);
				policeQuery.setAreacode(areacode.substring(0, 4) + "00");
				polices = policeDao.findPoliceByOrgTypeAndLikeAreacode(Constants.ORGTYPE_CITY,areacode.substring(0, 4) + "00");
				if (polices != null && polices.size() == 1) {
					orgId = polices.get(0).getId();
				} else {
					throw new ArsException("获取当前用户市级机构失败:市级机构不存在或者市级机构存在多条重复！");
				}
			} else {
				// 省级账号
				orgId = currentPolice.getId();
			}

			resultApproveTempDtoList = approveTempDao.findDto(orgId);


			Long qxOrgId = null;
			if (Constants.POLICE_ORGTYPE_QX.equals(orgtype)){
				qxOrgId = currentPolice.getId();
			}else if(Constants.POLICE_ORGTYPE_PCS.equals(orgtype)){
				Police qxPolice = policeDao.findByOrgIdsAndOrgType(currentPolice.getPath().split("/"),Constants.POLICE_ORGTYPE_QX);
				if(qxPolice != null){
					qxOrgId = qxPolice.getId();
				}
			}

			Map<String,ApproveTempDto> tempMap = new HashMap<>();
			if(qxOrgId != null){
				List<ApproveTempDto> tempDtoList = approveTempDao.findDto(qxOrgId);
				if(tempDtoList != null && tempDtoList.size() > 0) {
					tempMap = tempDtoList.stream().collect(Collectors.toMap(ApproveTempDto::getApproveType, Function.identity()));
				}
			}


			if (resultApproveTempDtoList != null && resultApproveTempDtoList.size() > 0) {
				for (ApproveTempDto item : resultApproveTempDtoList) {
					if(tempMap.get(item.getApproveType()) != null){
						item = tempMap.get(item.getApproveType());
					}

					ApproveTemp checkCityTemp = new ApproveTemp();
					checkCityTemp.setId(Long.valueOf(item.getTempId()));
					if (checkCurrentTempConfigComplete(checkCityTemp)) {
						item.setApproveSetStatus("1");
					} else {
						item.setApproveSetStatus("0");
					}
					resultTempList.add(item);
				}
			}
		} else {
			throw new ArsException("获取当前用户机构信息失败！");
		}
		return resultTempList;
	}

	/**
	 * @Author: wangcy
	 * @Description:获取模板
	 * @Date: 2018/01/19 0019 10:53
	 */
	@Override
	public ApproveTemp findById(Long id) {
		return approveTempDao.findById(id);
	}

	/**
	 * @Author: wangcy
	 * @Description:修改模板信息
	 * @Date: 2018/01/19 0019 10:53
	 */
	@Override
	public void update(ApproveTemp approveTemp) {
		User currentUser = arsUtil.getCurrentUser();
		if (approveTemp.getId() != null) {
			// 获取sql的实体
			ApproveTemp dbApproveTemp = approveTempDao.findById(approveTemp.getId());
			dbApproveTemp.setUpdateBy(currentUser.getUsername());
			dbApproveTemp.setUpdateTime(new Date());

			// 如果不为空，则更新相应字段的值
			if (!StringUtils.isEmpty(approveTemp.getTempName())) {
				dbApproveTemp.setTempName(approveTemp.getTempName());
			}
			if (!StringUtils.isEmpty(approveTemp.getApproveSetStatus())) {
				dbApproveTemp.setApproveSetStatus(approveTemp.getApproveSetStatus());
			}
			if (!StringUtils.isEmpty(approveTemp.getNoticeTemp())) {
				dbApproveTemp.setNoticeTemp(approveTemp.getNoticeTemp());
			}
			if (!StringUtils.isEmpty(approveTemp.getRepulseExplain())) {
				dbApproveTemp.setRepulseExplain(approveTemp.getRepulseExplain());
			}
			approveTempDao.update(dbApproveTemp);
		}

	}

	@Override
	public String getConfigState() {
		User currentUser = arsUtil.getCurrentUser();
		String configState = "";
		// if (currentUser.getPolice() != null) {
		// String orgtype = currentUser.getPolice().getOrgtype();// 机构类型
		// String areacode = currentUser.getPolice().getAreacode();// 地区编码
		// Long provinceOrgId = null;// 省级机构ID
		// Long cityOrgId = null;// 市级机构ID
		// List<ApproveTempDto> provinceApproveTempDtoList = null;
		// List<ApproveTempDto> cityApproveTempDtoList = null;
		// // 获取省级机构、市级机构模板列表
		// if (!StringUtils.isEmpty(areacode)) {
		// if (!orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
		// // 非省级账号
		// Police policeQuery = new Police();
		// policeQuery.setAreacode(areacode.substring(0, 2) + "0000");
		// List<Police> polices = null;
		// polices = policeDao.findPoliceByAreacode(policeQuery);
		// if (polices != null && polices.size() == 1) {
		// provinceOrgId = polices.get(0).getId();
		// } else {
		// throw new ArsException("获取当前用户省级机构失败:省级机构不存在或者省级机构存在多条重复！");
		// }
		// policeQuery.setAreacode(areacode.substring(0, 4) + "00");
		// polices = policeDao.findPoliceByAreacode(policeQuery);
		// if (polices != null && polices.size() == 1) {
		// cityOrgId = polices.get(0).getId();
		// } else {
		// throw new ArsException("获取当前用户市级机构失败:市级机构不存在或者市级机构存在多条重复！");
		// }
		// } else {
		// // 省级账号
		// provinceOrgId = currentUser.getPolice().getId();
		// }
		// } else {
		// throw new ArsException("获取当前用户地区编码失败！");
		// }
		// if (provinceOrgId != null) {
		// provinceApproveTempDtoList = approveTempDao.findDto(provinceOrgId);
		// }
		// if (cityOrgId != null) {
		// cityApproveTempDtoList = approveTempDao.findDto(cityOrgId);
		// }
		// if (provinceApproveTempDtoList != null &&
		// provinceApproveTempDtoList.size() > 0) {
		// if (cityApproveTempDtoList == null || cityApproveTempDtoList.size() <
		// 1) {
		// resultApproveTempDtoList = provinceApproveTempDtoList;
		// } else {
		// for (ApproveTempDto provinceItem : provinceApproveTempDtoList) {
		// boolean isCityConfig = false; // 是否市级配置
		// for (ApproveTempDto cityItem : cityApproveTempDtoList) {
		// if (provinceItem.getTempCode().contains(cityItem.getTempCode())) {
		// isCityConfig = true;
		// provinceItem.setConfigState("2");// 市级已配置
		// provinceItem = cityItem;
		// break;
		// }
		// }
		// if (!isCityConfig) {
		// provinceItem.setConfigState("1");// 省级已配置
		// }
		// }
		// resultApproveTempDtoList = provinceApproveTempDtoList;
		// }
		// }
		// } else {
		// throw new ArsException("获取当前用户机构信息失败！");
		// }
		return configState;
	}

	@Override
	public List<ApproveTemp> findByParentTempId(ApproveTemp approveTemp) {
		return approveTempDao.findByParentTempId(approveTemp.getParentTempId());
	}

	@Override
	public List<ApproveTemp> findApproveOrgListSj(ApproveTemp approveTemp) {
		return approveTempDao.findApproveOrgListSj(approveTemp.getParentTempId());
	}

	@Override
	public boolean checkTempConfigComplete(ApproveTemp approveTemp) {
		User user = arsUtil.getCurrentUser();
		String orgtype = user.getPolice().getOrgtype(); // 当前机构类型
		String superAreaCode = ""; // 上级机构编码
		String superOrgtype = ""; // 上级机构类别
		String areaCode = user.getPolice().getAreacode(); // 当前机构所在地区,地区只有6位
		boolean configStatus = true;
		if (orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
			// 省级
			return true;
		} else if (orgtype.equals(Constants.POLICE_ORGTYPE_SHI)) {
			// 市级
			areaCode = areaCode.substring(0, 4);
			superAreaCode = areaCode.substring(0, 2) + "0000";
			superOrgtype = Constants.POLICE_ORGTYPE_SHENG;
		} else if (orgtype.equals(Constants.POLICE_ORGTYPE_QX)) {
			// 区县
			superAreaCode = areaCode.substring(0, 4) + "00";
			superOrgtype = Constants.POLICE_ORGTYPE_SHI;
		} else {
			// 派出所
			superAreaCode = areaCode;
			superOrgtype = Constants.POLICE_ORGTYPE_QX;
		}
		CheckTempConfigDto checkDto = new CheckTempConfigDto();
		checkDto.setTempId(approveTemp.getId());
		checkDto.setAreaCode(superAreaCode);
		checkDto.setOrgtype(superOrgtype);
		Long check = approveTempLinkRelaDao.checkTempConfigCompleteByOrgTypeAndCityCode(checkDto);
		if (check != null && check > 0) {
			configStatus = false;
		}
		return configStatus;
	}

	/**
	 * 根据tempcode查询ApproveTemp
	 * @param tempCode
	 * @return
	 */
	@Override
	public ApproveTemp findByTempCode(String tempCode) {
		return approveTempDao.findByTempCode(tempCode);
	}

	/**
	 * 获取审批级别
	 * @param tempCode
	 * @return
	 */
	@Override
	public String getMaxApproveLevel(String tempCode) {
		ApproveTemp approveTemp = approveTempDao.findByTempCode(tempCode);
		if(approveTemp != null) {
			return approveTempDao.getMaxApproveLevelByApproveTempId(approveTemp.getId());
		}else{
			throw new ArsException("审批模板未配置！");
		}
	}

	/**
	 * 检查当前登陆机构是否都配置好并启动环节
	 * 
	 * @param approveTemp
	 * @return
	 */
	private boolean checkCurrentTempConfigComplete(ApproveTemp approveTemp) {
		User user = arsUtil.getCurrentUser();
		Long orgid = user.getPolice().getId(); // 当前机构类型
		boolean configStatus = true;
		CheckTempConfigDto checkDto = new CheckTempConfigDto();
		checkDto.setTempId(approveTemp.getId());
		checkDto.setOrgid(orgid);
		// 查看未配置环节数量
		Long check = approveTempLinkRelaDao.checkTempConfigCompleteByOrgId(checkDto);
		if (check != null && check > 0) {
			configStatus = false;
		} else {
			// 判断是否有配置环节数量
			Long count = approveTempLinkRelaDao.getTempLinkByPoliceCount(checkDto);
			if (count != null && count > 0) {
				configStatus = true;
			} else {
				configStatus = false;
			}
		}
		return configStatus;
	}
}
