package com.bcxin.ars.service.appeal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sb.PersonAdaptDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.sb.PersonAdapt;
import com.bcxin.ars.service.appeal.AppealHandle;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import com.bcxin.ars.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 岗位适应性申诉处理
 * @author linqinglin
 * @date 2020/04/10 0010 11:00
 */
@Service
public class AdaptAppealHandle implements AppealHandle {


    @Autowired
    private PersonAdaptDao personAdaptDao;

    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;

    @Override
    public void handle(Appeal appeal) {
        //获取岗位适应性报名信息
        PersonAdapt personAdapt = personAdaptDao.findById(appeal.getBusinessid());
        if(Constants.APPROVALSTATE_TG.equals(appeal.getAppealState())){
            //审批状态设置为审批中
            personAdapt.setApprovalState(Constants.APPLYSTATUS_DSH);
            //背景筛查设置为通过
            personAdapt.setCensorStatus(Constants.BACKGROUNDSTATUS_ZC);
            //审批原因设置为空
            personAdapt.setApprovalReason(null);
            //更新最新时间
            personAdapt.setUpdateTime(new Date());
        }else if(Constants.APPROVALSTATE_BTG.equals(appeal.getAppealState())){
            //审批状态设置为不通过
            personAdapt.setApprovalState(Constants.APPLYSTATUS_SHBTG);
            //背景筛查设置为不通过
            personAdapt.setCensorStatus(Constants.BACKGROUNDSTATUS_GZ);
            //审批原因
            personAdapt.setApprovalReason(appeal.getAppealReson());
            //更新最新时间
            personAdapt.setUpdateTime(new Date());
        }

        //更新
        personAdaptDao.update(personAdapt);
    }

    @Override
    public void handle(List<Appeal> list) {
        if(list != null && list.size() >0) {
            JSONArray paramArr = new JSONArray();
            JSONObject param = null;
            List<PersonAdapt> gradeList = new ArrayList<>();
            for (Appeal appeal : list) {
                //获取岗位适应性报名信息
                PersonAdapt personAdapt = personAdaptDao.findById(appeal.getBusinessid());
                if(Constants.APPROVALSTATE_TG.equals(appeal.getAppealState())){
                    //审批状态设置为审批中
                    personAdapt.setApprovalState(Constants.APPLYSTATUS_DSH);
                    //背景筛查设置为通过
                    personAdapt.setCensorStatus(Constants.BACKGROUNDSTATUS_ZC);
                    //审批原因设置为空
                    personAdapt.setApprovalReason(null);
                    //更新最新时间
                    personAdapt.setUpdateTime(new Date());
                }else if(Constants.APPROVALSTATE_BTG.equals(appeal.getAppealState())){
                    //审批状态设置为不通过
                    personAdapt.setApprovalState(Constants.APPLYSTATUS_SHBTG);
                    //背景筛查设置为不通过
                    personAdapt.setCensorStatus(Constants.BACKGROUNDSTATUS_GZ);
                    //审批原因
                    personAdapt.setApprovalReason(appeal.getAppealReson());
                    //更新最新时间
                    personAdapt.setUpdateTime(new Date());
                }
                param = new JSONObject();
                param.put("adaptApplyId", personAdapt.getId()+"");
                param.put("backgroundStatus", personAdapt.getCensorStatus());
                param.put("approvalState", personAdapt.getApprovalState());
                param.put("backgroundFailReason", personAdapt.getApprovalReason());
                /**
                 * 背景筛查类型
                 * 1. 系统自动比对
                 * 2. 申诉通道
                 */
                param.put("backgroundType", Constants.BACKGROUNDTYPE_APPEAL);
                paramArr.add(param);

                //更新
                gradeList.add(personAdapt);
            }

            //TODO 背景筛查结果同步给百课堂
            Map<String,Object> paramMap = new HashMap<>();
            paramMap.put("personList", JSON.toJSONString(paramArr));
            AjaxResult result = bktInterfaceUtil.callInterface(Constants.BKT_PERSONADAPT_CENSOR_URL,paramMap);
            if(!result.isSuccessful()){
                throw new ArsException("【岗位适应性报名申诉结果】"+result.getMsg());
            }

            personAdaptDao.saveBatch(gradeList);
        }

    }
}
