/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Service
public class EhcacheUtil<T> {
    @Autowired
    private CacheManager cacheManager;

    public void add(String cacheName, T value) {
        Cache cache = this.cacheManager.getCache(cacheName);
        ArrayList<T> list = (ArrayList<T>)cache.get((Object)cacheName, ArrayList.class);
        if (null != list && list.isEmpty()) {
            list = new ArrayList<T>();
        }
        list.add(value);
        cache.put((Object)cacheName, list);
    }

    public List<T> get(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (null == cache) {
            return null;
        }
        List list = (List)cache.get((Object)cacheName, ArrayList.class);
        if (null != list && list.isEmpty()) {
            return null;
        }
        return list;
    }

    public boolean contains(String cacheName, T value) {
        Cache cache = this.cacheManager.getCache(cacheName);
        List list = (List)cache.get((Object)cacheName, ArrayList.class);
        if (null != list && list.isEmpty()) {
            return false;
        }
        return list.contains(value);
    }

    public void remove(String cacheName, T value) {
        Cache cache = this.cacheManager.getCache(cacheName);
        List list = (List)cache.get((Object)cacheName, ArrayList.class);
        if (null != list && list.isEmpty()) {
            return;
        }
        list.remove(value);
        cache.put((Object)cacheName, (Object)list);
    }

    public void put(String cacheName, String key, T value) {
        Cache cache = this.cacheManager.getCache(cacheName);
        HashMap<String, T> map = (HashMap<String, T>)cache.get((Object)cacheName, HashMap.class);
        if (null == map || map.isEmpty()) {
            map = new HashMap<String, T>();
        }
        map.put(key, value);
        cache.put((Object)cacheName, map);
    }

    public String get(String cacheName, String key) {
        Cache cache = this.cacheManager.getCache(cacheName);
        Map map = (Map)cache.get((Object)cacheName, HashMap.class);
        if (null == map || map.isEmpty()) {
            return null;
        }
        return (String)map.get(key);
    }

    public List<T> getValues(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        Map map = (Map)cache.get((Object)cacheName, HashMap.class);
        if (null == map || map.isEmpty()) {
            return null;
        }
        ArrayList values = new ArrayList(map.size());
        for (Map.Entry entry : map.entrySet()) {
            values.add(entry.getValue());
        }
        return values;
    }

    public boolean containsKey(String cacheName, String key) {
        Cache cache = this.cacheManager.getCache(cacheName);
        Map map = (Map)cache.get((Object)cacheName, HashMap.class);
        if (null == map || map.isEmpty()) {
            return false;
        }
        return map.containsKey(key);
    }

    public void removeKey(String cacheName, String key) {
        Cache cache = this.cacheManager.getCache(cacheName);
        Map map = (Map)cache.get((Object)cacheName, HashMap.class);
        if (null == map || map.isEmpty()) {
            return;
        }
        map.remove(key);
        cache.put((Object)cacheName, (Object)map);
    }
}

