/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.task.ComTempTaskPerDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.ComTempTaskPerPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.ComTempTaskPer;
import com.bcxin.ars.service.task.ComTempTaskPerService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=ComTempTaskPer.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
public class ComTempTaskPerServiceImpl
implements ComTempTaskPerService {
    Logger logger = LoggerFactory.getLogger(ComTempTaskPerServiceImpl.class);
    @Autowired
    private ComTempTaskPerDao comTempTaskPerDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(ComTempTaskPer comTempTaskPer) {
        User currentUser = this.arsUtil.getCurrentUser();
        comTempTaskPer.setUpdateTime(new Date());
        comTempTaskPer.setUpdateBy(currentUser.getUsername());
        return this.comTempTaskPerDao.delete(comTempTaskPer);
    }

    public int save(ComTempTaskPer comTempTaskPer) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (comTempTaskPer.getId() == null) {
            comTempTaskPer.setCreateTime(new Date());
        } else {
            ComTempTaskPer dbComTempTaskPer = this.comTempTaskPerDao.findById(comTempTaskPer.getId());
            BeanUtils.copyPropertiesIgnore((Object)comTempTaskPer, (Object)dbComTempTaskPer, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbComTempTaskPer, (Object)comTempTaskPer, (Boolean)false);
        }
        comTempTaskPer.setActive(Boolean.valueOf(true));
        comTempTaskPer.setUpdateBy(currentUser.getUsername());
        comTempTaskPer.setUpdateTime(new Date());
        comTempTaskPer.setUpdateflag(Boolean.valueOf(true));
        comTempTaskPer.setUserId(currentUser.getId());
        comTempTaskPer.setAreaCode(currentUser.getPolice().getAreacode());
        return this.comTempTaskPerDao.save(comTempTaskPer);
    }

    public ComTempTaskPer findById(Long id) {
        return this.comTempTaskPerDao.findById(id);
    }

    public void searchForPage(ComTempTaskPerPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.comTempTaskPerDao.searchForPage(dto, page);
    }

    public void importBatch(List<ComTempTaskPer> list) {
        List dbList = this.comTempTaskPerDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (ComTempTaskPer comTempTaskPer : list) {
                comTempTaskPer.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    comTempTaskPer.setUpdateTime(DateUtil.dateAdd((int)6, (Date)comTempTaskPer.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.comTempTaskPerDao.saveBatch(list);
        }
    }

    public List<ComTempTaskPer> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.comTempTaskPerDao.searchForDataSynchronization(dto);
    }

    public List<ComTempTaskPer> findDSOutList(String startDate) {
        return this.comTempTaskPerDao.findDSOutList(startDate);
    }

    public List<ComTempTaskPer> findByBatchId(List<ComTempTaskPer> list) {
        return this.comTempTaskPerDao.findByBatchId(list);
    }

    public void updateSelective(ComTempTaskPer comTempTaskPer) {
        User currentUser = this.arsUtil.getCurrentUser();
        comTempTaskPer.setUpdateTime(new Date());
        comTempTaskPer.setUpdateBy(currentUser.getUsername());
        this.comTempTaskPerDao.updateSelective(comTempTaskPer);
    }
}

