/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.log.LogMessageDao;
import com.bcxin.ars.dao.sb.OrderDetailDao;
import com.bcxin.ars.dao.sb.OrderInfoDao;
import com.bcxin.ars.dao.sb.OrderPayInfoDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dto.BKTNewOrderDTO;
import com.bcxin.ars.dto.BKTNewOrderPersonDTO;
import com.bcxin.ars.dto.OrderDetailDTO;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.log.LogMessage;
import com.bcxin.ars.model.sb.OrderDetail;
import com.bcxin.ars.model.sb.OrderInfo;
import com.bcxin.ars.model.sb.OrderPayInfo;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.sb.OrderInfoService;
import com.bcxin.ars.service.sb.impl.ManagementInfoServiceImpl;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.HttpClientUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
public class OrderInfoServiceImpl
implements OrderInfoService {
    private static Logger logger = LoggerFactory.getLogger(ManagementInfoServiceImpl.class);
    public static String IS_SUCCESS = "0";
    @Autowired
    private OrderInfoDao orderInfoDAO;
    @Autowired
    private OrderDetailDao orderDetailDao;
    @Autowired
    private OrderPayInfoDao orderPayInfoDao;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private LogMessageDao logMessageDao;
    @Autowired
    private PersoncertificateDao personcertificateDao;

    public OrderInfo fingById(Long id) {
        return this.orderInfoDAO.findById(id);
    }

    public OrderInfo findByDetailId(Long id) {
        return this.orderInfoDAO.findByDetailId(id);
    }

    public void insert(OrderInfo orderInfo) {
        this.orderInfoDAO.insert(orderInfo);
    }

    public void update(OrderInfo orderInfo) {
        this.orderInfoDAO.update(orderInfo);
    }

    public void saveOrder(String payStatus, OrderInfo orderInfo, Date date) {
        if ("1".equals(payStatus)) {
            orderInfo.setOrderStatus(payStatus);
            orderInfo.setUpdateTime(date);
            orderInfo.setPaySuccessTime(date);
            this.orderInfoDAO.update(orderInfo);
            List orderDetailList = this.orderDetailDao.selectOrderDetailByInfoId(orderInfo.getId());
            if (orderDetailList != null && orderDetailList.size() > 0) {
                ArrayList<OrderDetailDTO> orderDetailDTOList = new ArrayList<OrderDetailDTO>();
                for (OrderDetail orderDetail : orderDetailList) {
                    OrderDetailDTO orderDetailDTO = new OrderDetailDTO();
                    BeanUtils.copyPropertiesIgnore((Object)orderDetail, (Object)orderDetailDTO);
                    orderDetailDTO.setTrainOrgID(orderInfo.getBktOrgId());
                    orderDetailDTO.setTrainOrgName(orderInfo.getBktOrgName());
                    orderDetailDTOList.add(orderDetailDTO);
                }
                this.orderDetailDao.bktUpdatefeeStateByBatchID(orderDetailDTOList);
            }
            this.bKTPayInterface(orderInfo, orderDetailList);
        }
        OrderPayInfo orderPayInfo = new OrderPayInfo();
        orderPayInfo.setCreateTime(date);
        orderPayInfo.setActive(Boolean.valueOf(true));
        orderPayInfo.setCreateBy(orderInfo.getCreateBy());
        orderPayInfo.setIsPaySuccess(payStatus);
        orderPayInfo.setOrderInfoId(orderInfo.getId());
        orderPayInfo.setId(Long.valueOf(this.idGeneratorUtil.createID()));
        this.orderPayInfoDao.insert(orderPayInfo);
    }

    private void bKTPayInterface(OrderInfo orderInfo, List<OrderDetail> orderDetailList) {
        Config configURL = this.configDao.findByKey("bkt_data_url");
        LogMessage logMessage = new LogMessage();
        logMessage.setLogger_title("\u767e\u8bfe\u5802\u65b0\u8ba2\u5355\u540c\u6b65");
        logMessage.setCreateTime(new Date());
        try {
            if (configURL != null && configURL.getValue() != null) {
                String url = configURL.getValue() + Constants.BTK_NEWORDER;
                BKTNewOrderDTO bktNewOrderDTO = new BKTNewOrderDTO();
                HashMap<String, String> data = new HashMap<String, String>();
                bktNewOrderDTO.setTrackid(orderInfo.getBktCourseId());
                bktNewOrderDTO.setOrganID(orderInfo.getBktOrgId());
                bktNewOrderDTO.setSumPrice(orderInfo.getOrderSumMoney());
                bktNewOrderDTO.setPrice(orderInfo.getOrderSumMoney());
                ArrayList<BKTNewOrderPersonDTO> systemLearnOrderPeoples = new ArrayList<BKTNewOrderPersonDTO>();
                ArrayList<Personcertificate> personcertificates = new ArrayList<Personcertificate>();
                for (OrderDetail orderDetail : orderDetailList) {
                    Personcertificate personcertificate = new Personcertificate();
                    personcertificate.setBbdPersonID(orderDetail.getSbPersoncertificateId());
                    personcertificates.add(personcertificate);
                }
                List dbPersoncertificateList = this.personcertificateDao.findByBatchPersonId(personcertificates);
                for (Personcertificate dbpersoncertificate : dbPersoncertificateList) {
                    BKTNewOrderPersonDTO bktNewOrderPersonDTO = new BKTNewOrderPersonDTO();
                    bktNewOrderPersonDTO.setMobile(dbpersoncertificate.getPhone());
                    bktNewOrderPersonDTO.setIdentitynumber(dbpersoncertificate.getCardnumber());
                    bktNewOrderPersonDTO.setFullname(dbpersoncertificate.getName());
                    bktNewOrderPersonDTO.setTruename(dbpersoncertificate.getName());
                    bktNewOrderPersonDTO.setBbdPersonID(dbpersoncertificate.getId());
                    systemLearnOrderPeoples.add(bktNewOrderPersonDTO);
                }
                bktNewOrderDTO.setSystemLearnOrderPeoples(systemLearnOrderPeoples);
                data.put("data", JSON.toJSONString((Object)bktNewOrderDTO));
                String string = HttpClientUtils.doPost((String)url, data, (String)"utf-8");
                if (string != null) {
                    JSONObject jsonObject = JSONObject.parseObject((String)string);
                    String retType = jsonObject.get((Object)"retType").toString();
                    if (!StringUtils.isEmpty((Object)retType) && Constants.BTK_IS_SUCCESS.equals(retType)) {
                        logger.info("\u767e\u8bfe\u5802\u65b0\u8ba2\u5355\u540c\u6b65\u6210\u529f");
                    } else {
                        logger.info("\u767e\u8bfe\u5802\u65b0\u8ba2\u5355\u540c\u6b65\u5931\u8d25");
                    }
                    String retrunData = "";
                    if (jsonObject.get((Object)"data") != null) {
                        retrunData = jsonObject.get((Object)"data").toString();
                    }
                    String message = "";
                    if (jsonObject.get((Object)"msg") != null) {
                        message = jsonObject.get((Object)"msg").toString();
                    }
                    if (!StringUtils.isEmpty((Object)retrunData)) {
                        logMessage.setLogger_context(retrunData);
                    } else if (!StringUtils.isEmpty((Object)message)) {
                        logMessage.setLogger_context(message);
                    }
                    this.logMessageDao.save(logMessage);
                }
            }
        }
        catch (Exception e) {
            logMessage.setLogger_context(e.toString());
            this.logMessageDao.save(logMessage);
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

