/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.GradeSubsidyBatchRosterDao;
import com.bcxin.ars.dao.sb.GradeSubsidyBatchRosterDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.GradeSubsidyBatchRoster;
import com.bcxin.ars.service.sb.GradeSubsidyBatchRosterService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=GradeSubsidyBatchRoster.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
public class GradeSubsidyBatchRosterServiceImpl
implements GradeSubsidyBatchRosterService {
    Logger logger = LoggerFactory.getLogger(GradeSubsidyBatchRosterServiceImpl.class);
    @Autowired
    private GradeSubsidyBatchRosterDao gradeSubsidyBatchRosterDao;
    @Autowired
    private GradeSubsidyBatchRosterDaoAop gradeSubsidyBatchRosterDaoAop;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(GradeSubsidyBatchRoster gradeSubsidyBatchRoster) {
        User currentUser = this.arsUtil.getCurrentUser();
        gradeSubsidyBatchRoster.setUpdateTime(new Date());
        gradeSubsidyBatchRoster.setUpdateBy(currentUser.getUsername());
        return this.gradeSubsidyBatchRosterDaoAop.delete(gradeSubsidyBatchRoster);
    }

    public int save(GradeSubsidyBatchRoster gradeSubsidyBatchRoster) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (gradeSubsidyBatchRoster.getId() == null) {
            gradeSubsidyBatchRoster.setCreateTime(new Date());
        } else {
            GradeSubsidyBatchRoster dbGradeSubsidyBatchRoster = this.gradeSubsidyBatchRosterDao.findById(gradeSubsidyBatchRoster.getId());
            BeanUtils.copyPropertiesIgnore((Object)gradeSubsidyBatchRoster, (Object)dbGradeSubsidyBatchRoster, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbGradeSubsidyBatchRoster, (Object)gradeSubsidyBatchRoster, (Boolean)false);
        }
        gradeSubsidyBatchRoster.setActive(Boolean.valueOf(true));
        gradeSubsidyBatchRoster.setUpdateBy(currentUser.getUsername());
        gradeSubsidyBatchRoster.setUpdateTime(new Date());
        gradeSubsidyBatchRoster.setUpdateflag(Boolean.valueOf(true));
        gradeSubsidyBatchRoster.setAreaCode(currentUser.getPolice().getAreacode());
        return this.gradeSubsidyBatchRosterDaoAop.save(gradeSubsidyBatchRoster);
    }

    public GradeSubsidyBatchRoster findById(Long id) {
        return this.gradeSubsidyBatchRosterDao.findById(id);
    }

    public void importBatch(List<GradeSubsidyBatchRoster> list) {
        List dbList = this.gradeSubsidyBatchRosterDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (GradeSubsidyBatchRoster gradeSubsidyBatchRoster : list) {
                gradeSubsidyBatchRoster.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    gradeSubsidyBatchRoster.setUpdateTime(DateUtil.dateAdd((int)6, (Date)gradeSubsidyBatchRoster.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.gradeSubsidyBatchRosterDaoAop.saveBatch(list);
        }
    }

    public List<GradeSubsidyBatchRoster> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.gradeSubsidyBatchRosterDao.searchForDataSynchronization(dto);
    }

    public List<GradeSubsidyBatchRoster> findDSOutList(String startDate) {
        return this.gradeSubsidyBatchRosterDao.findDSOutList(startDate);
    }

    public List<GradeSubsidyBatchRoster> findByBatchId(List<GradeSubsidyBatchRoster> list) {
        return this.gradeSubsidyBatchRosterDao.findByBatchId(list);
    }
}

