/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.ConfesscompanyDao;
import com.bcxin.ars.dao.sb.ConfesscompanyDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.sb.ConfesscompanySearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Confesscompany;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.ConfesscompanyService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.ars.webservice.Zxzybaydwxx;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Confesscompany.class)
public class ConfesscompanyServiceImpl
implements ConfesscompanyService {
    private Logger logger = LoggerFactory.getLogger(ConfesscompanyServiceImpl.class);
    @Autowired
    private ConfesscompanyDao confesscompanyDao;
    @Autowired
    private ConfesscompanyDaoAop confesscompanyDaoAop;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private ClientUtil clientUtil;

    public Confesscompany findById(long id) {
        Confesscompany result = this.confesscompanyDao.findById(Long.valueOf(id));
        if (result != null) {
            result.setApproval(this.approvalDAO.findBybusinessidAndType(result.getId(), "006"));
            Police police = this.policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }

    public List<Confesscompany> findByBatchId(List<Approval> approvalList) {
        return this.confesscompanyDao.findByBatchId(approvalList);
    }

    public void updateBatch(List<Confesscompany> list) {
        this.confesscompanyDaoAop.updateBatch(list);
    }

    public void saveOrUpdateBypolice(Confesscompany confesscompany) {
        Police police;
        String areacode;
        User currentUser = this.arsUtil.getCurrentUser();
        if (null != confesscompany.getCompanytype() && !confesscompany.getCompanytype().contains("9") || null == confesscompany.getCompanytype()) {
            confesscompany.setOtherCompanyTypeName(null);
        }
        if (null != confesscompany.getManagement() && !confesscompany.getManagement().contains("20") || null == confesscompany.getManagement()) {
            confesscompany.setOtherSecScopeType(null);
        }
        if ((areacode = (police = currentUser.getPolice()).getAreacode()).endsWith("0000")) {
            if (currentUser.getPlatform() == 1 && confesscompany.getId() == null) {
                confesscompany.setProvince(areacode.substring(0, 2) + "0000");
                confesscompany.setDistrict(areacode.substring(0, 2) + "0000");
                confesscompany.setCity(areacode.substring(0, 2) + "0000");
            }
        } else if (areacode.endsWith("00")) {
            confesscompany.setProvince(areacode.substring(0, 2) + "0000");
            confesscompany.setDistrict(areacode);
            confesscompany.setCity(areacode);
        } else {
            confesscompany.setProvince(areacode.substring(0, 2) + "0000");
            confesscompany.setCity(areacode.substring(0, 4) + "00");
            confesscompany.setDistrict(areacode);
        }
        if (confesscompany.getId() == null) {
            Confesscompany checkConfesscompany = this.confesscompanyDao.findApproveByCompanyName(confesscompany);
            if (checkConfesscompany != null) {
                throw new ArsException(confesscompany.getCompanyname() + "(\u540d\u79f0)\u91cd\u590d\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
            }
            checkConfesscompany = this.confesscompanyDao.findApproveByCreditcode(confesscompany);
            if (checkConfesscompany != null) {
                throw new ArsException(confesscompany.getCreditcode() + "(\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801)\u91cd\u590d\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
            }
            confesscompany.setActive(Boolean.valueOf(true));
            confesscompany.setCreateTime(new Date());
            confesscompany.setUpdateTime(new Date());
            confesscompany.setUpdateBy(currentUser.getUsername());
            confesscompany.setUserid(currentUser.getId());
            this.confesscompanyDao.save(confesscompany);
        } else {
            Confesscompany checkConfesscompany = this.confesscompanyDao.findApproveByCompanyName(confesscompany);
            if (checkConfesscompany != null && checkConfesscompany.getId().longValue() != confesscompany.getId().longValue()) {
                throw new ArsException(confesscompany.getCompanyname() + "(\u540d\u79f0)\u91cd\u590d\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
            }
            checkConfesscompany = this.confesscompanyDao.findApproveByCreditcode(confesscompany);
            if (checkConfesscompany != null && checkConfesscompany.getId().longValue() != confesscompany.getId().longValue()) {
                throw new ArsException(confesscompany.getCreditcode() + "(\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801)\u91cd\u590d\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
            }
            Confesscompany dbConfesscompany = this.confesscompanyDao.findById(confesscompany.getId());
            if ("001".equals(confesscompany.getApprovalstate())) {
                BeanUtils.copyPropertiesIgnore((Object)confesscompany, (Object)dbConfesscompany, (String)"active,createTime,userid", (Boolean)true);
            } else {
                BeanUtils.copyPropertiesIgnore((Object)confesscompany, (Object)dbConfesscompany, (Boolean)true);
            }
            dbConfesscompany.setUpdateTime(new Date());
            dbConfesscompany.setUpdateBy(currentUser.getUsername());
            dbConfesscompany.setOtherCompanyTypeName(confesscompany.getOtherCompanyTypeName());
            dbConfesscompany.setOtherSecScopeType(confesscompany.getOtherSecScopeType());
            this.confesscompanyDaoAop.update(dbConfesscompany);
        }
    }

    public void searchForPage(ConfesscompanySearchDto dto, AjaxPageResponse<Confesscompany> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.confesscompanyDao.searchForPage(dto, page);
    }

    public void saveOrUpdate(Confesscompany confesscompany) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (confesscompany.getOrgid() == null) {
            if (confesscompany.getDistrictOrgId() != null) {
                confesscompany.setOrgid(Long.valueOf(Long.parseLong(confesscompany.getDistrictOrgId())));
            } else if (confesscompany.getCityOrgId() != null) {
                confesscompany.setOrgid(Long.valueOf(Long.parseLong(confesscompany.getCityOrgId())));
            }
        }
        if (currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4) {
            confesscompany.setUserid(currentUser.getId());
        }
        if (null != confesscompany.getCompanytype() && !confesscompany.getCompanytype().contains("9") || null == confesscompany.getCompanytype()) {
            confesscompany.setOtherCompanyTypeName(null);
        }
        if (confesscompany.getId() == null) {
            if (!"001".equals(confesscompany.getApprovalstate())) {
                Confesscompany checkConfesscompany = this.confesscompanyDao.findApproveByCompanyName(confesscompany);
                if (checkConfesscompany != null) {
                    throw new ArsException(confesscompany.getCompanyname() + "(\u540d\u79f0)\u91cd\u590d\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
                }
                checkConfesscompany = this.confesscompanyDao.findApproveByCreditcode(confesscompany);
                if (checkConfesscompany != null) {
                    throw new ArsException(confesscompany.getCreditcode() + "(\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801)\u91cd\u590d\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
                }
            }
            confesscompany.setActive(Boolean.valueOf(true));
            confesscompany.setCreateTime(new Date());
            confesscompany.setUpdateTime(new Date());
            confesscompany.setUpdateBy(currentUser.getUsername());
            this.confesscompanyDao.save(confesscompany);
            if (confesscompany.isIsauto() && "002".equals(confesscompany.getApprovalstate())) {
                this.approvalUtil.saveApproval("006", confesscompany.getId(), "activiticonfesscompanyapprovalProcess");
            }
        } else {
            if (!confesscompany.getApprovalstate().equals("001")) {
                Confesscompany checkConfesscompany = this.confesscompanyDao.findApproveByCompanyName(confesscompany);
                if (checkConfesscompany != null && checkConfesscompany.getId().longValue() != confesscompany.getId().longValue()) {
                    throw new ArsException(confesscompany.getCompanyname() + "(\u540d\u79f0)\u91cd\u590d\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
                }
                checkConfesscompany = this.confesscompanyDao.findApproveByCreditcode(confesscompany);
                if (checkConfesscompany != null && checkConfesscompany.getId().longValue() != confesscompany.getId().longValue()) {
                    throw new ArsException(confesscompany.getCreditcode() + "(\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801)\u91cd\u590d\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
                }
            }
            Confesscompany dbConfesscompany = this.confesscompanyDao.findById(confesscompany.getId());
            boolean activity = true;
            if (StringUtil.isNotEmpty((String)dbConfesscompany.getApprovalstate()) && dbConfesscompany.getApprovalstate().equals("002") && dbConfesscompany.getOrgid().toString().equals(confesscompany.getOrgid().toString())) {
                Approval approval;
                activity = false;
                if (!dbConfesscompany.getCompanyname().equals(confesscompany.getCompanyname()) && (approval = this.approvalDAO.findBybusinessidAndType(confesscompany.getId(), "006")) != null) {
                    this.approvalUtil.updateContent(approval, confesscompany.getCompanyname());
                }
            }
            if ("001".equals(confesscompany.getApprovalstate())) {
                BeanUtils.copyPropertiesIgnore((Object)confesscompany, (Object)dbConfesscompany, (String)"active,createTime,userid", (Boolean)true);
            } else {
                BeanUtils.copyPropertiesIgnore((Object)confesscompany, (Object)dbConfesscompany, (Boolean)true);
            }
            dbConfesscompany.setUpdateTime(new Date());
            dbConfesscompany.setUpdateBy(currentUser.getUsername());
            dbConfesscompany.setOtherCompanyTypeName(confesscompany.getOtherCompanyTypeName());
            if (!dbConfesscompany.isIsauto()) {
                if (confesscompany.getApprovalstate() != null && !"".equals(confesscompany.getApprovalstate()) && !"002".equals(confesscompany.getApprovalstate())) {
                    dbConfesscompany.setApprovalstate(confesscompany.getApprovalstate());
                }
            } else if (confesscompany.getApprovalstate() != null && !"".equals(confesscompany.getApprovalstate()) && !"002".equals(confesscompany.getApprovalstate())) {
                dbConfesscompany.setApprovalstate(confesscompany.getApprovalstate());
            } else {
                dbConfesscompany.setApprovalstate("002");
                dbConfesscompany.setChargecensorstatus("");
                dbConfesscompany.setLegalcensorstatus("");
            }
            this.confesscompanyDaoAop.update(dbConfesscompany);
            if (activity && "002".equals(dbConfesscompany.getApprovalstate())) {
                this.approvalUtil.saveApproval("006", dbConfesscompany.getId(), "activiticonfesscompanyapprovalProcess");
            }
            if (dbConfesscompany.getApprovalstate() != null && dbConfesscompany.getApprovalstate().equals("003")) {
                new Thread(() -> {
                    try {
                        Zxzybaydwxx zxzybaydwxx = new Zxzybaydwxx();
                        zxzybaydwxx.setDwbm(dbConfesscompany.getLicencenum());
                        this.clientUtil.send("xxba_zxzybaydwxx", (Object)zxzybaydwxx);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }).start();
            }
        }
    }

    public void saveOrUpdateForDS(Confesscompany confesscompany) {
        Confesscompany dbConfesscompany;
        if (confesscompany.getActive() == null) {
            confesscompany.setActive(Boolean.valueOf(true));
        }
        if ((dbConfesscompany = this.confesscompanyDao.findById(confesscompany.getId())) != null) {
            if (confesscompany.getUpdateTime().getTime() > dbConfesscompany.getUpdateTime().getTime()) {
                confesscompany.setChargecensorstatus(dbConfesscompany.getChargecensorstatus());
                confesscompany.setLegalcensorstatus(dbConfesscompany.getLegalcensorstatus());
                this.confesscompanyDaoAop.update(confesscompany);
            }
        } else {
            this.confesscompanyDao.save(confesscompany);
        }
    }

    public ConfesscompanySearchDto search(ConfesscompanySearchDto dto) {
        ConfesscompanySearchDto resultDto = new ConfesscompanySearchDto();
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = this.policeDao.findById(currentUser.getOrgid());
        String areacode = "";
        if (dto.getAreaCode() != null) {
            areacode = dto.getAreaCode();
        } else if (police != null) {
            areacode = police.getAreacode();
        }
        if (areacode.endsWith("0000")) {
            dto.setDistrict(areacode.substring(0, 2) + "____");
        } else if (areacode.endsWith("00")) {
            dto.setDistrict(areacode.substring(0, 4) + "__");
        } else {
            dto.setDistrict(areacode);
        }
        List list = this.confesscompanyDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.confesscompanyDao.searchCount(dto));
        return resultDto;
    }

    public Confesscompany findByUser(Long userid) {
        return this.confesscompanyDao.findByUser(userid);
    }

    public List<Confesscompany> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.confesscompanyDao.searchForDataSynchronization(dto);
    }

    public List<Confesscompany> findAll() {
        return this.confesscompanyDao.findAll();
    }

    public PageResult searchConfesscompanyList_table(Map<Object, Object> p) {
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = currentUser.getPolice();
        String areacode = "";
        if (p.get("areaCode") != null) {
            areacode = p.get("areaCode").toString();
        } else if (police != null) {
            areacode = police.getAreacode();
        }
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                p.put("district", areacode.substring(0, 4) + "__");
            } else {
                p.put("district", areacode);
            }
        }
        if (police != null && "4".equals(police.getOrgtype())) {
            p.put("orgid", police.getId());
        }
        p.put("isauto", "1");
        if (p.get("checkType") != null && currentUser != null) {
            p.put("userid", currentUser.getId());
        }
        return new PageResult(Integer.valueOf(this.confesscompanyDao.countConfesscompanyList(p)), (Object)this.confesscompanyDao.searchConfesscompanyList(p));
    }

    public void delete(Confesscompany confesscompany) {
        confesscompany.setUpdateTime(new Date());
        this.confesscompanyDaoAop.delete(confesscompany);
    }

    public void saveOrUpdateForApproval(Confesscompany confesscompany) {
        confesscompany.setUpdateTime(new Date());
        this.confesscompanyDaoAop.update(confesscompany);
    }

    public Map<String, Object> selectApplyUserInfoWithId(Long id) {
        return this.confesscompanyDao.selectApplyUserInfoWithId(id);
    }

    public void updateCensorStatus(Confesscompany confesscompany) {
        this.confesscompanyDaoAop.update(confesscompany);
    }

    public void saveOrUpdateForApprovalImport(Confesscompany confcesscompany) {
        this.confesscompanyDaoAop.update(confcesscompany);
    }
}

