/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.PoliceRoleDao;
import com.bcxin.ars.dao.RoleDao;
import com.bcxin.ars.dao.UserRoleDao;
import com.bcxin.ars.dto.UserRoleSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.UserRole;
import com.bcxin.ars.service.UserRoleService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserRoleServiceImpl
implements UserRoleService {
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private PoliceRoleDao policeRoleDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private ArsUtil arsUtil;

    public UserRole findById(long id) {
        return this.userRoleDao.findById(id);
    }

    public void saveOrUpdate(UserRole userRole) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (userRole.getId() == null) {
            userRole.setActive(Boolean.valueOf(true));
            userRole.setCreateTime(new Date());
            userRole.setUpdateTime(new Date());
            userRole.setUpdateBy(currentUser.getUsername());
            this.userRoleDao.save(userRole);
        } else {
            UserRole dbUserRole = this.userRoleDao.findById(userRole.getId().longValue());
            dbUserRole.setUpdateBy(currentUser.getUsername());
            dbUserRole.setUpdateTime(new Date());
            dbUserRole.setUserid(userRole.getUserid());
            dbUserRole.setRoleid(userRole.getRoleid());
            this.userRoleDao.update(dbUserRole);
        }
    }

    public UserRoleSearchDto search(UserRoleSearchDto dto) {
        UserRoleSearchDto resultDto = new UserRoleSearchDto();
        List list = this.userRoleDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.userRoleDao.searchCount(dto));
        return resultDto;
    }

    public void delete(UserRole userRole) {
        User currentUser = this.arsUtil.getCurrentUser();
        userRole.setUpdateBy(currentUser.getUsername());
        userRole.setUpdateTime(new Date());
        this.userRoleDao.delete(userRole);
    }

    public List<UserRole> findByUserId(Long userid) {
        return this.userRoleDao.findByUserId(userid);
    }

    public List<UserRole> findByRoleId(Long roleid) {
        return this.userRoleDao.findByRoleId(roleid);
    }

    public List<UserRole> findByUserIdAndRoleType(Long userid, String roleType) {
        List userRoles = this.userRoleDao.findByUserIdAndRoleType(userid, roleType);
        for (UserRole userRole : userRoles) {
            if (roleType.equals("2")) {
                userRole.setPoliceRole(this.policeRoleDao.findById(userRole.getRoleid().longValue()));
                continue;
            }
            if (!roleType.equals("1")) continue;
            userRole.setRole(this.roleDao.findById(userRole.getRoleid()));
        }
        return userRoles;
    }

    public List<UserRole> findByRoleIdAndRoleType(Long roleid, String roleType) {
        List userRoles = this.userRoleDao.findByRoleIdAndRoleType(roleid, roleType);
        for (UserRole userRole : userRoles) {
            if (roleType.equals("2")) {
                userRole.setPoliceRole(this.policeRoleDao.findById(userRole.getRoleid().longValue()));
                continue;
            }
            if (!roleType.equals("1")) continue;
            userRole.setRole(this.roleDao.findById(userRole.getRoleid()));
        }
        return userRoles;
    }

    public UserRole findByUserIdAndRoleId(Long userId, Long roleId) {
        return this.userRoleDao.findByUserIdAndRoleId(userId, roleId);
    }

    public List<UserRole> findAll() {
        return this.userRoleDao.findAll();
    }

    public void saveOrUpdateForDS(UserRole userRole) {
        UserRole dbUserRole = this.userRoleDao.findByUserIdAndRoleId(userRole.getUserid(), userRole.getRoleid());
        if (dbUserRole != null) {
            if (userRole.getUpdateTime().getTime() > dbUserRole.getUpdateTime().getTime()) {
                this.userRoleDao.update(userRole);
            }
        } else if (userRole.getActive().booleanValue()) {
            this.userRoleDao.save(userRole);
        }
    }
}

