/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.SbPunishDao;
import com.bcxin.ars.dao.SbRewardDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityGoodThingDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.SecurityPersonExperienceDao;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityGoodThing;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.SecurityPersonExperience;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SecurityPersonExperienceService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.xiaoleilu.hutool.util.ObjectUtil;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SecurityPersonExperienceServiceImpl
implements SecurityPersonExperienceService {
    @Autowired
    private SecurityPersonExperienceDao securityPersonExperienceDao;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private SecurityCompanyDao companyDao;
    @Autowired
    private SecurityGoodThingDao goodThingDao;
    @Autowired
    private SbPunishDao punishDao;
    @Autowired
    private SbRewardDao rewardDao;
    @Autowired
    private ArsUtil arsUtil;

    public void delete(SecurityPersonExperience personExperience) {
        User currentUser = this.arsUtil.getCurrentUser();
        personExperience.setUpdateBy(currentUser.getUsername());
        personExperience.setUpdateTime(new Date());
        this.securityPersonExperienceDao.delete(personExperience);
    }

    public SecurityPersonExperience findById(Long experienceId) {
        return this.securityPersonExperienceDao.findById(experienceId);
    }

    public List<SecurityPersonExperience> findByPersonId(Long personId) {
        return this.securityPersonExperienceDao.findByPersonId(personId);
    }

    public void saveOrUpdate(SecurityPersonExperience securityPersonExperience) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (securityPersonExperience.getId() != null) {
            SecurityPersonExperience dbSecurityPersonExperience = this.securityPersonExperienceDao.findById(securityPersonExperience.getId());
            dbSecurityPersonExperience.setCompanyAddress(securityPersonExperience.getCompanyAddress());
            dbSecurityPersonExperience.setCompanyName(securityPersonExperience.getCompanyName());
            dbSecurityPersonExperience.setDepartment(securityPersonExperience.getDepartment());
            dbSecurityPersonExperience.setEndDate(securityPersonExperience.getEndDate());
            dbSecurityPersonExperience.setPost(securityPersonExperience.getPost());
            dbSecurityPersonExperience.setStartDate(securityPersonExperience.getStartDate());
            dbSecurityPersonExperience.setUpdateBy(currentUser.getUsername());
            dbSecurityPersonExperience.setUpdateTime(new Date());
            dbSecurityPersonExperience.setWorkContent(securityPersonExperience.getWorkContent());
            dbSecurityPersonExperience.setOrgId(securityPersonExperience.getOrgId());
            this.securityPersonExperienceDao.update(dbSecurityPersonExperience);
        } else {
            securityPersonExperience.setActive(Boolean.valueOf(true));
            securityPersonExperience.setUpdateBy(currentUser.getUsername());
            securityPersonExperience.setCreateTime(new Date());
            securityPersonExperience.setUpdateTime(new Date());
            this.securityPersonExperienceDao.save(securityPersonExperience);
        }
    }

    public List<SecurityPersonExperience> findByIdNum(String idNum) {
        return this.securityPersonExperienceDao.findByIdNum(idNum);
    }

    public List<SecurityPersonExperience> searchForPage(SecurityPersonExperience dto, AjaxPageResponse<SecurityGoodThing> ajaxPageResponse) {
        return null;
    }

    public List<SecurityPersonExperience> findByPersonIdForPunishAndReward(Long personId) {
        SecurityPerson person = this.securityPersonDao.findById(personId);
        if (null == person) {
            return null;
        }
        List experiences = this.securityPersonExperienceDao.findByIdNum(person.getIdNumber());
        List goodThings = this.goodThingDao.findByIdNum(person.getIdNumber());
        List punishs = this.punishDao.findByIdNum(person.getIdNumber());
        List rewards = this.rewardDao.findByIdNum(person.getIdNumber());
        experiences.forEach(experience -> {
            SecurityCompany company;
            if (experience.getCompanyId() != null && (company = this.companyDao.findById(experience.getCompanyId())) != null) {
                List goodThingList = goodThings.stream().filter(goodThing -> ObjectUtil.equal((Object)company.getUserid(), (Object)goodThing.getUserid())).collect(Collectors.toList());
                List punishList = punishs.stream().filter(punish -> ObjectUtil.equal((Object)company.getUserid(), (Object)punish.getUserid())).collect(Collectors.toList());
                List rewardList = rewards.stream().filter(reward -> ObjectUtil.equal((Object)company.getUserid(), (Object)reward.getUserid())).collect(Collectors.toList());
                experience.setGoodThingList(goodThingList);
                experience.setPunishList(punishList);
                experience.setRewardList(rewardList);
            }
        });
        return experiences;
    }
}

