/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.OrderNoLogDao;
import com.bcxin.ars.model.OrderNoLog;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.OrderNoLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderNoLogServiceImpl
implements OrderNoLogService {
    @Autowired
    private OrderNoLogDao orderNoLogDao;
    @Autowired
    private ArsUtil arsUtil;

    public void save(OrderNoLog orderNoLog) {
        this.orderNoLogDao.save(orderNoLog);
    }

    public OrderNoLog findById(Long id) {
        return this.orderNoLogDao.findById(id);
    }

    public List<OrderNoLog> findListByDate(String date) {
        return this.orderNoLogDao.findListByDate(date);
    }

    public Long findMaxSerialNoByDate(String date) {
        return this.orderNoLogDao.findMaxSerialNoByDate(date);
    }

    public String getNewOrderNo() {
        User user = this.arsUtil.getCurrentUser();
        String today = DateUtil.getCurrentDate((String)"yyyyMMdd");
        Long serialNo = this.orderNoLogDao.findMaxSerialNoByDate(today);
        serialNo = serialNo == null ? Long.valueOf(1L) : Long.valueOf(serialNo + 1L);
        String orderNo = today + StringUtil.addZero((String)(serialNo + ""), (int)3);
        OrderNoLog orderNoLog = new OrderNoLog();
        orderNoLog.setActive(Boolean.valueOf(true));
        orderNoLog.setCreateTime(new Date());
        orderNoLog.setDate(today);
        orderNoLog.setOrderNo(orderNo);
        orderNoLog.setSerialNo(serialNo.longValue());
        orderNoLog.setUpdateBy(user.getUsername());
        orderNoLog.setUpdateTime(new Date());
        this.orderNoLogDao.save(orderNoLog);
        return orderNo;
    }
}

