/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.EnrolmentLeaveBeijingDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.EnrolmentLeaveBeijingSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.EnrolmentLeaveBeijing;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.EnrolmentLeaveBeijingService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=EnrolmentLeaveBeijing.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
public class EnrolmentLeaveBeijingServiceImpl
implements EnrolmentLeaveBeijingService {
    Logger logger = LoggerFactory.getLogger(EnrolmentLeaveBeijingServiceImpl.class);
    @Autowired
    private EnrolmentLeaveBeijingDao enrolmentLeaveBeijingDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(EnrolmentLeaveBeijing enrolmentLeaveBeijing) {
        User currentUser = this.arsUtil.getCurrentUser();
        enrolmentLeaveBeijing.setUpdateTime(new Date());
        enrolmentLeaveBeijing.setUpdateBy(currentUser.getUsername());
        return this.enrolmentLeaveBeijingDao.delete(enrolmentLeaveBeijing);
    }

    public int save(EnrolmentLeaveBeijing enrolmentLeaveBeijing) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (enrolmentLeaveBeijing.getId() == null) {
            enrolmentLeaveBeijing.setCreateTime(new Date());
        } else {
            EnrolmentLeaveBeijing dbEnrolmentLeaveBeijing = this.enrolmentLeaveBeijingDao.findById(enrolmentLeaveBeijing.getId());
            BeanUtils.copyPropertiesIgnore((Object)enrolmentLeaveBeijing, (Object)dbEnrolmentLeaveBeijing, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbEnrolmentLeaveBeijing, (Object)enrolmentLeaveBeijing, (Boolean)false);
        }
        if (2 == currentUser.getPlatform()) {
            SecurityCompany company = this.securityCompanyDao.findByUserid(currentUser.getId());
            enrolmentLeaveBeijing.setComId(company.getId());
            if (StringUtil.isNotEmpty((String)company.getOrgId())) {
                enrolmentLeaveBeijing.setOrgId(Long.valueOf(Long.parseLong(company.getOrgId())));
            }
            enrolmentLeaveBeijing.setComName(company.getName());
            enrolmentLeaveBeijing.setAreaCode(company.getAreaCode());
        }
        enrolmentLeaveBeijing.setFillerName(currentUser.getRealname());
        enrolmentLeaveBeijing.setFillerPhone(currentUser.getPhone());
        enrolmentLeaveBeijing.setActive(Boolean.valueOf(true));
        enrolmentLeaveBeijing.setUpdateBy(currentUser.getUsername());
        enrolmentLeaveBeijing.setUpdateTime(new Date());
        enrolmentLeaveBeijing.setUpdateflag(Boolean.valueOf(true));
        return this.enrolmentLeaveBeijingDao.save(enrolmentLeaveBeijing);
    }

    public EnrolmentLeaveBeijing findById(Long id) {
        return this.enrolmentLeaveBeijingDao.findById(id);
    }

    public void searchForPage(EnrolmentLeaveBeijingSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        User currrentUser = this.arsUtil.getCurrentUser();
        if (currrentUser.getPlatform() == 2) {
            SecurityCompany company = this.securityCompanyDao.findByUserid(currrentUser.getId());
            dto.setComId(company.getId());
        }
        this.enrolmentLeaveBeijingDao.searchForPage(dto, page);
    }

    public void importBatch(List<EnrolmentLeaveBeijing> list) {
        List dbList = this.enrolmentLeaveBeijingDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (EnrolmentLeaveBeijing enrolmentLeaveBeijing : list) {
                enrolmentLeaveBeijing.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    enrolmentLeaveBeijing.setUpdateTime(DateUtil.dateAdd((int)6, (Date)enrolmentLeaveBeijing.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.enrolmentLeaveBeijingDao.saveBatch(list);
        }
    }

    public List<EnrolmentLeaveBeijing> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.enrolmentLeaveBeijingDao.searchForDataSynchronization(dto);
    }

    public List<EnrolmentLeaveBeijing> findDSOutList(String startDate) {
        return this.enrolmentLeaveBeijingDao.findDSOutList(startDate);
    }

    public List<EnrolmentLeaveBeijing> findByBatchId(List<EnrolmentLeaveBeijing> list) {
        return this.enrolmentLeaveBeijingDao.findByBatchId(list);
    }

    public void updateSelective(EnrolmentLeaveBeijing enrolmentLeaveBeijing) {
        User currentUser = this.arsUtil.getCurrentUser();
        enrolmentLeaveBeijing.setUpdateTime(new Date());
        enrolmentLeaveBeijing.setUpdateBy(currentUser.getUsername());
        this.enrolmentLeaveBeijingDao.updateSelective(enrolmentLeaveBeijing);
    }
}

