/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.DatasyncDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.DatasyncSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Datasync;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.DatasyncService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.HttpClientUtils;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
public class DatasyncServiceImpl
implements DatasyncService {
    private Logger logger = LoggerFactory.getLogger(DatasyncServiceImpl.class);
    @Autowired
    private DatasyncDao datasyncDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private DataSyncUtil dataSyncUtil;

    public void saveOrUpdate(Datasync datasync) {
        User user = this.arsUtil.getCurrentUser();
        Datasync dbDatasync = this.datasyncDao.findById(datasync.getId());
        if (dbDatasync != null) {
            dbDatasync.setUpdateTime(new Date());
            dbDatasync.setUpdateBy(user.getRealname());
            if (!StringUtils.isEmpty((Object)datasync.getOpdate())) {
                dbDatasync.setOpdate(datasync.getOpdate());
            }
            if (!StringUtils.isEmpty((Object)datasync.getOpfun())) {
                dbDatasync.setOpfun(datasync.getOpfun());
            }
            if (!StringUtils.isEmpty((Object)datasync.getState())) {
                dbDatasync.setState(datasync.getState());
            }
            this.datasyncDao.update(dbDatasync);
        } else {
            datasync.setCreateTime(new Date());
            datasync.setUpdateTime(datasync.getCreateTime());
            datasync.setActive(Boolean.valueOf(true));
            datasync.setUpdateBy(user.getUsername());
            this.datasyncDao.save(datasync);
        }
    }

    public void delete(Datasync datasync) {
        datasync.setUpdateTime(new Date());
        this.datasyncDao.delete(datasync);
    }

    public Datasync findById(long id) {
        return this.datasyncDao.findById(Long.valueOf(id));
    }

    public Datasync findByBid(long bid) {
        return this.datasyncDao.findByBid(Long.valueOf(bid));
    }

    public DatasyncSearchDto search(DatasyncSearchDto dto) {
        DatasyncSearchDto resultDto = new DatasyncSearchDto();
        List list = this.datasyncDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(Long.valueOf(this.datasyncDao.count(dto)));
        return resultDto;
    }

    public List<Datasync> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.datasyncDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(Datasync datasync) {
        Datasync dbDatasync = this.datasyncDao.findById(datasync.getId());
        if (dbDatasync == null) {
            this.datasyncDao.saveForDS(datasync);
        } else if (datasync.getUpdateTime().getTime() > dbDatasync.getUpdateTime().getTime()) {
            this.datasyncDao.update(datasync);
        }
    }

    public void createToOutDataFile(String startDate) {
        boolean updateKey = false;
        if (StringUtils.isEmpty((Object)startDate)) {
            updateKey = true;
            startDate = DateUtil.getYesterday();
            Config lastDateConfig = this.configUtils.getConfigByKey("dataSyncLastDate");
            if (lastDateConfig != null && !DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM-dd").equals(lastDateConfig.getValue())) {
                startDate = lastDateConfig.getValue();
            }
        }
        String dirDate = DateUtil.getCurrentDate();
        String filePath = this.configUtils.intToOutFolder + dirDate + File.separatorChar;
        this.dataSyncUtil.createDSFile(startDate, filePath);
        if (updateKey) {
            Config updateConfig = new Config();
            updateConfig.setKey("dataSyncLastDate");
            updateConfig.setValue(DateUtil.getCurrentDate());
            this.configUtils.updateForKey(updateConfig);
        }
    }

    public void createToOutDataFileByHttp(String startDate) {
        boolean updateKey = false;
        if (StringUtils.isEmpty((Object)startDate)) {
            updateKey = true;
            startDate = DateUtil.getYesterday();
            Config lastDateConfig = this.configUtils.getConfigByKey("dataSyncLastDate");
            if (lastDateConfig != null && !DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM-dd").equals(lastDateConfig.getValue())) {
                startDate = lastDateConfig.getValue();
            }
        }
        String dirDate = DateUtil.getCurrentDate();
        String filePath = this.configUtils.uploadInToOutFolder + dirDate + File.separatorChar;
        String resultPath = this.dataSyncUtil.createDSFile(startDate, filePath);
        try {
            AjaxResult ajaxResult = HttpClientUtils.FilePost((String)this.configUtils.GX_IN_URL, (File)new File(resultPath));
            if (ajaxResult.isSuccessful() && updateKey) {
                Config updateConfig = new Config();
                updateConfig.setKey("dataSyncLastDate");
                updateConfig.setValue(DateUtil.getCurrentDate());
                this.configUtils.updateForKey(updateConfig);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

