/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.CommonComplaintDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.CommonComplaintPageSearchDto;
import com.bcxin.ars.model.CommonComplaint;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.CommonComplaintService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CommonComplaintServiceImpl
implements CommonComplaintService {
    Logger logger = LoggerFactory.getLogger(CommonComplaintServiceImpl.class);
    @Autowired
    private CommonComplaintDao commonComplaintDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(CommonComplaint commonComplaint) {
        User currentUser = this.arsUtil.getCurrentUser();
        commonComplaint.setUpdateTime(new Date());
        commonComplaint.setUpdateBy(currentUser.getUsername());
        return this.commonComplaintDao.delete(commonComplaint);
    }

    public int save(CommonComplaint commonComplaint) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (commonComplaint.getId() == null) {
            commonComplaint.setCreateTime(new Date());
        } else {
            CommonComplaint dbCommonComplaint = this.commonComplaintDao.findById(commonComplaint.getId());
            BeanUtils.copyPropertiesIgnore((Object)commonComplaint, (Object)dbCommonComplaint, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbCommonComplaint, (Object)commonComplaint, (Boolean)false);
        }
        commonComplaint.setActive(Boolean.valueOf(true));
        commonComplaint.setUpdateBy(currentUser.getUsername());
        commonComplaint.setUpdateTime(new Date());
        commonComplaint.setUpdateflag(Boolean.valueOf(true));
        commonComplaint.setUserId(currentUser.getId());
        commonComplaint.setAreaCode(currentUser.getPolice().getAreacode());
        return this.commonComplaintDao.save(commonComplaint);
    }

    public CommonComplaint findById(Long id) {
        return this.commonComplaintDao.findById(id);
    }

    public void searchForPage(CommonComplaintPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.commonComplaintDao.searchForPage(dto, page);
    }

    public void importBatch(List<CommonComplaint> list) {
        List dbList = this.commonComplaintDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (CommonComplaint commonComplaint : list) {
                commonComplaint.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    commonComplaint.setUpdateTime(DateUtil.dateAdd((int)6, (Date)commonComplaint.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.commonComplaintDao.saveBatch(list);
        }
    }

    public List<CommonComplaint> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.commonComplaintDao.searchForDataSynchronization(dto);
    }

    public List<CommonComplaint> findDSOutList(String startDate) {
        return this.commonComplaintDao.findDSOutList(startDate);
    }

    public List<CommonComplaint> findByBatchId(List<CommonComplaint> list) {
        return this.commonComplaintDao.findByBatchId(list);
    }

    public void updateSelective(CommonComplaint commonComplaint) {
        User currentUser = this.arsUtil.getCurrentUser();
        commonComplaint.setUpdateTime(new Date());
        commonComplaint.setUpdateBy(currentUser.getUsername());
        this.commonComplaintDao.updateSelective(commonComplaint);
    }
}

