/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.AnnualSurveyReportDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.AnnualSurveyReportPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.AnnualSurveyReport;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.AnnualSurveyReportService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.FileUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DataSyncAnnotation(getClazz=AnnualSurveyReport.class, getMethodName="importBatch", getImportType=ImportType.BATCH)
public class AnnualSurveyReportServiceImpl
implements AnnualSurveyReportService {
    Logger logger = LoggerFactory.getLogger(AnnualSurveyReportServiceImpl.class);
    @Autowired
    private AnnualSurveyReportDao annualSurveyReportDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(AnnualSurveyReport annualSurveyReport) {
        User currentUser = this.arsUtil.getCurrentUser();
        annualSurveyReport.setUpdateTime(new Date());
        annualSurveyReport.setUpdateBy(currentUser.getUsername());
        return this.annualSurveyReportDao.delete(annualSurveyReport);
    }

    public int save(AnnualSurveyReport annualSurveyReport) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (annualSurveyReport.getId() == null) {
            annualSurveyReport.setCreateTime(new Date());
        } else {
            AnnualSurveyReport dbAnnualSurveyReport = this.annualSurveyReportDao.findById(annualSurveyReport.getId());
            BeanUtils.copyPropertiesIgnore((Object)annualSurveyReport, (Object)dbAnnualSurveyReport, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbAnnualSurveyReport, (Object)annualSurveyReport, (Boolean)false);
        }
        annualSurveyReport.setAppraiseTotal(Integer.valueOf(annualSurveyReport.getPrimaryNum() + annualSurveyReport.getMiddleNum() + annualSurveyReport.getAdminNum()));
        annualSurveyReport.setBeTotalNum(Integer.valueOf(annualSurveyReport.getBeCollegeNum() + annualSurveyReport.getBePrivateNum() + annualSurveyReport.getBeTrainNum() + annualSurveyReport.getBeSelfNum() + annualSurveyReport.getBeOther()));
        annualSurveyReport.setBeTotalPerNum(Integer.valueOf(annualSurveyReport.getBeCollegePerNum() + annualSurveyReport.getBePrivatePerNum() + annualSurveyReport.getBeTrainPerNum() + annualSurveyReport.getBeSelfPerNum() + annualSurveyReport.getBeOtherPer()));
        annualSurveyReport.setOnTotalNum(Integer.valueOf(annualSurveyReport.getOnCollegeNum() + annualSurveyReport.getOnPrivateNum() + annualSurveyReport.getOnTrainNum() + annualSurveyReport.getOnSelfNum() + annualSurveyReport.getOnOther()));
        annualSurveyReport.setOnTotalPerNum(Integer.valueOf(annualSurveyReport.getOnCollegePerNum() + annualSurveyReport.getOnPrivatePerNum() + annualSurveyReport.getOnTrainPerNum() + annualSurveyReport.getOnSelfPerNum() + annualSurveyReport.getOnOtherPer()));
        if (StringUtil.isEmpty((String)annualSurveyReport.getFillYear())) {
            annualSurveyReport.setFillYear(DateUtil.getCurrentDate((String)"yyyy"));
        }
        annualSurveyReport.setActive(Boolean.valueOf(true));
        annualSurveyReport.setUpdateBy(currentUser.getUsername());
        annualSurveyReport.setUpdateTime(new Date());
        annualSurveyReport.setUpdateflag(Boolean.valueOf(true));
        annualSurveyReport.setUserId(currentUser.getId());
        if (2 == currentUser.getPlatform()) {
            SecurityCompany company = this.securityCompanyDao.findByUserid(currentUser.getId());
            annualSurveyReport.setComId(company.getId());
            if (StringUtil.isNotEmpty((String)company.getOrgId())) {
                annualSurveyReport.setOrgId(Long.valueOf(Long.parseLong(company.getOrgId())));
            }
            annualSurveyReport.setAreaCode(company.getAreaCode());
        }
        return this.annualSurveyReportDao.save(annualSurveyReport);
    }

    public AnnualSurveyReport findById(Long id) {
        return this.annualSurveyReportDao.findById(id);
    }

    public void searchForPage(AnnualSurveyReportPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.annualSurveyReportDao.searchForPage(dto, page);
    }

    public void importBatch(List<AnnualSurveyReport> list) {
        List dbList = this.annualSurveyReportDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (AnnualSurveyReport annualSurveyReport : list) {
                annualSurveyReport.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    annualSurveyReport.setUpdateTime(DateUtil.dateAdd((int)6, (Date)annualSurveyReport.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.annualSurveyReportDao.saveBatch(list);
        }
    }

    public List<AnnualSurveyReport> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.annualSurveyReportDao.searchForDataSynchronization(dto);
    }

    public List<AnnualSurveyReport> findDSOutList(String startDate) {
        return this.annualSurveyReportDao.findDSOutList(startDate);
    }

    public List<AnnualSurveyReport> findByBatchId(List<AnnualSurveyReport> list) {
        return this.annualSurveyReportDao.findByBatchId(list);
    }

    public AnnualSurveyReport findByUserId(Long userId) {
        return this.annualSurveyReportDao.findByUserId(userId);
    }

    public AnnualSurveyReport findByUserIdAndFillYear(Long userId, String fillYear) {
        return this.annualSurveyReportDao.findByUserIdAndFillYear(userId, fillYear);
    }

    public void updateSelective(AnnualSurveyReport annualSurveyReport) {
        User currentUser = this.arsUtil.getCurrentUser();
        annualSurveyReport.setUpdateTime(new Date());
        annualSurveyReport.setUpdateBy(currentUser.getUsername());
        this.annualSurveyReportDao.updateSelective(annualSurveyReport);
    }

    public String exportTotal(HttpServletRequest request) throws Exception {
        String userAgent = request.getHeader("user-agent");
        String tableExcelName = "\u4fdd\u5b89\u4ece\u4e1a\u5355\u4f4d\u548c\u4ece\u4e1a\u4eba\u5458\u60c5\u51b5\u5e74\u5ea6\u8c03\u67e5\u8868";
        tableExcelName = userAgent != null && userAgent.indexOf("Firefox") >= 0 || userAgent.indexOf("Chrome") >= 0 || userAgent.indexOf("Safari") >= 0 ? new String(tableExcelName.getBytes(), "ISO8859-1") : URLEncoder.encode(tableExcelName, "UTF8");
        String fillYear = DateUtil.getCurrentDate((String)"yyyy");
        AnnualSurveyReport report = this.annualSurveyReportDao.findToTal(fillYear);
        if (report == null) {
            throw new ArsException("\u6682\u65e0\u6570\u636e\u53ef\u5bfc\u51fa");
        }
        this.getBigDecimalTotal(report, fillYear);
        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(this.configUtils.tempfolder + dirDate);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = now.getTime() + "_total.xls";
        String filePath = this.configUtils.tempfolder + dirDate + "/" + fileName;
        String fileKey = "temp/" + dirDate + "/" + fileName;
        this.logger.info("\u8def\u5f84\uff1a " + filePath);
        FileUtil.copyTempFile((String)"/fileTemp/annualSurveyReportTemp.xls", (String)filePath, (HttpServletRequest)request);
        File file = new File(filePath);
        if (file != null) {
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)new FileInputStream(file));
            CellStyle valueStyle = AnnualSurveyReportServiceImpl.getStringStyle(workbook);
            HSSFSheet sheet1 = workbook.getSheetAt(1);
            sheet1.setForceFormulaRecalculation(true);
            this.setUnitInfo(report, (Row)sheet1.getRow(13), valueStyle);
            this.setPersonInfo(report, (Row)sheet1.getRow(34), valueStyle);
            this.setPersonInfo(report, (Row)sheet1.getRow(33), valueStyle);
            HSSFSheet sheet2 = workbook.getSheetAt(2);
            sheet2.setForceFormulaRecalculation(true);
            this.setTrainAppraisalInfo(report, sheet2, valueStyle);
            this.setTrainInfo(report, sheet2, valueStyle);
            FileOutputStream fileOut = new FileOutputStream(file);
            workbook.write((OutputStream)fileOut);
            fileOut.close();
            workbook.close();
            return filePath;
        }
        return null;
    }

    private void getBigDecimalTotal(AnnualSurveyReport report, String fillYear) {
        List list = this.annualSurveyReportDao.findByFillYear(fillYear);
        report.setFixedAssets("0");
        report.setAnnualTurnover("0");
        report.setAnnualProfitTax("0");
        report.setFine("0");
        report.setIncome("0");
        report.setRetrieve("0");
        for (AnnualSurveyReport surveyReport : list) {
            report.setFixedAssets(new BigDecimal(StringUtil.isEmpty((String)report.getFixedAssets()) ? "0" : report.getFixedAssets()).add(new BigDecimal(StringUtil.isEmpty((String)surveyReport.getFixedAssets()) ? "0" : surveyReport.getFixedAssets())).toString());
            report.setAnnualTurnover(new BigDecimal(StringUtil.isEmpty((String)report.getAnnualTurnover()) ? "0" : report.getAnnualTurnover()).add(new BigDecimal(StringUtil.isEmpty((String)surveyReport.getAnnualTurnover()) ? "0" : surveyReport.getAnnualTurnover())).toString());
            report.setAnnualProfitTax(new BigDecimal(StringUtil.isEmpty((String)report.getAnnualProfitTax()) ? "0" : report.getAnnualProfitTax()).add(new BigDecimal(StringUtil.isEmpty((String)surveyReport.getAnnualProfitTax()) ? "0" : surveyReport.getAnnualProfitTax())).toString());
            report.setFine(new BigDecimal(StringUtil.isEmpty((String)report.getFine()) ? "0" : report.getFine()).add(new BigDecimal(StringUtil.isEmpty((String)surveyReport.getFine()) ? "0" : surveyReport.getFine())).toString());
            report.setIncome(new BigDecimal(StringUtil.isEmpty((String)report.getIncome()) ? "0" : report.getIncome()).add(new BigDecimal(StringUtil.isEmpty((String)surveyReport.getIncome()) ? "0" : surveyReport.getIncome())).toString());
            report.setRetrieve(new BigDecimal(StringUtil.isEmpty((String)report.getRetrieve()) ? "0" : report.getRetrieve()).add(new BigDecimal(StringUtil.isEmpty((String)surveyReport.getRetrieve()) ? "0" : surveyReport.getRetrieve())).toString());
        }
    }

    private void setUnitInfo(AnnualSurveyReport report, Row row, CellStyle valueStyle) {
        this.setCellValue(row, valueStyle, 14, report.getCustNum() + "");
        this.setCellValue(row, valueStyle, 15, report.getFixedAssets() + "");
        this.setCellValue(row, valueStyle, 16, report.getAnnualTurnover() + "");
        this.setCellValue(row, valueStyle, 17, report.getAnnualProfitTax() + "");
        this.setCellValue(row, valueStyle, 23, report.getRubberNum() + "");
        this.setCellValue(row, valueStyle, 24, report.getVestNum() + "");
        this.setCellValue(row, valueStyle, 25, report.getWarnrNum() + "");
        this.setCellValue(row, valueStyle, 26, report.getFine() + "");
        this.setCellValue(row, valueStyle, 27, report.getIncome() + "");
        this.setCellValue(row, valueStyle, 28, report.getRevokeLiceNum() + "");
        this.setCellValue(row, valueStyle, 29, report.getCriminalNum() + "");
        this.setCellValue(row, valueStyle, 30, report.getCrimeOther() + "");
    }

    private void setPersonInfo(AnnualSurveyReport report, Row row, CellStyle valueStyle) {
        this.setCellValue(row, valueStyle, 4, report.getPerNum() + "");
        this.setCellValue(row, valueStyle, 6, report.getFePerNum() + "");
        this.setCellValue(row, valueStyle, 7, report.getCerNum() + "");
        this.setCellValue(row, valueStyle, 8, report.getManageNum() + "");
        this.setCellValue(row, valueStyle, 9, report.getCaseClueNum() + "");
        this.setCellValue(row, valueStyle, 11, report.getCaptureNum() + "");
        this.setCellValue(row, valueStyle, 13, report.getPreventNum() + "");
        this.setCellValue(row, valueStyle, 15, report.getRetrieve() + "");
        this.setCellValue(row, valueStyle, 17, report.getEventNum() + "");
        this.setCellValue(row, valueStyle, 18, report.getEventPerNum() + "");
        this.setCellValue(row, valueStyle, 19, report.getHandleNum() + "");
        this.setCellValue(row, valueStyle, 20, report.getHandlePerNum() + "");
        this.setCellValue(row, valueStyle, 21, report.getCudgelsNum() + "");
        this.setCellValue(row, valueStyle, 22, report.getInjuriesNum() + "");
        this.setCellValue(row, valueStyle, 23, report.getSacrificeNum() + "");
        this.setCellValue(row, valueStyle, 24, report.getNationalAdCollNum() + "");
        this.setCellValue(row, valueStyle, 25, report.getProvAdCollNum() + "");
        this.setCellValue(row, valueStyle, 26, report.getNationalAdindiNum() + "");
        this.setCellValue(row, valueStyle, 27, report.getProvAdindiNum() + "");
        this.setCellValue(row, valueStyle, 28, report.getRevokeCerNum() + "");
        this.setCellValue(row, valueStyle, 29, report.getPunishNum() + "");
        this.setCellValue(row, valueStyle, 30, report.getCriminalPerNum() + "");
    }

    private void setTrainInfo(AnnualSurveyReport report, HSSFSheet sheet, CellStyle valueStyle) {
        HSSFRow row1 = sheet.getRow(13);
        this.setCellValue((Row)row1, valueStyle, 4, report.getBeCollegeNum() + "");
        this.setCellValue((Row)row1, valueStyle, 5, report.getBeCollegePerNum() + "");
        this.setCellValue((Row)row1, valueStyle, 6, report.getOnCollegeNum() + "");
        this.setCellValue((Row)row1, valueStyle, 7, report.getOnCollegePerNum() + "");
        HSSFRow row2 = sheet.getRow(14);
        this.setCellValue((Row)row2, valueStyle, 4, report.getBePrivateNum() + "");
        this.setCellValue((Row)row2, valueStyle, 5, report.getBePrivatePerNum() + "");
        this.setCellValue((Row)row2, valueStyle, 6, report.getOnPrivateNum() + "");
        this.setCellValue((Row)row2, valueStyle, 7, report.getOnPrivatePerNum() + "");
        HSSFRow row3 = sheet.getRow(15);
        this.setCellValue((Row)row3, valueStyle, 4, report.getBeVocationalNum() + "");
        this.setCellValue((Row)row3, valueStyle, 5, report.getBeVocationalPerNum() + "");
        this.setCellValue((Row)row3, valueStyle, 6, report.getOnVocationalNum() + "");
        this.setCellValue((Row)row3, valueStyle, 7, report.getOnVocationalPerNum() + "");
        HSSFRow row4 = sheet.getRow(16);
        this.setCellValue((Row)row4, valueStyle, 4, report.getBeMartialNum() + "");
        this.setCellValue((Row)row4, valueStyle, 5, report.getBeMartialPerNum() + "");
        this.setCellValue((Row)row4, valueStyle, 6, report.getOnMartialNum() + "");
        this.setCellValue((Row)row4, valueStyle, 7, report.getOnMartialPerNum() + "");
        HSSFRow row5 = sheet.getRow(18);
        this.setCellValue((Row)row5, valueStyle, 4, report.getBeSelfNum() + "");
        this.setCellValue((Row)row5, valueStyle, 5, report.getBeSelfPerNum() + "");
        this.setCellValue((Row)row5, valueStyle, 6, report.getOnSelfNum() + "");
        this.setCellValue((Row)row5, valueStyle, 7, report.getOnSelfPerNum() + "");
        HSSFRow row6 = sheet.getRow(21);
        this.setCellValue((Row)row6, valueStyle, 4, report.getBeOther() + "");
        this.setCellValue((Row)row6, valueStyle, 5, report.getBeOtherPer() + "");
        this.setCellValue((Row)row6, valueStyle, 6, report.getOnOther() + "");
        this.setCellValue((Row)row6, valueStyle, 7, report.getOnOtherPer() + "");
    }

    private void setTrainAppraisalInfo(AnnualSurveyReport report, HSSFSheet sheet, CellStyle valueStyle) {
        HSSFRow row1 = sheet.getRow(12);
        this.setCellValue((Row)row1, valueStyle, 4, report.getBeTotalNum() + "");
        this.setCellValue((Row)row1, valueStyle, 5, report.getBeTotalPerNum() + "");
        this.setCellValue((Row)row1, valueStyle, 6, report.getOnTotalNum() + "");
        this.setCellValue((Row)row1, valueStyle, 7, report.getOnTotalPerNum() + "");
        this.setCellValue((Row)row1, valueStyle, 10, report.getAppraiseTotal() + "");
        this.setCellValue((Row)row1, valueStyle, 11, report.getPrimaryNum() + "");
        this.setCellValue((Row)row1, valueStyle, 12, report.getMiddleNum() + "");
        this.setCellValue((Row)row1, valueStyle, 14, report.getAdminNum() + "");
        HSSFRow row2 = sheet.getRow(17);
        this.setCellValue((Row)row2, valueStyle, 4, report.getBeTrainNum() + "");
        this.setCellValue((Row)row2, valueStyle, 5, report.getBeTrainPerNum() + "");
        this.setCellValue((Row)row2, valueStyle, 6, report.getOnTrainNum() + "");
        this.setCellValue((Row)row2, valueStyle, 7, report.getOnTrainPerNum() + "");
        this.setCellValue((Row)row2, valueStyle, 10, report.getAppraiseTotal() + "");
        this.setCellValue((Row)row2, valueStyle, 11, report.getPrimaryNum() + "");
        this.setCellValue((Row)row2, valueStyle, 12, report.getMiddleNum() + "");
        this.setCellValue((Row)row2, valueStyle, 14, report.getAdminNum() + "");
    }

    private void setCellValue(Row row, CellStyle valueStyle, int cellIndex, String value) {
        Cell cell29 = row.getCell(cellIndex);
        cell29.setCellStyle(valueStyle);
        cell29.setCellValue(value);
    }

    private static CellStyle getStringStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        HSSFFont font = wb.createFont();
        font.setFontName("\u7b49\u7ebf");
        font.setFontHeightInPoints((short)8);
        style.setFont((Font)font);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        style.setBorderTop((short)1);
        style.setBorderRight((short)1);
        return style;
    }
}

