/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.gen.impl;

import com.bcxin.ars.dao.gen.GenTableColumnDao;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.gen.GenTableColumn;
import com.bcxin.ars.service.gen.GenTableColumnService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GenTableColumnServiceImpl
implements GenTableColumnService {
    Logger logger = LoggerFactory.getLogger(GenTableColumnServiceImpl.class);
    @Autowired
    private GenTableColumnDao genTableColumnDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(GenTableColumn genTableColumn) {
        User currentUser = this.arsUtil.getCurrentUser();
        genTableColumn.setUpdateTime(new Date());
        genTableColumn.setUpdateBy(currentUser.getUsername());
        return this.genTableColumnDao.delete(genTableColumn);
    }

    public int save(GenTableColumn genTableColumn) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (genTableColumn.getId() == null) {
            genTableColumn.setCreateTime(new Date());
        } else {
            GenTableColumn dbGenTableColumn = this.genTableColumnDao.findById(genTableColumn.getId());
            BeanUtils.copyPropertiesIgnore((Object)genTableColumn, (Object)dbGenTableColumn, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbGenTableColumn, (Object)genTableColumn, (Boolean)false);
        }
        genTableColumn.setActive(Boolean.valueOf(true));
        genTableColumn.setUpdateBy(currentUser.getUsername());
        genTableColumn.setUpdateTime(new Date());
        return this.genTableColumnDao.save(genTableColumn);
    }

    public GenTableColumn findById(Long id) {
        return this.genTableColumnDao.findById(id);
    }

    public void importBatch(List<GenTableColumn> list) {
        List dbList = this.genTableColumnDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (GenTableColumn genTableColumn : list) {
                genTableColumn.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    genTableColumn.setUpdateTime(DateUtil.dateAdd((int)6, (Date)genTableColumn.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.genTableColumnDao.saveBatch(list);
        }
    }

    public List<GenTableColumn> findByBatchId(List<GenTableColumn> list) {
        return this.genTableColumnDao.findByBatchId(list);
    }

    public void search(GenTableColumn genTableColumn, AjaxPageResponse<GenTableColumn> page) {
        page.setData(this.genTableColumnDao.findByTableId(genTableColumn.getTableId()));
    }

    public void updateSelective(GenTableColumn genTableColumn) {
        User currentUser = this.arsUtil.getCurrentUser();
        genTableColumn.setUpdateTime(new Date());
        genTableColumn.setUpdateBy(currentUser.getUsername());
        this.genTableColumnDao.updateSelective(genTableColumn);
    }
}

