/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.exam.impl;

import cn.jiguang.common.utils.StringUtils;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dao.exam.TrainExamInfoDao;
import com.bcxin.ars.dao.exam.TrainExamPersonDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDaoAop;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.AppNoticeDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ApprovalDTO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.exam.TrainExamInfoDto;
import com.bcxin.ars.dto.exam.TrainExamPersonSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.exam.TrainExamInfo;
import com.bcxin.ars.model.exam.TrainExamPerson;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.task.AppNotice;
import com.bcxin.ars.service.bean.factory.CustomPersoncertificateBeanFactory;
import com.bcxin.ars.service.exam.TrainExamPersonService;
import com.bcxin.ars.service.sb.CustomPersoncertificateService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.service.util.excel.ExcelUtil;
import com.bcxin.ars.service.util.excel.excelbean.exam.TrainExamPersonResultExportExcelBean;
import com.bcxin.ars.service.util.excel.excelbean.exam.TrainExamPersonResultTemplateExcelBean;
import com.bcxin.ars.util.JPushUtil;
import com.bcxin.ars.util.MessageUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=TrainExamPerson.class)
public class TrainExamPersonServiceImpl
implements TrainExamPersonService {
    private static Logger logger = LoggerFactory.getLogger(TrainExamPersonServiceImpl.class);
    @Autowired
    private TrainExamInfoDao trainExamInfoDao;
    @Autowired
    private TrainExamPersonDao trainExamPersonDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Autowired
    private PersoncertificateDaoAop personcertificateDaoAop;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private MessageLogDao messageLogDao;
    @Autowired
    private AppNoticeDao appNoticeDao;
    @Autowired
    private ApprovalService approvalService;
    @Autowired
    private SecurityCertificateDao securityCertificateDao;
    @Autowired
    private ConfigUtils configUtils;

    public PageResult query(TrainExamPersonSearchDto dto) {
        AjaxPageResponse page = new AjaxPageResponse();
        if (dto.getPageNum() == 0) {
            page.setPageNumber(1);
        } else {
            page.setPageNumber(dto.getPageNum() + 1);
        }
        page.setPageSize(dto.getNumPerPage().intValue());
        this.trainExamPersonDao.query(dto, page);
        return new PageResult(Integer.valueOf((int)page.getTotal()), (Object)page.getData());
    }

    public PageResult queryHistory(TrainExamPersonSearchDto dto) {
        AjaxPageResponse page = new AjaxPageResponse();
        if (dto.getPageNum() == 0) {
            page.setPageNumber(1);
        } else {
            page.setPageNumber(dto.getPageNum() + 1);
        }
        page.setPageSize(dto.getNumPerPage().intValue());
        this.trainExamPersonDao.queryHistory(dto, page);
        return new PageResult(Integer.valueOf((int)page.getTotal()), (Object)page.getData());
    }

    public List<TrainExamPerson> list(TrainExamPersonSearchDto dto) {
        return this.trainExamPersonDao.list(dto);
    }

    public TrainExamPerson findById(Long id) {
        return this.trainExamPersonDao.findById(id.longValue());
    }

    public void deleteById(Long id) {
        TrainExamPerson dbTrainExamPerson = this.trainExamPersonDao.findById(id.longValue());
        if (dbTrainExamPerson != null) {
            if (dbTrainExamPerson.getSumScore() != null) {
                throw new ArsException("\u59d3\u540d[" + dbTrainExamPerson.getFullname() + "]\u6210\u7ee9\u5df2\u5f55\u5165\uff0c\u5219\u4e0d\u80fd\u5220\u9664\uff01");
            }
            if (dbTrainExamPerson.getNoticeState().equals("1")) {
                Personcertificate personcertificate = this.personcertificateDao.findById(dbTrainExamPerson.getBbdPersonID());
                if (personcertificate != null) {
                    personcertificate.setExamState("0");
                    Config config = this.configDao.findByKey("police");
                    if (config != null && StringUtil.isNotEmpty((String)config.getValue()) && "1".equals(config.getValue())) {
                        personcertificate.setUpdateflag(Boolean.valueOf(true));
                        this.personcertificateDaoAop.update(personcertificate);
                    } else {
                        this.personcertificateDaoAop.update(personcertificate);
                        String title = "";
                        String appContent = "";
                        String msgContent = "";
                        String name = personcertificate.getName();
                        SimpleDateFormat parseDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
                        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
                        title = "\u60a8\u7684\u8003\u8bd5\u5b89\u6392\u5df2\u88ab\u53d6\u6d88";
                        appContent = "\u539f\u5b9a\u7406\u8bba\u8003\u8bd5\u65f6\u95f4\uff1a{examDate} {examStart}\u5230 {examEnd}\uff0c\u4f53\u80fd\u8003\u8bd5\u65f6\u95f4\uff1a{staminaDate} {staminaStartDate}\u5230 {staminaEndDate}\uff0c\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\u8003\u8bd5\u5df2\u53d6\u6d88\uff0c\u8003\u8bd5\u65f6\u95f4\u5c06\u53e6\u884c\u901a\u77e5\u3002";
                        try {
                            appContent = appContent.replace("{name}", name).replace("{examDate}", dateFormat.format(parseDateFormat.parse(personcertificate.getExamStart()))).replace("{examStart}", timeFormat.format(parseDateFormat.parse(personcertificate.getExamStart()))).replace("{examEnd}", timeFormat.format(parseDateFormat.parse(personcertificate.getExamEnd()))).replace("{staminaDate}", dateFormat.format(parseDateFormat.parse(personcertificate.getStaminaStartDate()))).replace("{staminaStartDate}", timeFormat.format(parseDateFormat.parse(personcertificate.getStaminaStartDate()))).replace("{staminaEndDate}", timeFormat.format(parseDateFormat.parse(personcertificate.getStaminaEndDate())));
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        msgContent = "\u60a8\u7684\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\u8003\u8bd5\u5df2\u53d6\u6d88\uff0c\u8003\u8bd5\u65f6\u95f4\u5c06\u53e6\u884c\u901a\u77e5\uff0c\u8bf7\u7559\u610f\u60a8\u7684\u77ed\u4fe1\u901a\u77e5\u3002";
                        this.sendMsg(personcertificate, title, msgContent, appContent, "1");
                    }
                } else {
                    throw new ArsException("\u59d3\u540d[" + dbTrainExamPerson.getFullname() + "]\u67e5\u627e\u4e0d\u5230\u8003\u8bd5\u62a5\u540d\u4fe1\u606f\uff0c\u5220\u9664\u5931\u8d25\uff01");
                }
            }
            this.trainExamPersonDao.deleteById(id.longValue());
        }
    }

    public TrainExamPerson updateScore(TrainExamPerson trainExamPerson) {
        User currentUser = this.arsUtil.getCurrentUser();
        TrainExamPerson dbTrainExamPerson = this.trainExamPersonDao.findById(trainExamPerson.getId().longValue());
        if (dbTrainExamPerson != null) {
            BigDecimal sumScore;
            TrainExamInfoDto dbTrainExamInfo = this.trainExamInfoDao.selectByPrimaryKey(dbTrainExamPerson.getExamID().longValue());
            int writtenRatio = dbTrainExamInfo.getWrittenRatio();
            int operateRatio = dbTrainExamInfo.getOperateRatio();
            int writtenPassScore = dbTrainExamInfo.getWrittenPassScore();
            int operatePassScore = dbTrainExamInfo.getOperatePassScore();
            int examStandard = dbTrainExamInfo.getExamStandard();
            int operateScore = trainExamPerson.getOperateScore();
            int writtenScore = trainExamPerson.getWrittenScore();
            Boolean isOperate = false;
            Boolean isWritten = false;
            if (dbTrainExamInfo.getIsComputerExam() > 0 && dbTrainExamInfo.getIsStamina() < 1) {
                operateScore = 0;
                isWritten = true;
            } else if (dbTrainExamInfo.getIsComputerExam() < 1 && dbTrainExamInfo.getIsStamina() > 0) {
                writtenScore = 0;
                isOperate = true;
            } else {
                isWritten = true;
                isOperate = true;
            }
            if (dbTrainExamInfo.getExamRules() == 1) {
                sumScore = BigDecimal.valueOf(operateScore + writtenScore);
                dbTrainExamPerson.setSumScore(sumScore);
                if (writtenScore >= writtenPassScore && operateScore >= operatePassScore) {
                    dbTrainExamPerson.setTestState("1");
                } else {
                    dbTrainExamPerson.setTestState("0");
                }
            } else if (dbTrainExamInfo.getExamRules() == 2) {
                sumScore = BigDecimal.valueOf((double)(operateScore * operateRatio + writtenScore * writtenRatio) * 0.01);
                dbTrainExamPerson.setSumScore(sumScore);
                if (sumScore.compareTo(BigDecimal.valueOf(examStandard)) >= 0) {
                    dbTrainExamPerson.setTestState("1");
                } else {
                    dbTrainExamPerson.setTestState("0");
                }
            }
            if (isOperate.booleanValue()) {
                dbTrainExamPerson.setOperateScore(Integer.valueOf(operateScore));
            }
            if (isWritten.booleanValue()) {
                dbTrainExamPerson.setWrittenScore(Integer.valueOf(writtenScore));
            }
            dbTrainExamPerson.setUpdateBy(currentUser.getUsername());
            dbTrainExamPerson.setUpdateTime(new java.util.Date());
            this.trainExamPersonDao.updateScore(dbTrainExamPerson);
            ArrayList<TrainExamPerson> systemExamPersonList = new ArrayList<TrainExamPerson>();
            systemExamPersonList.add(dbTrainExamPerson);
            this.personcertificateDao.updateIsMakeUp(systemExamPersonList);
        }
        return dbTrainExamPerson;
    }

    public void deleteTestForApporvalId(Long[] ids) {
        this.trainExamPersonDao.deleteTestForApporvalId(ids);
    }

    public String batchSave(List<TrainExamPerson> trainExamPersons) {
        User currentUser = this.arsUtil.getCurrentUser();
        IdWorker idWorker = new IdWorker();
        int addSum = 0;
        int errorAddSum = 0;
        StringBuffer errorSb = new StringBuffer("");
        String resultMsg = "";
        if (trainExamPersons != null && trainExamPersons.size() > 0) {
            ArrayList<String> idCards = new ArrayList<String>();
            for (TrainExamPerson item : trainExamPersons) {
                idCards.add(item.getIdentitynumber());
                ++addSum;
                item.setId(Long.valueOf(idWorker.nextId()));
                item.setCreateTime(new java.util.Date());
                item.setUpdateTime(new java.util.Date());
                item.setUpdateBy(currentUser.getUsername());
                item.setCreateBy(currentUser.getUsername());
            }
            List isExitPersonList = this.trainExamPersonDao.checkPersonInExam(idCards);
            if (isExitPersonList != null && isExitPersonList.size() > 0) {
                block1: for (TrainExamPerson isExitItem : isExitPersonList) {
                    for (TrainExamPerson item : trainExamPersons) {
                        if (!isExitItem.getIdentitynumber().equals(item.getIdentitynumber())) continue;
                        trainExamPersons.remove(item);
                        errorSb.append("\u8eab\u4efd\u8bc1\u53f7\uff1a" + item.getTicket() + ",\u59d3\u540d\uff1a" + item.getFullname() + "\u5df2\u7ecf\u5b89\u6392\u8fc7\u8003\u8bd5");
                        ++errorAddSum;
                        continue block1;
                    }
                }
            }
            if (trainExamPersons != null && trainExamPersons.size() > 0) {
                this.trainExamPersonDao.batchSave(trainExamPersons);
            }
            if (errorAddSum > 0) {
                resultMsg = MessageFormat.format("\u6dfb\u52a0\u8003\u8bd5\u4eba\u5458\u5b8c\u6210\uff1a\u6dfb\u52a0\u6761\u6570\u3010{0}\u3011,\u5176\u4e2d\u6210\u529f\u6761\u6570:{1},\u5931\u8d25\u6761\u6570:{2}<br>", addSum, addSum - errorAddSum, errorAddSum);
                resultMsg = resultMsg + errorSb.toString();
            }
        }
        return resultMsg;
    }

    public AjaxResult exportData(Long examID) {
        AjaxResult result = new AjaxResult();
        TrainExamInfoDto dbTrainExamInfo = this.trainExamInfoDao.selectByPrimaryKey(examID.longValue());
        if (dbTrainExamInfo == null) {
            throw new ArsException("\u67e5\u65e0\u6b64\u8003\u573a\u4fe1\u606f\uff01");
        }
        ConvertUtils.register((Converter)new SqlDateConverter(null), Date.class);
        ConvertUtils.register((Converter)new BigDecimalConverter(null), BigDecimal.class);
        TrainExamPersonSearchDto trainExamPersonSearchDto = new TrainExamPersonSearchDto();
        trainExamPersonSearchDto.setExamID(examID);
        List list = this.trainExamPersonDao.list(trainExamPersonSearchDto);
        ArrayList<TrainExamPersonResultExportExcelBean> resultBeans = new ArrayList<TrainExamPersonResultExportExcelBean>();
        int index = 1;
        for (TrainExamPerson item : list) {
            TrainExamPersonResultExportExcelBean bean = new TrainExamPersonResultExportExcelBean();
            BeanUtils.copyProperties((Object)item, (Object)bean);
            SecurityCertificate securityCertificate = this.securityCertificateDao.findByIdnum(item.getIdentitynumber());
            if (null != securityCertificate) {
                bean.setZsbh(securityCertificate.getZsbh());
            } else {
                bean.setZsbh("");
            }
            bean.setIndex(index);
            ++index;
            if (bean.getTestState() != null) {
                if (bean.getTestState().equals("0")) {
                    bean.setTestState("\u4e0d\u5408\u683c");
                } else if (bean.getTestState().equals("1")) {
                    bean.setTestState("\u5408\u683c");
                }
            }
            if (bean.getNoticeState() != null) {
                if (bean.getNoticeState().equals("0")) {
                    bean.setNoticeState("\u672a\u901a\u77e5");
                } else if (bean.getNoticeState().equals("1")) {
                    bean.setNoticeState("\u5df2\u901a\u77e5");
                }
            }
            if (bean.getScoreMsgState() != null) {
                if (bean.getScoreMsgState().equals("0")) {
                    bean.setScoreMsgState("\u672a\u901a\u77e5");
                } else if (bean.getScoreMsgState().equals("1")) {
                    bean.setScoreMsgState("\u5df2\u901a\u77e5");
                }
            }
            if (bean.getCardState() != null) {
                if (bean.getCardState().equals("0")) {
                    bean.setCardState("\u672a\u5236\u8bc1");
                } else if (bean.getCardState().equals("1")) {
                    bean.setCardState("\u5df2\u5236\u8bc1");
                }
            }
            resultBeans.add(bean);
            result.setData(resultBeans);
        }
        return result;
    }

    public void downLoad(String resultBeansJSON, OutputStream os) {
        ExcelUtil<TrainExamPersonResultExportExcelBean> util = new ExcelUtil<TrainExamPersonResultExportExcelBean>(TrainExamPersonResultExportExcelBean.class);
        if (StringUtil.isNotEmpty((String)resultBeansJSON)) {
            List resultBeans = JSON.parseArray((String)resultBeansJSON, TrainExamPersonResultExportExcelBean.class);
            util.exportExcel(resultBeans, "\u5b66\u5458\u6210\u7ee9\u4fe1\u606f\u6c47\u603b\u8868", 65535, os);
        }
    }

    public AjaxResult template(Long examID, OutputStream os) {
        AjaxResult result = new AjaxResult();
        TrainExamInfoDto dbTrainExamInfo = this.trainExamInfoDao.selectByPrimaryKey(examID.longValue());
        if (dbTrainExamInfo == null) {
            throw new ArsException("\u67e5\u65e0\u6b64\u8003\u573a\u4fe1\u606f\uff01");
        }
        ConvertUtils.register((Converter)new SqlDateConverter(null), Date.class);
        ConvertUtils.register((Converter)new BigDecimalConverter(null), BigDecimal.class);
        TrainExamPersonSearchDto trainExamPersonSearchDto = new TrainExamPersonSearchDto();
        trainExamPersonSearchDto.setExamID(examID);
        List list = this.trainExamPersonDao.list(trainExamPersonSearchDto);
        ArrayList<TrainExamPersonResultTemplateExcelBean> resultBeans = new ArrayList<TrainExamPersonResultTemplateExcelBean>();
        for (TrainExamPerson item : list) {
            TrainExamPersonResultTemplateExcelBean bean = new TrainExamPersonResultTemplateExcelBean();
            BeanUtils.copyProperties((Object)item, (Object)bean);
            if (StringUtil.isEmpty((String)item.getTestState())) {
                bean.setWrittenScore(null);
                bean.setOperateScore(null);
            }
            resultBeans.add(bean);
        }
        ExcelUtil<TrainExamPersonResultTemplateExcelBean> util = new ExcelUtil<TrainExamPersonResultTemplateExcelBean>(TrainExamPersonResultTemplateExcelBean.class);
        util.exportExcel(resultBeans, "\u5b66\u5458\u6210\u7ee9\u540d\u5355\u8868", 65535, os);
        result.setSuccessful(true);
        return result;
    }

    public AjaxResult importResult(Long examID, InputStream inputStream, String fileType) throws IOException {
        AjaxResult result = new AjaxResult();
        String resultMsg = "";
        TrainExamInfoDto dbTrainExamInfo = this.trainExamInfoDao.selectByPrimaryKey(examID.longValue());
        if (dbTrainExamInfo == null) {
            throw new ArsException("\u67e5\u65e0\u6b64\u8003\u573a\u4fe1\u606f\uff01");
        }
        ExcelUtil<TrainExamPersonResultTemplateExcelBean> beanUtil = new ExcelUtil<TrainExamPersonResultTemplateExcelBean>(TrainExamPersonResultTemplateExcelBean.class);
        List<TrainExamPersonResultTemplateExcelBean> srclist = beanUtil.importExcel(inputStream, fileType);
        inputStream.close();
        int importCount = beanUtil.getImportCount();
        int importErrorCount = beanUtil.getImportError();
        if (importErrorCount > 0) {
            result.setSuccessful(false);
            resultMsg = "\u5bfc\u5165\u5931\u8d25\uff1a<br>" + beanUtil.getErrorMsg();
            result.setMsg(resultMsg);
        } else {
            Integer unqualified = this.updatePerson(beanUtil, srclist, (TrainExamInfo)dbTrainExamInfo);
            importCount = beanUtil.getImportCount();
            importErrorCount = beanUtil.getImportError();
            if (importErrorCount > 0) {
                result.setSuccessful(false);
                String resultImport = MessageFormat.format("\u5bfc\u5165\u5b8c\u6210\uff1a\u5bfc\u5165\u6761\u6570\u3010{0}\u3011,\u5176\u4e2d\u6210\u529f\u6761\u6570:{1},\u5931\u8d25\u6761\u6570:{2}<br>${3}", importCount, importCount - importErrorCount, importErrorCount, unqualified);
                resultMsg = resultImport + beanUtil.getErrorMsg();
                result.setMsg(resultMsg);
            } else if (importCount > 0) {
                result.setSuccessful(true);
                result.setData(srclist);
                String resultImport = MessageFormat.format("\u5bfc\u5165\u5b8c\u6210\uff1a\u5bfc\u5165\u6761\u6570\u3010{0}\u3011,\u5176\u4e2d\u6210\u529f\u6761\u6570:{1},\u5931\u8d25\u6761\u6570:{2}<br>${3}", importCount, importCount - importErrorCount, importErrorCount, unqualified);
                resultMsg = resultImport + beanUtil.getErrorMsg();
                result.setMsg(resultMsg);
            } else {
                result.setSuccessful(false);
                result.setMsg("\u5bfc\u5165\u5931\u8d25\uff0c\u5df2\u7ecf\u6210\u7ee9\u901a\u77e5\u4e0d\u5f97\u91cd\u65b0\u5bfc\u5165\uff01\uff01\uff01");
            }
        }
        return result;
    }

    Integer updatePerson(ExcelUtil<TrainExamPersonResultTemplateExcelBean> beanUtil, List<TrainExamPersonResultTemplateExcelBean> srclist, TrainExamInfo dbTrainExamInfo) {
        User currentUser = this.arsUtil.getCurrentUser();
        int index = 1;
        int unqualified = 0;
        ArrayList<TrainExamPerson> systemExamPersonList = new ArrayList<TrainExamPerson>();
        if (srclist != null && srclist.size() > 0) {
            for (TrainExamPersonResultTemplateExcelBean item : srclist) {
                ++index;
                TrainExamPersonSearchDto paramObj = new TrainExamPersonSearchDto();
                paramObj.setExamID(dbTrainExamInfo.getId());
                paramObj.setIdentitynumber(item.getTicket());
                List list = this.trainExamPersonDao.list(paramObj);
                if (list != null && list.size() > 0) {
                    BigDecimal sumScore;
                    TrainExamPerson person = (TrainExamPerson)list.get(0);
                    if ("1".equals(person.getScoreMsgState())) {
                        beanUtil.setImportCount(beanUtil.getImportCount() - 1);
                        continue;
                    }
                    person.setWrittenScore(item.getWrittenScore());
                    person.setOperateScore(item.getOperateScore());
                    TrainExamPerson ob = this.trainExamPersonDao.findById(person.getId().longValue());
                    if (ob == null) continue;
                    int writtenRatio = dbTrainExamInfo.getWrittenRatio();
                    int operateRatio = dbTrainExamInfo.getOperateRatio();
                    int writtenPassScore = dbTrainExamInfo.getWrittenPassScore();
                    int operatePassScore = dbTrainExamInfo.getOperatePassScore();
                    int examStandard = dbTrainExamInfo.getExamStandard();
                    int operateScore = person.getOperateScore();
                    int writtenScore = person.getWrittenScore();
                    Boolean isOperate = false;
                    Boolean isWritten = false;
                    if (dbTrainExamInfo.getIsComputerExam() > 0 && dbTrainExamInfo.getIsStamina() < 1) {
                        operateScore = 0;
                        isWritten = true;
                    } else if (dbTrainExamInfo.getIsComputerExam() < 1 && dbTrainExamInfo.getIsStamina() > 0) {
                        writtenScore = 0;
                        isOperate = true;
                    } else {
                        isWritten = true;
                        isOperate = true;
                    }
                    if (dbTrainExamInfo.getExamRules() == 1) {
                        sumScore = BigDecimal.valueOf(operateScore + writtenScore);
                        ob.setSumScore(sumScore);
                        if (writtenScore >= writtenPassScore && operateScore >= operatePassScore) {
                            ob.setTestState("1");
                        } else {
                            ob.setTestState("0");
                            ++unqualified;
                        }
                    } else if (dbTrainExamInfo.getExamRules() == 2) {
                        sumScore = BigDecimal.valueOf((double)(operateScore * operateRatio + writtenScore * writtenRatio) * 0.01);
                        ob.setSumScore(sumScore);
                        if (sumScore.compareTo(BigDecimal.valueOf(examStandard)) >= 0) {
                            ob.setTestState("1");
                        } else {
                            ob.setTestState("0");
                            ++unqualified;
                        }
                    }
                    if (isOperate.booleanValue()) {
                        ob.setOperateScore(Integer.valueOf(operateScore));
                    }
                    if (isWritten.booleanValue()) {
                        ob.setWrittenScore(Integer.valueOf(writtenScore));
                    }
                    ob.setUpdateBy(currentUser.getUsername());
                    ob.setUpdateTime(new java.util.Date());
                    systemExamPersonList.add(ob);
                    continue;
                }
                String errorMsg = MessageFormat.format("\u7b2c\u3010{0}\u3011\u884c\u6570\u636e\u4e0d\u5b58\u5728\u8be5\u8003\u573a\u5b66\u5458,\u5b66\u5458\u59d3\u540d\u4e3a\u3010{1}\u3011<br>", index, item.getFullname());
                beanUtil.getErrorMsg().append(errorMsg);
                beanUtil.setImportError(beanUtil.getImportError() + 1);
            }
            if (systemExamPersonList != null && systemExamPersonList.size() > 0) {
                this.trainExamPersonDao.updatePScore(systemExamPersonList);
                this.personcertificateDao.updateIsMakeUp(systemExamPersonList);
            }
        }
        return unqualified;
    }

    public String sendExamNotice(TrainExamPersonSearchDto trainExamPersonSearchDto) {
        trainExamPersonSearchDto.setNoticeState("0");
        List list = this.trainExamPersonDao.list(trainExamPersonSearchDto);
        TrainExamInfoDto trainExamInfo = this.trainExamInfoDao.selectByPrimaryKey(trainExamPersonSearchDto.getExamID().longValue());
        int noticeSum = 0;
        int errorNoticeSum = 0;
        StringBuffer errorSb = new StringBuffer("");
        String resultMsg = "";
        if (list != null && list.size() > 0) {
            noticeSum = list.size();
            ArrayList<Long> ids = new ArrayList<Long>();
            Config config = this.configDao.findByKey("police");
            for (TrainExamPerson item : list) {
                try {
                    Personcertificate personcertificate = this.personcertificateDao.findById(item.getBbdPersonID());
                    if (personcertificate != null && "1".equals(personcertificate.getProState())) {
                        errorSb.append("\u51c6\u8003\u8bc1\u53f7\uff1a" + item.getTicket() + ",\u59d3\u540d\uff1a" + item.getFullname() + "\u8003\u8bd5\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u518d\u901a\u77e5<br>");
                        ++errorNoticeSum;
                        continue;
                    }
                    if (personcertificate == null) continue;
                    if (config != null && StringUtil.isNotEmpty((String)config.getValue()) && "0".equals(config.getValue())) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
                        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
                        String title = "";
                        String appContent = "";
                        String msgContent = "";
                        String name = item.getFullname();
                        title = "\u60a8\u6709\u4e00\u6761\u65b0\u7684\u8003\u8bd5\u5b89\u6392";
                        msgContent = "\u60a8\u7684\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\u8003\u8bd5\u5df2\u5b89\u6392\uff01\u7406\u8bba\u8003\u8bd5\uff1a{examDate} {examStart}\u5230 {examEnd},\u8003\u70b9\uff1a{examAddress},\u4f53\u80fd\u8003\u8bd5\uff1a{staminaDate} {staminaStartDate}\u5230 {staminaEndDate},\u8003\u70b9\uff1a{staminaAddress},\u8bf7\u51c6\u65f6\u5230\u573a\u53c2\u52a0\u8003\u8bd5\u3002";
                        msgContent = msgContent.replace("{name}", name).replace("{examDate}", dateFormat.format(trainExamInfo.getComputerStartDate())).replace("{examStart}", timeFormat.format(trainExamInfo.getComputerStartDate())).replace("{examEnd}", timeFormat.format(trainExamInfo.getComputerEndDate())).replace("{examAddress}", trainExamInfo.getTheoreticalAddress()).replace("{staminaDate}", dateFormat.format(trainExamInfo.getStaminaStartDate())).replace("{staminaStartDate}", timeFormat.format(trainExamInfo.getStaminaStartDate())).replace("{staminaEndDate}", timeFormat.format(trainExamInfo.getStaminaEndDate())).replace("{staminaAddress}", trainExamInfo.getStaminaAddress());
                        appContent = "\u60a8\u53c2\u52a0\u7684\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\u8003\u8bd5\uff0c\u8003\u8bd5\u5df2\u5b89\u6392\uff01\u7406\u8bba\u8003\u8bd5\u65f6\u95f4\uff1a{examDate} {examStart}\u5230 {examEnd},\u8003\u70b9\uff1a{examAddress},\u4f53\u80fd\u8003\u8bd5\u65f6\u95f4\uff1a{staminaDate} {staminaStartDate}\u5230 {staminaEndDate},\u8003\u70b9\uff1a{staminaAddress},\u8bf7\u51c6\u65f6\u5230\u573a\u53c2\u52a0\u8003\u8bd5\u3002";
                        appContent = appContent.replace("{name}", name).replace("{examDate}", dateFormat.format(trainExamInfo.getComputerStartDate())).replace("{examStart}", timeFormat.format(trainExamInfo.getComputerStartDate())).replace("{examEnd}", timeFormat.format(trainExamInfo.getComputerEndDate())).replace("{examAddress}", trainExamInfo.getTheoreticalAddress()).replace("{staminaDate}", dateFormat.format(trainExamInfo.getStaminaStartDate())).replace("{staminaStartDate}", timeFormat.format(trainExamInfo.getStaminaStartDate())).replace("{staminaEndDate}", timeFormat.format(trainExamInfo.getStaminaEndDate())).replace("{staminaAddress}", trainExamInfo.getStaminaAddress());
                        String smsCode = "B66";
                        String[] msgParams = new String[]{dateFormat.format(trainExamInfo.getComputerStartDate()), timeFormat.format(trainExamInfo.getComputerStartDate()), timeFormat.format(trainExamInfo.getComputerEndDate()), trainExamInfo.getTheoreticalAddress(), dateFormat.format(trainExamInfo.getStaminaStartDate()), timeFormat.format(trainExamInfo.getStaminaStartDate()), timeFormat.format(trainExamInfo.getStaminaEndDate()), trainExamInfo.getStaminaAddress()};
                        if (!"11".equals(this.configUtils.getCurrentNative())) {
                            this.sendMsgHeiWei(personcertificate, title, msgContent, appContent, trainExamPersonSearchDto.getSendMsg(), msgParams, smsCode);
                        }
                    }
                    ids.add(item.getId());
                }
                catch (Exception e) {
                    errorSb.append("\u51c6\u8003\u8bc1\u53f7\uff1a" + item.getTicket() + ",\u59d3\u540d\uff1a" + item.getFullname() + "\u53d1\u9001\u8003\u8bd5\u901a\u77e5\u5931\u8d25");
                    ++errorNoticeSum;
                }
            }
            if (ids != null && ids.size() > 0) {
                this.trainExamPersonDao.updateBatchYesNoticeStateByPrimaryKey(ids);
                if (config != null && StringUtil.isNotEmpty((String)config.getValue()) && "1".equals(config.getValue())) {
                    this.personcertificateDao.updateInnerBatchByExamPersonIds(ids);
                } else {
                    this.personcertificateDao.updateOutBatchByExamPersonIds(ids);
                }
            }
        }
        if (errorNoticeSum > 0) {
            resultMsg = MessageFormat.format("\u53d1\u9001\u8003\u8bd5\u901a\u77e5\u5b8c\u6210\uff1a\u53d1\u9001\u6761\u6570\u3010{0}\u3011,\u5176\u4e2d\u6210\u529f\u6761\u6570:{1},\u5931\u8d25\u6761\u6570:{2}<br>", noticeSum, noticeSum - errorNoticeSum, errorNoticeSum);
            resultMsg = resultMsg + errorSb.toString();
        } else {
            resultMsg = MessageFormat.format("\u53d1\u9001\u8003\u8bd5\u901a\u77e5\u5b8c\u6210\uff1a\u53d1\u9001\u6761\u6570\u3010{0}\u3011,\u5176\u4e2d\u6210\u529f\u6761\u6570:{1},\u5931\u8d25\u6761\u6570:{2}<br>", noticeSum, noticeSum - errorNoticeSum, errorNoticeSum);
        }
        return resultMsg;
    }

    public String sendScoreNotice(TrainExamPersonSearchDto trainExamPersonSearchDto) {
        trainExamPersonSearchDto.setScoreMsgState("0");
        List list = this.trainExamPersonDao.list(trainExamPersonSearchDto);
        int noticeSum = 0;
        int errorNoticeSum = 0;
        StringBuffer errorSb = new StringBuffer("");
        String resultMsg = "";
        if (list != null && list.size() > 0) {
            noticeSum = list.size();
            ArrayList<Long> ids = new ArrayList<Long>();
            for (TrainExamPerson item : list) {
                try {
                    Personcertificate personcertificate = this.personcertificateDao.findById(item.getBbdPersonID());
                    if (personcertificate == null) {
                        errorSb.append("\u51c6\u8003\u8bc1\u53f7\uff1a" + item.getTicket() + ",\u59d3\u540d\uff1a" + item.getFullname() + "\u627e\u4e0d\u5230\u62a5\u540d\u4fe1\u606f<br>");
                        ++errorNoticeSum;
                        continue;
                    }
                    if (personcertificate != null && "1".equals(personcertificate.getProState())) {
                        errorSb.append("\u51c6\u8003\u8bc1\u53f7\uff1a" + item.getTicket() + ",\u59d3\u540d\uff1a" + item.getFullname() + "\u8003\u8bd5\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u518d\u901a\u77e5<br>");
                        ++errorNoticeSum;
                        continue;
                    }
                    if (personcertificate != null && (personcertificate.getExamState() == null || "".equals(personcertificate.getExamState()) || "0".equals(personcertificate.getExamState()))) {
                        errorSb.append("\u51c6\u8003\u8bc1\u53f7\uff1a" + item.getTicket() + ",\u59d3\u540d\uff1a" + item.getFullname() + "\u8fd8\u6ca1\u8003\u8bd5\u901a\u77e5\uff0c\u4e0d\u80fd\u6210\u7ee9\u901a\u77e5<br>");
                        ++errorNoticeSum;
                        continue;
                    }
                    int examTimes = 1;
                    personcertificate.setWrittenScore(item.getWrittenScore());
                    personcertificate.setOperateScore(item.getOperateScore());
                    personcertificate.setSumScore(Double.valueOf(item.getSumScore().doubleValue()));
                    personcertificate.setTestState(item.getTestState());
                    personcertificate.setExamTimes(Integer.valueOf(examTimes));
                    personcertificate.setUpdateTime(new java.util.Date());
                    Config config = this.configDao.findByKey("police");
                    if (config != null && StringUtil.isNotEmpty((String)config.getValue()) && "0".equals(config.getValue())) {
                        String smsCode = "";
                        String[] msgParams = null;
                        Personcertificate dbPersoncertificate = this.personcertificateDao.findById(personcertificate.getId());
                        if ("0".equals(dbPersoncertificate.getTestState())) {
                            if ("1".equals(personcertificate.getIsMakeUp())) {
                                personcertificate.setMakeUpstate("004");
                            }
                            smsCode = "B70";
                        } else if ("1".equals(dbPersoncertificate.getTestState())) {
                            if ("1".equals(personcertificate.getIsMakeUp())) {
                                personcertificate.setMakeUpstate("003");
                                personcertificate.setApprovalstate("005");
                            }
                            smsCode = "B71";
                        }
                        String writtenScore = personcertificate.getWrittenScore() == null ? "" : personcertificate.getWrittenScore().toString();
                        String operateScore = personcertificate.getOperateScore() == null ? "" : personcertificate.getOperateScore().toString();
                        CustomPersoncertificateService customPersoncertificateService = CustomPersoncertificateBeanFactory.getPersoncertificateBean();
                        String title = "\u60a8\u7684\u8003\u8bd5\u6210\u7ee9\u516c\u5e03\u5566";
                        String content = customPersoncertificateService.getMsgTemp_V1171("1", personcertificate.getTestState());
                        String newstitle = customPersoncertificateService.getMsgTemp_V1171("0", personcertificate.getTestState());
                        content = content.replace("{writtenScore}", writtenScore).replace("{operateScore}", operateScore);
                        newstitle = newstitle.replace("{name}", personcertificate.getName()).replace("{writtenScore}", writtenScore).replace("{operateScore}", operateScore);
                        msgParams = new String[]{writtenScore, operateScore};
                        if (StringUtil.isNotEmpty((String)smsCode)) {
                            this.sendMsgHeiWei(personcertificate, title, newstitle, content, "1", msgParams, smsCode);
                        } else {
                            this.sendMsg(personcertificate, title, newstitle, content, "1");
                        }
                    } else {
                        try {
                            ApprovalDTO approvalDTO = new ApprovalDTO();
                            Config isNeedActivity = this.configDao.findByKey("IS_NEED_ACTIVITY");
                            if (null != isNeedActivity && "0".equals(isNeedActivity.getValue())) {
                                approvalDTO.setIsNeedActivity("0");
                            }
                            approvalDTO.setProstate(personcertificate.getProState());
                            if (!"1".equals(personcertificate.getProState())) {
                                if (personcertificate.getTestState().equals("1")) {
                                    if ("1".equals(personcertificate.getIsMakeUp())) {
                                        personcertificate.setMakeUpstate("003");
                                        personcertificate.setApprovalstate("005");
                                    }
                                    approvalDTO.setBusinesstype("004");
                                    approvalDTO.setBusinessid(personcertificate.getId());
                                    approvalDTO.setApprovalstate("003");
                                    approvalDTO.setApprovalreason("\u81ea\u52a8\u5ba1\u6279\u901a\u8fc7");
                                    this.approvalService.saveApprovalForZZ(approvalDTO);
                                } else {
                                    if ("1".equals(personcertificate.getIsMakeUp())) {
                                        personcertificate.setMakeUpstate("004");
                                    }
                                    approvalDTO.setBusinesstype("004");
                                    approvalDTO.setBusinessid(personcertificate.getId());
                                    approvalDTO.setApprovalstate("004");
                                    approvalDTO.setApprovalreason("\u81ea\u52a8\u5ba1\u6279\u4e0d\u901a\u8fc7");
                                    this.approvalService.saveApprovalForZZ(approvalDTO);
                                }
                            }
                        }
                        catch (Exception e) {
                            throw new ArsException("\u53d1\u9001\u8003\u8bd5\u6210\u7ee9\u901a\u77e5\u5931\u8d25:\u542f\u7528\u5ba1\u6279\u6d41\u7a0b\u914d\u7f6e\u51fa\u9519\uff01");
                        }
                    }
                    if ("1".equals(personcertificate.getProState())) {
                        personcertificate.setApprovalstate("004");
                    }
                    this.personcertificateDaoAop.updateSelective(personcertificate);
                    ids.add(item.getId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e instanceof ArsException) {
                        throw new ArsException("\u53d1\u9001\u8003\u8bd5\u6210\u7ee9\u901a\u77e5\u5931\u8d25:\u542f\u7528\u5ba1\u6279\u6d41\u7a0b\u51fa\u9519\uff01");
                    }
                    errorSb.append("\u51c6\u8003\u8bc1\u53f7\uff1a" + item.getTicket() + ",\u59d3\u540d\uff1a" + item.getFullname() + "\u53d1\u9001\u6210\u7ee9\u901a\u77e5\u5931\u8d25");
                    ++errorNoticeSum;
                }
            }
            if (ids != null && ids.size() > 0) {
                this.trainExamPersonDao.updateBatchYesScoreStateByPrimaryKey(ids);
            }
        }
        if (errorNoticeSum > 0) {
            resultMsg = MessageFormat.format("\u53d1\u9001\u6210\u7ee9\u901a\u77e5\u5b8c\u6210\uff1a\u53d1\u9001\u6761\u6570\u3010{0}\u3011,\u5176\u4e2d\u6210\u529f\u6761\u6570:{1},\u5931\u8d25\u6761\u6570:{2}<br>", noticeSum, noticeSum - errorNoticeSum, errorNoticeSum);
            resultMsg = resultMsg + errorSb.toString();
        } else {
            resultMsg = MessageFormat.format("\u53d1\u9001\u6210\u7ee9\u901a\u77e5\u5b8c\u6210\uff1a\u53d1\u9001\u6761\u6570\u3010{0}\u3011,\u5176\u4e2d\u6210\u529f\u6761\u6570:{1},\u5931\u8d25\u6761\u6570:{2}<br>", noticeSum, noticeSum - errorNoticeSum, errorNoticeSum);
        }
        return resultMsg;
    }

    public List<TrainExamPerson> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.trainExamPersonDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(TrainExamPerson trainExamPerson) {
        TrainExamPerson dbTrainExamPerson;
        if (trainExamPerson.getActive() == null) {
            trainExamPerson.setActive(Boolean.valueOf(true));
        }
        if ((dbTrainExamPerson = this.trainExamPersonDao.findById(trainExamPerson.getId().longValue())) != null) {
            if (trainExamPerson.getUpdateTime().getTime() > dbTrainExamPerson.getUpdateTime().getTime()) {
                this.trainExamPersonDao.updateForDS(trainExamPerson);
            }
        } else {
            this.trainExamPersonDao.saveForDS(trainExamPerson);
        }
    }

    private void sendMsg(Personcertificate personcertificate, String title, String msgContent, String appContent, String sendMsg) {
        if (StringUtils.isEmpty((String)title) || StringUtils.isEmpty((String)msgContent) || StringUtils.isEmpty((String)appContent)) {
            logger.error("TrainExamPersonServiceImpl\u7c7bsendMsg\u65b9\u6cd5\uff1a\u53d1\u9001\u6d88\u606f\u901a\u77e5\u4f20\u9012\u53c2\u6570title\u6216\u8005msgContent\u6216\u8005appContent\u4e3a\u7a7a");
            return;
        }
        new Thread(() -> {
            try {
                if (personcertificate.getPersonid() == null) {
                    if ("1".equals(sendMsg) && StringUtils.isNotEmpty((String)personcertificate.getPhone())) {
                        MessageUtil.sendMessage((String)personcertificate.getPhone(), (String)msgContent, (MessageLogDao)this.messageLogDao);
                    }
                } else {
                    boolean hasApp = false;
                    String registrationID = "";
                    SecurityPerson person = this.securityPersonDao.findById(personcertificate.getPersonid());
                    if (personcertificate.getCompanyid() != null) {
                        if (hasApp) {
                            AppNotice appNotice = new AppNotice();
                            appNotice.setNoticeTitle(title);
                            appNotice.setCreateTime(new java.util.Date());
                            appNotice.setActive(Boolean.valueOf(true));
                            appNotice.setNoticeContent("\u3010\u8003\u8bd5\u901a\u77e5\u3011" + appContent.replaceAll("\uff0c", "\\\\n"));
                            appNotice.setNoticeTypeID(Long.valueOf(2L));
                            appNotice.setPersonId(person.getId());
                            appNotice.setReadStatus("0");
                            appNotice.setUpdateTime(new java.util.Date());
                            this.appNoticeDao.save(appNotice);
                            JPushUtil.sendMessage((String)title, (String)("\u3010\u8003\u8bd5\u901a\u77e5\u3011" + appContent), (String)registrationID);
                        } else if ("1".equals(sendMsg) && StringUtils.isNotEmpty((String)personcertificate.getPhone())) {
                            MessageUtil.sendMessage((String)personcertificate.getPhone(), (String)msgContent, (MessageLogDao)this.messageLogDao);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }).start();
    }

    private void sendMsgHeiWei(Personcertificate personcertificate, String title, String msgContent, String appContent, String sendMsg, String[] params, String smsCode) {
        if (StringUtils.isEmpty((String)title) || StringUtils.isEmpty((String)msgContent) || StringUtils.isEmpty((String)appContent)) {
            logger.error("TrainExamPersonServiceImpl\u7c7bsendMsg\u65b9\u6cd5\uff1a\u53d1\u9001\u6d88\u606f\u901a\u77e5\u4f20\u9012\u53c2\u6570title\u6216\u8005msgContent\u6216\u8005appContent\u4e3a\u7a7a");
            return;
        }
        new Thread(() -> {
            try {
                if (personcertificate.getPersonid() == null) {
                    if ("1".equals(sendMsg) && StringUtils.isNotEmpty((String)personcertificate.getPhone())) {
                        MessageUtil.sendMessageHuaWei((String)personcertificate.getPhone(), (String)msgContent, (MessageLogDao)this.messageLogDao, (String[])params, (String)smsCode);
                    }
                } else {
                    boolean hasApp = false;
                    String registrationID = "";
                    SecurityPerson person = this.securityPersonDao.findById(personcertificate.getPersonid());
                    if (personcertificate.getCompanyid() != null) {
                        if (hasApp) {
                            AppNotice appNotice = new AppNotice();
                            appNotice.setNoticeTitle(title);
                            appNotice.setCreateTime(new java.util.Date());
                            appNotice.setActive(Boolean.valueOf(true));
                            appNotice.setNoticeContent("\u3010\u8003\u8bd5\u901a\u77e5\u3011" + appContent.replaceAll("\uff0c", "\\\\n"));
                            appNotice.setNoticeTypeID(Long.valueOf(2L));
                            appNotice.setPersonId(person.getId());
                            appNotice.setReadStatus("0");
                            appNotice.setUpdateTime(new java.util.Date());
                            this.appNoticeDao.save(appNotice);
                            JPushUtil.sendMessage((String)title, (String)("\u3010\u8003\u8bd5\u901a\u77e5\u3011" + appContent), (String)registrationID);
                        } else if ("1".equals(sendMsg) && StringUtils.isNotEmpty((String)personcertificate.getPhone())) {
                            MessageUtil.sendMessageHuaWei((String)personcertificate.getPhone(), (String)msgContent, (MessageLogDao)this.messageLogDao, (String[])params, (String)smsCode);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }).start();
    }
}

