/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.exam.impl;

import cn.hutool.http.HttpUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.exam.TrainExamInfoDao;
import com.bcxin.ars.dao.exam.TrainExamPersonDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.AppNoticeDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.exam.TrainExamInfoDto;
import com.bcxin.ars.dto.exam.TrainExamInfoSearchDto;
import com.bcxin.ars.dto.exam.TrainExamPersonSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.exam.TrainExamInfo;
import com.bcxin.ars.model.exam.TrainExamPerson;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.task.AppNotice;
import com.bcxin.ars.service.exam.TrainExamInfoService;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.HttpClientUtils;
import com.bcxin.ars.util.JPushUtil;
import com.bcxin.ars.util.MessageUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=TrainExamInfo.class)
public class TrainExamInfoServiceImpl
implements TrainExamInfoService {
    private static Logger logger = LoggerFactory.getLogger(TrainExamInfoServiceImpl.class);
    @Autowired
    private TrainExamInfoDao trainExamInfoDao;
    @Autowired
    private TrainExamPersonDao trainExamPersonDao;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private AppNoticeDao appNoticeDao;
    @Autowired
    private MessageLogDao messageLogDao;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private PersoncertificateDao personcertificateDao;

    public PageResult query(TrainExamInfoSearchDto trainExamInfoSearchDto) {
        AjaxPageResponse page = new AjaxPageResponse();
        if (trainExamInfoSearchDto.getOffset() == 0) {
            page.setPageNumber(1);
        } else {
            int pageNumber = trainExamInfoSearchDto.getOffset() / trainExamInfoSearchDto.getLimit() + 1;
            page.setPageNumber(pageNumber);
        }
        page.setPageSize(trainExamInfoSearchDto.getLimit().intValue());
        this.trainExamInfoDao.query(trainExamInfoSearchDto, page);
        return new PageResult(Integer.valueOf((int)page.getTotal()), (Object)page.getData());
    }

    public void save(TrainExamInfoDto trainExamInfoDto, User user) {
        List list = this.trainExamInfoDao.findListByExamName((TrainExamInfo)trainExamInfoDto);
        if (list != null && list.size() > 0) {
            throw new ArsException("\u8003\u8bd5\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0!");
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (StringUtils.isNotEmpty((String)trainExamInfoDto.getComputerStartDateStr())) {
                trainExamInfoDto.setComputerStartDate(dateFormat.parse(trainExamInfoDto.getComputerStartDateStr()));
            }
            if (StringUtils.isNotEmpty((String)trainExamInfoDto.getComputerEndDateStr())) {
                trainExamInfoDto.setComputerEndDate(dateFormat.parse(trainExamInfoDto.getComputerEndDateStr()));
            }
            if (StringUtils.isNotEmpty((String)trainExamInfoDto.getStaminaStartDateStr())) {
                trainExamInfoDto.setStaminaStartDate(dateFormat.parse(trainExamInfoDto.getStaminaStartDateStr()));
            }
            if (StringUtils.isNotEmpty((String)trainExamInfoDto.getStaminaEndDateStr())) {
                trainExamInfoDto.setStaminaEndDate(dateFormat.parse(trainExamInfoDto.getStaminaEndDateStr()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ArsException("\u65e5\u671f\u683c\u5f0f\u9519\u8bef!");
        }
        IdWorker idWorker = new IdWorker();
        trainExamInfoDto.setId(Long.valueOf(idWorker.nextId()));
        trainExamInfoDto.setActive(Boolean.valueOf(true));
        trainExamInfoDto.setCreateTime(new Date());
        trainExamInfoDto.setCreateBy(user.getUsername());
        trainExamInfoDto.setUpdateTime(new Date());
        trainExamInfoDto.setUpdateBy(user.getUsername());
        trainExamInfoDto.setExamState("0");
        trainExamInfoDto.setAreaCode(user.getCityAreaCode());
        this.trainExamInfoDao.insert((TrainExamInfo)trainExamInfoDto);
    }

    public TrainExamInfoDto update(TrainExamInfoDto trainExamInfoDto, User user) {
        if (trainExamInfoDto.getId() == null) {
            throw new ArsException("\u8003\u8bd5ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        TrainExamInfoDto trainExamInfo = this.trainExamInfoDao.selectByPrimaryKey(trainExamInfoDto.getId().longValue());
        if (trainExamInfo == null) {
            throw new ArsException("\u67e5\u627e\u4e0d\u5230\u8003\u8bd5\u4fe1\u606f!");
        }
        List list = this.trainExamInfoDao.findListByExamName((TrainExamInfo)trainExamInfoDto);
        if (list != null && list.size() > 0) {
            throw new ArsException("\u8003\u8bd5\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0!");
        }
        TrainExamPersonSearchDto trainExamPersonSearchDto = new TrainExamPersonSearchDto();
        trainExamPersonSearchDto.setExamID(trainExamInfoDto.getId());
        trainExamPersonSearchDto.setScoreMsgState("1");
        List exitScoreMsgList = this.trainExamPersonDao.list(trainExamPersonSearchDto);
        if (exitScoreMsgList != null && exitScoreMsgList.size() > 0) {
            throw new ArsException("\u8be5\u8003\u8bd5\u5b58\u5728\u7740\u6210\u7ee9\u901a\u77e5\u8fc7\u8003\u751f\uff0c\u53d1\u9001\u6210\u7ee9\u901a\u77e5\u4eba\u5458\u540e\u5c06\u8fdb\u5165\u5ba1\u6279\u73af\u8282\uff0c\u6545\u4e0d\u80fd\u4fee\u6539\u8003\u8bd5\u4fe1\u606f!");
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (StringUtils.isNotEmpty((String)trainExamInfoDto.getComputerStartDateStr())) {
                trainExamInfoDto.setComputerStartDate(dateFormat.parse(trainExamInfoDto.getComputerStartDateStr()));
            }
            if (StringUtils.isNotEmpty((String)trainExamInfoDto.getComputerEndDateStr())) {
                trainExamInfoDto.setComputerEndDate(dateFormat.parse(trainExamInfoDto.getComputerEndDateStr()));
            }
            if (StringUtils.isNotEmpty((String)trainExamInfoDto.getStaminaStartDateStr())) {
                trainExamInfoDto.setStaminaStartDate(dateFormat.parse(trainExamInfoDto.getStaminaStartDateStr()));
            }
            if (StringUtils.isNotEmpty((String)trainExamInfoDto.getStaminaEndDateStr())) {
                trainExamInfoDto.setStaminaEndDate(dateFormat.parse(trainExamInfoDto.getStaminaEndDateStr()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ArsException("\u7406\u8bba\u3001\u5b9e\u64cd\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef!");
        }
        trainExamInfoDto.setUpdateTime(new Date());
        trainExamInfoDto.setUpdateBy(user.getUsername());
        this.trainExamInfoDao.updateByPrimaryKey((TrainExamInfo)trainExamInfoDto);
        trainExamPersonSearchDto = new TrainExamPersonSearchDto();
        trainExamPersonSearchDto.setExamID(trainExamInfoDto.getId());
        trainExamPersonSearchDto.setScoreMsgState("0");
        List exitScoreList = this.trainExamPersonDao.getScorelist(trainExamPersonSearchDto);
        if (exitScoreList != null && exitScoreList.size() > 0) {
            for (TrainExamPerson dbTrainExamPerson : exitScoreList) {
                BigDecimal sumScore;
                int writtenRatio = trainExamInfoDto.getWrittenRatio();
                int operateRatio = trainExamInfoDto.getOperateRatio();
                int writtenPassScore = trainExamInfoDto.getWrittenPassScore();
                int operatePassScore = trainExamInfoDto.getOperatePassScore();
                int examStandard = trainExamInfoDto.getExamStandard();
                int operateScore = dbTrainExamPerson.getOperateScore();
                int writtenScore = dbTrainExamPerson.getWrittenScore();
                Boolean isOperate = false;
                Boolean isWritten = false;
                if (trainExamInfoDto.getIsComputerExam() > 0 && trainExamInfoDto.getIsStamina() < 1) {
                    operateScore = 0;
                    isWritten = true;
                } else if (trainExamInfoDto.getIsComputerExam() < 1 && trainExamInfoDto.getIsStamina() > 0) {
                    writtenScore = 0;
                    isOperate = true;
                } else {
                    isWritten = true;
                    isOperate = true;
                }
                if (trainExamInfoDto.getExamRules() == 1) {
                    sumScore = BigDecimal.valueOf(operateScore + writtenScore);
                    dbTrainExamPerson.setSumScore(sumScore);
                    if (writtenScore >= writtenPassScore && operateScore >= operatePassScore) {
                        dbTrainExamPerson.setTestState("1");
                    } else {
                        dbTrainExamPerson.setTestState("0");
                    }
                } else if (trainExamInfoDto.getExamRules() == 2) {
                    sumScore = BigDecimal.valueOf((double)(operateScore * operateRatio + writtenScore * writtenRatio) * 0.01);
                    dbTrainExamPerson.setSumScore(sumScore);
                    if (sumScore.compareTo(BigDecimal.valueOf(examStandard)) >= 0) {
                        dbTrainExamPerson.setTestState("1");
                    } else {
                        dbTrainExamPerson.setTestState("0");
                    }
                }
                if (isOperate.booleanValue()) {
                    dbTrainExamPerson.setOperateScore(Integer.valueOf(operateScore));
                }
                if (isWritten.booleanValue()) {
                    dbTrainExamPerson.setWrittenScore(Integer.valueOf(writtenScore));
                }
                dbTrainExamPerson.setUpdateTime(new Date());
                this.trainExamPersonDao.updateScore(dbTrainExamPerson);
            }
        }
        trainExamInfoDto = this.trainExamInfoDao.selectByPrimaryKey(trainExamInfoDto.getId().longValue());
        return trainExamInfoDto;
    }

    public TrainExamInfo selectByPrimaryKey(Long examID) {
        if (examID == null) {
            throw new ArsException("\u8003\u8bd5ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        TrainExamInfoDto trainExamInfo = this.trainExamInfoDao.selectByPrimaryKey(examID.longValue());
        if (trainExamInfo == null) {
            throw new ArsException("\u67e5\u627e\u4e0d\u5230\u8003\u8bd5\u4fe1\u606f!");
        }
        return this.trainExamInfoDao.selectByPrimaryKey(examID.longValue());
    }

    public List<TrainExamInfo> list(TrainExamInfoDto trainExamInfoDto) {
        return this.trainExamInfoDao.list((TrainExamInfo)trainExamInfoDto);
    }

    public int cancel(TrainExamInfoDto trainExamInfoDto, User user) {
        if (trainExamInfoDto.getId() == null) {
            throw new ArsException("\u8003\u8bd5ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        TrainExamInfoDto trainExamInfo = this.trainExamInfoDao.selectByPrimaryKey(trainExamInfoDto.getId().longValue());
        if (trainExamInfo == null) {
            throw new ArsException("\u67e5\u627e\u4e0d\u5230\u8003\u8bd5\u4fe1\u606f!");
        }
        List exitsList = this.trainExamPersonDao.exitScore(trainExamInfoDto.getId());
        if (exitsList != null && exitsList.size() > 0) {
            throw new ArsException("\u8be5\u8003\u8bd5\u5b58\u5728\u7740\u5df2\u7ecf\u5f55\u5165\u6210\u7ee9\u4eba\u5458\uff0c\u53d6\u6d88\u8003\u8bd5\u5931\u8d25!");
        }
        TrainExamPersonSearchDto trainExamPersonSearchDto = new TrainExamPersonSearchDto();
        trainExamPersonSearchDto.setExamID(trainExamInfoDto.getId());
        trainExamPersonSearchDto.setNoticeState("1");
        List list = this.trainExamPersonDao.list(trainExamPersonSearchDto);
        if (list != null && list.size() > 0) {
            ArrayList<Long> bbdPersonIDs = new ArrayList<Long>();
            ArrayList<Long> examPersons = new ArrayList<Long>();
            Config config = this.configDao.findByKey("police");
            for (TrainExamPerson item : list) {
                examPersons.add(item.getId());
                try {
                    Personcertificate personcertificate = this.personcertificateDao.findById(item.getBbdPersonID());
                    if (personcertificate == null) continue;
                    bbdPersonIDs.add(item.getId());
                    if (config == null || !StringUtil.isNotEmpty((String)config.getValue()) || !"0".equals(config.getValue())) continue;
                    String title = "";
                    String appContent = "";
                    String msgContent = "";
                    String name = item.getFullname();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
                    SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
                    title = "\u60a8\u7684\u8003\u8bd5\u5b89\u6392\u5df2\u88ab\u53d6\u6d88";
                    appContent = "\u539f\u5b9a\u7406\u8bba\u8003\u8bd5\u65f6\u95f4\uff1a{examDate} {examStart}\u5230 {examEnd}\uff0c\u4f53\u80fd\u8003\u8bd5\u65f6\u95f4\uff1a{staminaDate} {staminaStartDate}\u5230 {staminaEndDate}\uff0c\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\u8003\u8bd5\u5df2\u53d6\u6d88\uff0c\u8003\u8bd5\u65f6\u95f4\u5c06\u53e6\u884c\u901a\u77e5\u3002";
                    appContent = appContent.replace("{name}", name).replace("{examDate}", dateFormat.format(trainExamInfo.getComputerStartDate())).replace("{examStart}", timeFormat.format(trainExamInfo.getComputerEndDate())).replace("{examEnd}", timeFormat.format(trainExamInfo.getComputerEndDate())).replace("{staminaDate}", dateFormat.format(trainExamInfo.getStaminaStartDate())).replace("{staminaStartDate}", timeFormat.format(trainExamInfo.getStaminaStartDate())).replace("{staminaEndDate}", timeFormat.format(trainExamInfo.getStaminaEndDate()));
                    msgContent = "\u60a8\u7684\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\u8003\u8bd5\u5df2\u53d6\u6d88\uff0c\u8003\u8bd5\u65f6\u95f4\u5c06\u53e6\u884c\u901a\u77e5\uff0c\u8bf7\u7559\u610f\u60a8\u7684\u77ed\u4fe1\u901a\u77e5\u3002";
                    this.sendMsg(personcertificate, title, msgContent, appContent);
                }
                catch (Exception e) {
                    logger.error("TrainExamInfoServiceImpl-cancel\u5185\u7f51\u8003\u8bd5\u5b89\u6392\u5bfc\u51fa\u5916\u7f51\u540e\u53d1\u9001\u8003\u8bd5\u53d6\u6d88\u901a\u77e5\u5931\u8d25:" + e.getMessage());
                }
            }
            if (bbdPersonIDs != null && bbdPersonIDs.size() > 0) {
                if (config != null && StringUtil.isNotEmpty((String)config.getValue()) && "1".equals(config.getValue())) {
                    this.personcertificateDao.updateInnerBatchCancelByExamPersonIds(bbdPersonIDs);
                } else {
                    this.personcertificateDao.updateOutBatchCancelByExamPersonIds(bbdPersonIDs);
                }
            }
            if (examPersons != null && examPersons.size() > 0) {
                this.trainExamPersonDao.updateBatchNotNoticeStateByPrimaryKey(examPersons);
            }
        }
        trainExamInfoDto.setExamState("1");
        trainExamInfoDto.setUpdateTime(new Date());
        trainExamInfoDto.setUpdateBy(user.getUsername());
        return this.trainExamInfoDao.updateExamStateByPrimaryKey((TrainExamInfo)trainExamInfoDto);
    }

    public Map<String, Object> exportExamData() {
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        TrainExamInfo trainExamInfoQuery = new TrainExamInfo();
        Calendar updateTime = Calendar.getInstance();
        Date today = new Date();
        updateTime.setTime(today);
        updateTime.add(5, -3);
        trainExamInfoQuery.setUpdateTime(updateTime.getTime());
        List trainExamInfoList = this.trainExamInfoDao.list(trainExamInfoQuery);
        mapData.put("TrainExamInfo", trainExamInfoList);
        TrainExamPersonSearchDto dto = new TrainExamPersonSearchDto();
        dto.setUpdateTime(updateTime.getTime());
        List trainExamPersonList = this.trainExamPersonDao.list(dto);
        mapData.put("TrainExamPerson", trainExamPersonList);
        return mapData;
    }

    public void importExamData(Map<String, Object> examData) {
        String trainUrl = "";
        Config config = this.configDao.findByKey("train_url");
        trainUrl = config.getValue();
        if (examData != null && examData.size() > 0) {
            List trainExamInfoList = null;
            List trainExamPersonList = null;
            String trainExamInfoJson = "";
            String trainExamPersonJson = "";
            if (examData.get("TrainExamInfo") != null) {
                trainExamInfoJson = examData.get("TrainExamInfo").toString();
                trainExamInfoList = JSONObject.parseArray((String)trainExamInfoJson, TrainExamInfo.class);
                ArrayList<TrainExamInfo> cancelTrainExamInfoList = new ArrayList<TrainExamInfo>();
                if (trainExamInfoList != null && trainExamInfoList.size() > 0) {
                    List dbTrainExamInfoList = this.trainExamInfoDao.getExamInfoUpdate(trainExamInfoList);
                    if (dbTrainExamInfoList != null && dbTrainExamInfoList.size() > 0) {
                        Iterator<TrainExamInfo> removeTrainExamInfoList = new ArrayList();
                        block2: for (TrainExamInfo dbTrainExamInfo : dbTrainExamInfoList) {
                            for (TrainExamInfo trainExamInfo : trainExamInfoList) {
                                if (!trainExamInfo.getId().equals(dbTrainExamInfo.getId())) continue;
                                if (!trainExamInfo.getExamState().equals(dbTrainExamInfo.getExamState()) && trainExamInfo.getExamState().equals("1")) {
                                    cancelTrainExamInfoList.add(trainExamInfo);
                                }
                                if (dbTrainExamInfo.getUpdateTime().getTime() < trainExamInfo.getUpdateTime().getTime()) continue;
                                removeTrainExamInfoList.add(trainExamInfo);
                                continue block2;
                            }
                        }
                        if (removeTrainExamInfoList != null && removeTrainExamInfoList.size() > 0) {
                            trainExamInfoList.removeAll((Collection<?>)((Object)removeTrainExamInfoList));
                        }
                    }
                    if (trainExamInfoList != null && trainExamInfoList.size() > 0) {
                        if (cancelTrainExamInfoList != null && cancelTrainExamInfoList.size() > 0) {
                            for (TrainExamInfo trainExamInfo : cancelTrainExamInfoList) {
                                TrainExamPersonSearchDto trainExamPersonSearchDto = new TrainExamPersonSearchDto();
                                trainExamPersonSearchDto.setExamID(trainExamInfo.getId());
                                trainExamPersonSearchDto.setNoticeState("1");
                                List list = this.trainExamPersonDao.list(trainExamPersonSearchDto);
                                if (list == null || list.size() <= 0) continue;
                                for (TrainExamPerson item : list) {
                                    try {
                                        Personcertificate personcertificate = this.personcertificateDao.findById(item.getBbdPersonID());
                                        if (personcertificate == null) continue;
                                        String title = "";
                                        String content = "";
                                        String newstitle = "";
                                        String name = item.getFullname();
                                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                        title = "\u60a8\u7684\u8003\u8bd5\u5b89\u6392\u5df2\u88ab\u53d6\u6d88";
                                        content = "\u539f\u5b9a\u4e8e{examStart}~{examEnd}\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\u8003\u8bd5\u5b89\u6392\u5df2\u53d6\u6d88\uff0c{cancelReason}".replace("{cancelReason}", trainExamInfo.getCancelReason());
                                        newstitle = "\u3010\u7cfb\u7edf\u901a\u77e5\u3011{name}\u539f\u5b9a\u4e8e{examStart}~{examEnd}\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\u8003\u8bd5\u5b89\u6392\u5df2\u53d6\u6d88\uff0c{cancelReason}".replace("{cancelReason}", trainExamInfo.getCancelReason());
                                        content = content.replace("{name}", name).replace("{examStart}", dateFormat.format(trainExamInfo.getComputerStartDate())).replace("{examEnd}", dateFormat.format(trainExamInfo.getComputerEndDate())).replace("{examAddress}", trainExamInfo.getTheoreticalAddress());
                                        newstitle = newstitle.replace("{name}", name).replace("{examStart}", dateFormat.format(trainExamInfo.getComputerStartDate())).replace("{examEnd}", dateFormat.format(trainExamInfo.getComputerEndDate())).replace("{examAddress}", trainExamInfo.getTheoreticalAddress());
                                        this.sendMsg(personcertificate, newstitle, title, content);
                                    }
                                    catch (Exception e) {
                                        logger.error("TrainExamInfoServiceImpl-importExamData\u5185\u7f51\u8003\u8bd5\u5b89\u6392\u5bfc\u51fa\u5916\u7f51\u540e\u53d1\u9001\u8003\u8bd5\u53d6\u6d88\u901a\u77e5\u5931\u8d25:" + e.getMessage());
                                    }
                                }
                            }
                        }
                        this.trainExamInfoDao.batchSaveAndUpdate(trainExamInfoList);
                    }
                }
            }
            if (examData.get("TrainExamPerson") != null && (trainExamPersonList = JSONObject.parseArray((String)(trainExamPersonJson = examData.get("TrainExamPerson").toString()), TrainExamPerson.class)) != null && trainExamPersonList.size() > 0) {
                List dbTrainExamPersonList = this.trainExamPersonDao.getExamPersonUpdate(trainExamPersonList);
                if (dbTrainExamPersonList != null && dbTrainExamPersonList.size() > 0) {
                    ArrayList<TrainExamPerson> removeTrainExamPersonList = new ArrayList<TrainExamPerson>();
                    block6: for (TrainExamPerson dbTrainExamPerson : dbTrainExamPersonList) {
                        for (TrainExamPerson trainExamPerson : trainExamPersonList) {
                            if (!trainExamPerson.getId().equals(dbTrainExamPerson.getId()) || dbTrainExamPerson.getUpdateTime().getTime() < trainExamPerson.getUpdateTime().getTime()) continue;
                            removeTrainExamPersonList.add(trainExamPerson);
                            continue block6;
                        }
                    }
                    if (removeTrainExamPersonList != null && removeTrainExamPersonList.size() > 0) {
                        trainExamPersonList.removeAll(removeTrainExamPersonList);
                    }
                }
                if (trainExamPersonList != null && trainExamPersonList.size() > 0) {
                    this.trainExamPersonDao.batchSaveAndUpdate(trainExamPersonList);
                }
            }
            String resultMsg = "";
            String bktExamInfoBatchSave = trainUrl + "/train/bbd/exam/psave";
            HashMap<String, String> paramMap = new HashMap<String, String>();
            if (trainExamInfoList != null && trainExamInfoList.size() > 0) {
                trainExamInfoJson = JSONObject.toJSONString((Object)trainExamInfoList).replaceAll("\"id\"", "\"examID\"").replaceAll("\"createTime\"", "\"creationdate\"");
                paramMap.put("examInfos", trainExamInfoJson);
            }
            if (trainExamPersonList != null && trainExamPersonList.size() > 0) {
                trainExamPersonJson = JSONObject.toJSONString((Object)trainExamPersonList).replaceAll("\"id\"", "\"personID\"").replaceAll("\"createTime\"", "\"creationdate\"");
                paramMap.put("examPersons", trainExamPersonJson);
            }
            resultMsg = HttpUtil.post((String)bktExamInfoBatchSave, paramMap);
            logger.info(resultMsg);
        }
    }

    public List<TrainExamInfo> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.trainExamInfoDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(TrainExamInfo trainExamInfo) {
        TrainExamInfoDto dbTrainExamInfo;
        if (trainExamInfo.getActive() == null) {
            trainExamInfo.setActive(Boolean.valueOf(true));
        }
        if ((dbTrainExamInfo = this.trainExamInfoDao.selectByPrimaryKey(trainExamInfo.getId().longValue())) != null) {
            if (trainExamInfo.getUpdateTime().getTime() > dbTrainExamInfo.getUpdateTime().getTime()) {
                this.trainExamInfoDao.updateForDS(trainExamInfo);
            }
        } else {
            this.trainExamInfoDao.saveForDS(trainExamInfo);
        }
    }

    private void sendMsg(Personcertificate personcertificate, String title, String msgContent, String appContent) {
        if (StringUtils.isEmpty((String)title) || StringUtils.isEmpty((String)msgContent) || StringUtils.isEmpty((String)appContent)) {
            logger.error("TrainExamPersonServiceImpl\u7c7bsendMsg\u65b9\u6cd5\uff1a\u53d1\u9001\u6d88\u606f\u901a\u77e5\u4f20\u9012\u53c2\u6570title\u6216\u8005msgContent\u6216\u8005appContent\u4e3a\u7a7a");
            return;
        }
        new Thread(() -> {
            try {
                if (personcertificate.getPersonid() == null) {
                    if (StringUtils.isNotEmpty((String)personcertificate.getPhone())) {
                        MessageUtil.sendMessage((String)personcertificate.getPhone(), (String)msgContent, (MessageLogDao)this.messageLogDao);
                    }
                } else {
                    boolean hasApp = false;
                    String registrationID = "";
                    SecurityPerson person = this.securityPersonDao.findById(personcertificate.getPersonid());
                    if (personcertificate.getCompanyid() != null) {
                        if (hasApp) {
                            AppNotice appNotice = new AppNotice();
                            appNotice.setNoticeTitle(title);
                            appNotice.setCreateTime(new Date());
                            appNotice.setActive(Boolean.valueOf(true));
                            appNotice.setNoticeContent("\u3010\u8003\u8bd5\u901a\u77e5\u3011" + appContent.replaceAll("\uff0c", "\\\\n"));
                            appNotice.setNoticeTypeID(Long.valueOf(2L));
                            appNotice.setPersonId(person.getId());
                            appNotice.setReadStatus("0");
                            appNotice.setUpdateTime(new Date());
                            this.appNoticeDao.save(appNotice);
                            JPushUtil.sendMessage((String)title, (String)("\u3010\u8003\u8bd5\u901a\u77e5\u3011" + appContent), (String)registrationID);
                        } else if (StringUtils.isNotEmpty((String)personcertificate.getPhone())) {
                            MessageUtil.sendMessage((String)personcertificate.getPhone(), (String)msgContent, (MessageLogDao)this.messageLogDao);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }).start();
    }

    public void saveExamInfoFromTrain(String areaCode) {
        Config configURL = this.configDao.findByKey("train_url");
        try {
            if (configURL != null && configURL.getValue() != null) {
                String url = configURL.getValue() + "/train/bbd/exam/info";
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("areaCode", areaCode);
                String btkResultJson = HttpClientUtils.doPost((String)url, data, (String)"utf-8");
                Map resultMap = (Map)JSONObject.parseObject((String)btkResultJson, Map.class);
                if (resultMap != null && resultMap.size() > 0 && resultMap.get("data") != null) {
                    List trainExamPersonList;
                    List trainExamInfoList;
                    Map examMap = (Map)JSONObject.parseObject((String)resultMap.get("data").toString(), Map.class);
                    if (examMap.get("examInfo") != null && (trainExamInfoList = JSONObject.parseArray((String)examMap.get("examInfo").toString(), TrainExamInfo.class)) != null && trainExamInfoList.size() > 0) {
                        List dbTrainExamInfoList = this.trainExamInfoDao.getExamInfoUpdate(trainExamInfoList);
                        if (dbTrainExamInfoList != null && dbTrainExamInfoList.size() > 0) {
                            ArrayList<TrainExamInfo> removeTrainExamInfoList = new ArrayList<TrainExamInfo>();
                            block2: for (TrainExamInfo dbTrainExamInfo : dbTrainExamInfoList) {
                                for (TrainExamInfo trainExamInfo : trainExamInfoList) {
                                    if (!trainExamInfo.getId().equals(dbTrainExamInfo.getId()) || dbTrainExamInfo.getUpdateTime().getTime() < trainExamInfo.getUpdateTime().getTime()) continue;
                                    removeTrainExamInfoList.add(trainExamInfo);
                                    continue block2;
                                }
                            }
                            if (removeTrainExamInfoList != null && removeTrainExamInfoList.size() > 0) {
                                trainExamInfoList.removeAll(removeTrainExamInfoList);
                            }
                        }
                        if (trainExamInfoList != null && trainExamInfoList.size() > 0) {
                            this.trainExamInfoDao.batchSaveAndUpdate(trainExamInfoList);
                        }
                    }
                    if (examMap.get("examPerson") != null && (trainExamPersonList = JSONObject.parseArray((String)examMap.get("examPerson").toString(), TrainExamPerson.class)) != null && trainExamPersonList.size() > 0) {
                        List dbTrainExamPersonList = this.trainExamPersonDao.getExamPersonUpdate(trainExamPersonList);
                        if (dbTrainExamPersonList != null && dbTrainExamPersonList.size() > 0) {
                            ArrayList<TrainExamPerson> removeTrainExamPersonList = new ArrayList<TrainExamPerson>();
                            block4: for (TrainExamPerson dbTrainExamPerson : dbTrainExamPersonList) {
                                for (TrainExamPerson trainExamPerson : trainExamPersonList) {
                                    if (!trainExamPerson.getId().equals(dbTrainExamPerson.getId()) || dbTrainExamPerson.getUpdateTime().getTime() < trainExamPerson.getUpdateTime().getTime()) continue;
                                    removeTrainExamPersonList.add(trainExamPerson);
                                    continue block4;
                                }
                            }
                            if (removeTrainExamPersonList != null && removeTrainExamPersonList.size() > 0) {
                                trainExamPersonList.removeAll(removeTrainExamPersonList);
                            }
                        }
                        if (trainExamPersonList != null && trainExamPersonList.size() > 0) {
                            this.trainExamPersonDao.batchSaveAndUpdate(trainExamPersonList);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }
}

