/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.conference.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.conference.ConferenceAccountDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.dto.conference.ComAccountZTree;
import com.bcxin.ars.dto.conference.MeetComDto;
import com.bcxin.ars.dto.conference.PoliceAccountSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.service.conference.ConferenceAccountService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ConferenceAccountServiceImpl
implements ConferenceAccountService {
    public static final Logger logger = LoggerFactory.getLogger(ConferenceAccountServiceImpl.class);
    @Autowired
    private ConferenceAccountDao conferenceAccountDao;
    @Autowired
    private ConfigUtils configUtils;
    @Value(value="${heiweiPrefixKey}")
    private String heiweiPrefixKey;
    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;

    public List<ZTree> getPoliceAccountTree(PoliceAccountSearchDto searchDto) {
        return this.conferenceAccountDao.getPoliceAccountTree(searchDto);
    }

    public List<ComAccountZTree> getcomList() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Config provinceConfig = this.configUtils.getConfigByKey("current_province");
        if ("ARS_arspre_".equals(this.heiweiPrefixKey)) {
            paramMap.put("regProvince", "650000");
        } else {
            paramMap.put("regProvince", provinceConfig.getValue());
        }
        AjaxResult result = this.saasInterfaceUtil.callInterface("/enterprise/company/com-base-info/get-huawei-meet-com-list", paramMap);
        if (result.isSuccessful()) {
            List meetComList = JSONArray.parseArray((String)JSON.toJSONString((Object)result.getData()), MeetComDto.class);
            ArrayList<ComAccountZTree> ztrees = new ArrayList<ComAccountZTree>();
            ComAccountZTree ztree = null;
            for (MeetComDto meetComDto : meetComList) {
                if ("0".equals(meetComDto.getIsOpenMeet())) continue;
                ztree = new ComAccountZTree();
                ztree.setId(meetComDto.getComId());
                ztree.setLabel(meetComDto.getComName());
                ztree.setType("0");
                ztrees.add(ztree);
            }
            return ztrees;
        }
        return null;
    }

    public List<ComAccountZTree> getPersonAccountList(String comId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("comId", comId);
        paramMap.put("pageNumber", 1);
        paramMap.put("pageSize", 200000);
        AjaxResult result = this.saasInterfaceUtil.callInterface("/system/per-base-info/bbd-page-for-huawei-meet-per-info", paramMap);
        if (result.isSuccessful()) {
            JSONObject data = JSONObject.parseObject((String)JSON.toJSONString((Object)result.getData()));
            List meetComList = JSONArray.parseArray((String)JSON.toJSONString((Object)data.get((Object)"data")), MeetComDto.class);
            ArrayList<ComAccountZTree> ztrees = new ArrayList<ComAccountZTree>();
            ComAccountZTree ztree = null;
            for (MeetComDto meetComDto : meetComList) {
                if ("0".equals(meetComDto.getIsOpenMeet())) continue;
                ztree = new ComAccountZTree();
                ztree.setPId(comId);
                ztree.setId(meetComDto.getPerId());
                ztree.setLabel(meetComDto.getName() + (StringUtil.isEmpty((String)meetComDto.getRegulatorMeetChargeType()) ? "" : "(" + meetComDto.getRegulatorMeetChargeType() + ")"));
                ztree.setHuaweiSipName(meetComDto.getHuaweiSipName());
                ztree.setIsLeaf(Boolean.valueOf(true));
                ztree.setRoleName(meetComDto.getRegulatorMeetChargeType());
                ztree.setMobilePhone(meetComDto.getMobilePhone());
                ztree.setType("1");
                ztrees.add(ztree);
            }
            return ztrees;
        }
        return null;
    }

    public Object searchForPage(PoliceAccountSearchDto searchDto, AjaxPageResponse<MeetComDto> page) {
        searchDto.setRegProvince(this.configUtils.getCurrentProvince());
        AjaxResult result = this.saasInterfaceUtil.callInterface("/system/per-base-info/bbd-page-huawei-meet-per-info", searchDto);
        return result.getData();
    }
}

