/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.aspect;

import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import java.lang.reflect.Method;
import java.util.Date;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class JobLogAspect {
    private static final Logger logger = LoggerFactory.getLogger(JobLogAspect.class);
    @Autowired
    private JobRunLogService jobRunLogService;

    @Around(value="@annotation(com.abcxin.smart.validator.annotation.JobLogAnnotation)")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        JobRunLog log = new JobRunLog();
        log.setCreateTime(new Date());
        log.setActive(Boolean.valueOf(true));
        log.setUpdateBy("JobLogAspect");
        Signature sig = pjp.getSignature();
        MethodSignature msig = null;
        if (!(sig instanceof MethodSignature)) {
            logger.error("\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5");
            return pjp.proceed();
        }
        msig = (MethodSignature)sig;
        Object target = pjp.getTarget();
        Method currentMethod = target.getClass().getMethod(msig.getName(), msig.getParameterTypes());
        JobLogAnnotation annotation = currentMethod.getAnnotation(JobLogAnnotation.class);
        long startTime = System.currentTimeMillis();
        Object obj = null;
        try {
            obj = pjp.proceed();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            log.setExceptionMsg(e.toString());
        }
        long endTime = System.currentTimeMillis();
        log.setUpdateTime(new Date());
        log.setJobName(annotation.getJobClazz().getName());
        log.setRunTime(new Date());
        log.setRunTimeLength(endTime - startTime + "ms");
        this.jobRunLogService.insert(log);
        return obj;
    }
}

