package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.TrainrecordPageSearchDto;
import com.bcxin.ars.model.sb.Trainrecord;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;


/**
 * 保安培训单位备案Service接口
 * 
 * @author lin
 * @date 2022-08-14
 */
public interface TrainrecordService{
    /****
     * 删除
     * @param trainrecord
     * @return
     */
    int delete(Trainrecord trainrecord);

    /****
     * 保存
     * @param trainrecord
     * @return
     */
    void save(Trainrecord trainrecord);

    /****
     * 选择性修改
     * @param trainrecord
     * @return
     */
    void updateSelective(Trainrecord trainrecord);

    /****
     * 主键查询
     * @param id
     * @return
     */
    Trainrecord findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(TrainrecordPageSearchDto searchDto, AjaxPageResponse<Trainrecord> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<Trainrecord> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<Trainrecord> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<Trainrecord> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<Trainrecord> findByBatchId(List<Trainrecord> list);


    Trainrecord findByUser(Long userid);

    void saveOrUpdateForApprovalImport(Trainrecord trainrecord);
}
