package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.ConfesscompanyundoSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.sb.Confesscompanyundo;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

/**
 * @author：huangzp
 * @date：2018/04/09
 * @description：自招单位撤销备案接口
 */
public interface ConfesscompanyundoService {

    /**
     * 根据主键id查询
     * @param id
     * @return
     */
    Confesscompanyundo findById(long id);
    /**
     *
     * @Decription:批量查询
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018/8/17 9:15
     * @params： * @param approvalList
     * @return java.util.List<com.bcxin.ars.model.sb.Confesscompanyundo>
     */
    List<Confesscompanyundo> findByBatchId(List<Approval> approvalList);

    /**
     *
     * @Decription:批量更新
     * @author：zhongjianhui
     * @method  updateBatch
     * @date：2018/8/17 9:24
     * @params： * @param list
     * @return void
     */
    void updateBatch(List<Confesscompanyundo> list);
    /**
     * 新增或修改
     * @param confesscompanyundo
     */
    void saveOrUpdate(Confesscompanyundo confesscompanyundo);

    /**
     * 更新导入数据
     * @param confesscompanyundo
     */
    void updateForImport(Confesscompanyundo confesscompanyundo);

    /**
     * 逻辑删除
     * @param id
     */
    void delete(Long id);

    /**
     * 审批
     * @param confesscompanyundo
     */
    void approve(Confesscompanyundo confesscompanyundo);

    /**
     * 搜索查询
     * @param dto
     * @return
     */
    ConfesscompanyundoSearchDto search(ConfesscompanyundoSearchDto dto);

    /**
     * 查询需要生成同步文件的撤销备案记录
     * @param dto
     * @return
     */
    List<Confesscompanyundo> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 查询所有记录
     * @return
     */
    List<Confesscompanyundo> findAll();

    /**
     * 根据用户id获取未提交的单据
     * @param userId
     * @return
     */
   Confesscompanyundo findUNSubmitByUser(Long userId);

    /**
     * 分页查询
     * @param p
     * @return
     */
    PageResult searchConfesscompanyundoList_table(Map<Object, Object> p);


    void saveOrUpdateForDS(Confesscompanyundo confesscompanyundo);

    /**
     * 验证是否重复
     * @param companyName
     * @return
     */
    public boolean checkDupliCompanyundo(String companyName,Long filterId);

    void updateCensorStatus(Confesscompanyundo confesscompanyundo);

    Map<String,Object> selectApplyUserInfoWithId(Long id);

    void searchForPage(ConfesscompanyundoSearchDto dto, AjaxPageResponse<Confesscompanyundo> page);
}
