package com.bcxin.ars.service.enums;

import com.bcxin.ars.service.sb.*;

/**
 * 审批业务对应的接口
 * @author subh
 */
public enum BusinessTypeClass {
    //服务公司
    BAFWGS {
        @Override
        public String getCode() {
            return "001";
        }

        @Override
        public Class getClassz() {
            return SponsorlicenseService.class;
        }
    },
    //培训单位
    PXDW {
        @Override
        public String getCode() {
            return "002";
        }

        @Override
        public Class getClassz() {
            return TraincompanyapplyService.class;
        }
    },
    //子公司
    BAGSZGS {
        @Override
        public String getCode() {
            return "003";
        }

        @Override
        public Class getClassz() {
            return SubsidiaryService.class;
        }
    },
    //保安员证
    BAYZ {
        @Override
        public String getCode() {
            return "004";
        }

        @Override
        public Class getClassz() {
            return PersoncertificateService.class;
        }
    },
    //跨区
    KQYBAGS {
        @Override
        public String getCode() {
            return "005";
        }

        @Override
        public Class getClassz() {
            return CrosscompanyService.class;
        }
    },
    ZXZY {
        @Override
        public String getCode() {
            return "006";
        }

        @Override
        public Class getClassz() {
            return ConfesscompanyService.class;
        }
    },
    //项目变更
    FRBG {
        @Override
        public String getCode() {
            return "007";
        }

        @Override
        public Class getClassz() {
            return LegalchangeService.class;
        }
    },
    //年报
    NDBG {
        @Override
        public String getCode() {
            return "008";
        }

        @Override
        public Class getClassz() {
            return YearreportdataService.class;
        }
    },
    //枪支
    QZPX {
        @Override
        public String getCode() {
            return "009";
        }

        @Override
        public Class getClassz() {
            return ArmorgchargeService.class;
        }
    },
    //撤销
    ZZBACX {
        @Override
        public String getCode() {
            return "010";
        }

        @Override
        public Class getClassz() {
            return ConfesscompanyundoService.class;
        }
    },
    //等级证补贴审批
    DJZBT {
        @Override
        public String getCode() {
            return "011";
        }

        @Override
        public Class getClassz() {
            return LegalchangeService.class;
        }
    },
    //资格证补贴审批
    ZGZBT {
        @Override
        public String getCode() {
            return "012";
        }

        @Override
        public Class getClassz() {
            return LegalchangeService.class;
        }
    },
    //培训单位项目变更
    PXDWXMBG {
        @Override
        public String getCode() {
            return "013";
        }

        @Override
        public Class getClassz() {
            return TrainChangeService.class;
        }
    };


    public abstract String getCode();

    public abstract Class getClassz();

    public static Class convertClass(String code) {
        Class result = null;
        switch (code) {
            case "001":
                result = BAFWGS.getClassz();
                break;
            case "002":
                result = PXDW.getClassz();
                break;
            case "003":
                result = BAGSZGS.getClassz();
                break;
            case "004":
                result = BAYZ.getClassz();
                break;
            case "005":
                result = KQYBAGS.getClassz();
                break;
            case "006":
                result = ZXZY.getClassz();
                break;
            case "007":
                result = FRBG.getClassz();
                break;
            case "008":
                result = NDBG.getClassz();
                break;
            case "009":
                result = QZPX.getClassz();
                break;
            case "010":
                result = ZZBACX.getClassz();
                break;
            case "013":
                result = PXDWXMBG.getClassz();
                break;
            default:
                break;
        }
        return result;
    }
}
