package com.bcxin.ars.service.certificate;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.CertificatePrintLogSearchDto;
import com.bcxin.ars.model.certificate.CertificatePrintLog;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/***
 * 资格证打印日志服务层
 * @author subh
 */
public interface CertificatePrintLogService {
    /***
     * 资格证打印日志查询
     * @param searchDto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<CertificatePrintLog> query(CertificatePrintLogSearchDto searchDto, AjaxPageResponse<CertificatePrintLog> ajaxPageResponse);
    /**
     * 查询需要生成同步文件的保安员资格证记录
     * @param dto
     * @return
     */
    List<CertificatePrintLog> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 外网同步到内网方法
     * @param certificatePrintLog
     */
    void saveOrUpdateForDS(CertificatePrintLog certificatePrintLog);
}
