package com.bcxin.ars.service;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SecurityPersonPractitionerDto;
import com.bcxin.ars.model.Organization;
import com.bcxin.ars.model.SecurityPersonPractitioner;

import java.util.List;

/**
 * 保安员从业情况服务类
 *
 * @author wangjianchi
 */
public interface SecurityPersonPractitionerService {

    List<SecurityPersonPractitioner> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 新增或更新保安员从业情况
     *
     * @param securityPersonPractitioner
     */
    void saveOrUpdate(SecurityPersonPractitioner securityPersonPractitioner);

    /**
     * 删除保安员从业情况
     *
     * @param securityPersonPractitioner
     */
    void delete(SecurityPersonPractitioner securityPersonPractitioner);

    /**
     * 根据用户ID获得保安员从业情况
     *
     * @param id
     * @return
     */
    SecurityPersonPractitioner findById(long id);

    /**
     * 根据身份证号获取保安员从业情况列表
     *
     * @param sfzh
     * @return
     */
    List<Organization> findBySfzh(String sfzh);

    SecurityPersonPractitionerDto search(SecurityPersonPractitionerDto dto);

    void saveOrUpdateForDS(SecurityPersonPractitioner securityPersonPractitioner);

}
