package com.bcxin.ars.service;

import java.util.List;
import java.util.Map;

import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.model.Module;
import org.apache.ibatis.annotations.Param;

/**
 * 业务模块服务类
 * @author Ethan
 */
public interface ModuleService {
	List<Module> findByUserId(Long userid);
	/**
	 * 获取所有业务模块
	 * @return
	 */
	Map<Long, Module> findAll();
	
	/**
	 * 获取保安员所有业务模块
	 * @return
	 */
	List<Module> findAllPerson();

	List<Module> findAllPolice(Long userId);

	/**
	 * 获取角色权限树形
	 * @param id 用户id
	 * @return
	 */
	List<ZTree> getModuleTree();

    /**
     * 批量获取权限列表
     * @param ids id列表
     * @return 模块列表
     * @author subh
     */
    List<Module> findByIdArray(@Param("ids")List<Long> ids);
}
