package com.bcxin.ars.service.task;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.ComTempTaskPerPageSearchDto;
import com.bcxin.ars.model.task.ComTempTaskPer;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;


/**
 * 临保任务人员Service接口
 * 
 * @author lin
 * @date 2021-02-01
 */
public interface ComTempTaskPerService{
    /****
     * 删除
     * @param comTempTaskPer
     * @return
     */
    int delete(ComTempTaskPer comTempTaskPer);

    /****
     * 保存
     * @param comTempTaskPer
     * @return
     */
    int save(ComTempTaskPer comTempTaskPer);

    /****
     * 选择性修改
     * @param comTempTaskPer
     * @return
     */
    void updateSelective(ComTempTaskPer comTempTaskPer);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ComTempTaskPer findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(ComTempTaskPerPageSearchDto searchDto, AjaxPageResponse<ComTempTaskPer> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComTempTaskPer> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ComTempTaskPer> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<ComTempTaskPer> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComTempTaskPer> findByBatchId(List<ComTempTaskPer> list);


}
