package com.bcxin.ars.service.task;

import com.bcxin.ars.dto.AppNoticeSearchDto;
import com.bcxin.ars.model.task.AppNotice;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskPerson;

/**
 * APP消息通知服务类
 * 
 * @author zhangye
 * @version 1.0.9
 */
public interface AppNoticeService {

	/**
	 * 列表查询
	 * 
	 * @param appNotice
	 * @return
	 */
	AppNoticeSearchDto findAppNoticeList(AppNoticeSearchDto appNoticeSearchDto);

	/**
	 * 设置消息通知为已读
	 * 
	 * @param id
	 */
	void updateReadStatus(Long id);

	void save(AppNotice appNotice);

	/**
	 * 保存任务通知
	 * 
	 * @param task
	 * @param taskPerson
	 */
	void saveByTaskPerson(Task task, TaskPerson taskPerson);

}
