package com.bcxin.ars.service.sb;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.sb.PersonAdapt;
import com.bcxin.ars.dto.page.PersonAdaptPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 保安员岗位适应性报名Service接口
 *
 * @author linqinglin
 * @Date 2020-04-10 10:39:21
 */
public interface PersonAdaptService {

   /****
     * 删除
     * @param personAdapt
     * @return
     */
    int delete(PersonAdapt personAdapt);

    /****
     * 保存
     * @param personAdapt
     * @return
     */
    int save(PersonAdapt personAdapt);

    /****
     * 选择性修改
     * @param personAdapt
     * @return
     */
    void updateSelective(PersonAdapt personAdapt);

    /****
     * 主键查询
     * @param id
     * @return
     */
    PersonAdapt findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(PersonAdaptPageSearchDto searchDto, AjaxPageResponse<PersonAdapt> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<PersonAdapt> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<PersonAdapt> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<PersonAdapt> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<PersonAdapt> findByBatchId(List<PersonAdapt> list);

    void batchUpdate(List<PersonAdapt> list);
}
