package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.PerCerGrantPageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.PerCerGrant;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;


/**
 * 保安员证核发Service接口
 * 
 * @author lin
 * @date 2022-09-01
 */
public interface PerCerGrantService{
    /****
     * 删除
     * @param perCerGrant
     * @return
     */
    int delete(PerCerGrant perCerGrant);

    /****
     * 保存
     * @param perCerGrant
     * @return
     */
    int save(PerCerGrant perCerGrant);

    /****
     * 选择性修改
     * @param perCerGrant
     * @return
     */
    void updateSelective(PerCerGrant perCerGrant);

    /****
     * 主键查询
     * @param id
     * @return
     */
    PerCerGrant findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(PerCerGrantPageSearchDto searchDto, AjaxPageResponse<PerCerGrant> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<PerCerGrant> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<PerCerGrant> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<PerCerGrant> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<PerCerGrant> findByBatchId(List<PerCerGrant> list);


    void saveOrUpdateForIntegrate(PerCerGrant perCerGrant, User currentUser);
}
