package com.bcxin.ars.service.msg;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.dto.msg.NewsnoticePoliceSearchDto;
import com.bcxin.ars.dto.page.NewsnoticePolicePageSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.msg.NewsnoticePolice;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

public interface NewsnoticePoliceService {

	PageResult queryTable(NewsnoticePoliceSearchDto searchDto);

	void delete(Long noticeId);

	void recall(Long noticeId);

	NewsnoticePolice findById(Long noticeId);

	void saveOrUpdate(NewsnoticePolice notice);

	void batchDelete(Long[] noticeIds);

	NewsnoticePolice findAllById(Long noticeId);

	void saveOrUpdateForImport(NewsnoticePolice newsnoticePolice);

	/**
	 *获取同步到外网的数据列表
	 * @param startDate 开始日期
	 */
	List<NewsnoticePolice> findDSOutList(String startDate);

	/**
	* @Author: wangcy
	* @Description:同步
	* @Date: 2018/03/08 0008 15:05
	*/
    List<NewsnoticePolice> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);
	/**
	* @Author: wangcy
	* @Description:内网同步数据
	* @Date: 2018/03/08 0008 15:36
	*/
	void saveOrUpdateForDS(NewsnoticePolice newsnoticePolice);


    /****
     * 获取公安用户列表
     * @return
     */
    List<ZTree> getPoliceUserTree();

	/**
	 * 分页查询
	 * @param searchDto
	 * @param page
	 * @return
	 */
	void searchForPage(NewsnoticePolicePageSearchDto searchDto, AjaxPageResponse<NewsnoticePolice> page);
}
