package com.bcxin.ars.service.appeal;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.appeal.AppealSearchDto;
import com.bcxin.ars.model.appeal.Appeal;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/***
 * 申诉信息服务层
 * @author subh
 */
public interface AppealService {

    /**
     * 分页查询
     * @param searchDto
     * @param page
     */
    void searchForPage(AppealSearchDto searchDto, AjaxPageResponse page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<Appeal> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<Appeal> findDSOutList(String startDate);

    /**
     * 批量导入
     * @param list
     */
    void importBatch(List<Appeal> list);
    /***
     * 保存
     * @param appeal
     */
    void save(Appeal appeal);
    /***
     * 保存审批
     * @param appeal
     */
    void saveAppealApproval(Appeal appeal);

    /***
     * 根据ID获取详细信息
     * @param id
     */
    Appeal findById(Long id);

    /**
     * 外网同步到内网方法
     *
     * @param appeal
     */
    void saveOrUpdateForDS(Appeal appeal);

    /**
     * 第三方培训 背景筛查申诉
     *
     * @param appeal 查询条件
     * @return 成功/失败
     */
    AjaxResult submitBackgroundAppeal(String appeal);

    /**
     * 第三方培训 查询背景筛查申诉结果
     *
     * @param appealId 查询条件
     * @return 申诉通过/申诉不通过
     */
    AjaxResult queryBackgroundAppealResult(String appealId);

    AjaxResult applyAppeal(Appeal appeal);

    Appeal findOneByBusinessIdAndType(String businessid, String businesstype);
}
