package com.bcxin.ars.service;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.page.CompanyDto;
import com.bcxin.ars.dto.page.CompanyPageSearchDto;
import com.bcxin.ars.dto.report.CompanyReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.report.SupervisionSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * 安保公司服务类
 * @author Ethan
 */
public interface SecurityCompanyService {
	/*
* 获取安保公司列表
* */
	PageResult querysecurityCompanyList(Map<Object, Object> p);

	/**
	 * @return java.util.Map
	 * @Decription:查询公司总数，初始化数
	 * @author：zhongjianhui
	 * @method queryCompanyStatistics
	 * @date：2018/5/29 14:06
	 * @params： * @param p
	 */
	Map queryCompanyStatistics(Map<Object, Object> p);

	/*
        * 获取安保公司总数
        * */
	int getAllCount(Map<Object, Object> p);

	/*获取安保公司初始化数
	*
	*
	* */
	int getInitCount(Map<Object, Object> p);

	/*获取安保公司未初始化数
*
* */
	int getNotInitCount(Map<Object, Object> p);

	/*获取安保公司今年新增数
*
*
* */
	int getNewAddCount(Map<Object, Object> p);

	/*
	* 根据id获取安保公司详情
	*
	* */
	SecurityCompany queryCompanyDetail(Long id);


	List<SecurityCompany> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	/**
	 * 根据ID获取安保公司
	 *
	 * @param id
	 * @return
	 */
	SecurityCompany findById(Long id);


	List<SecurityCompany> findByAll(String type);

	/**
	 * 查找需要可以补证的公司
	 * @param type
	 * @return
	 */
	List<SecurityCompany> findByAllExceptHaveCer(String type);

    /***
     * 查询公司数据为了部级上报
     * @param type 类型
     * @return
     */
    List<SecurityCompany> findByAllForBj(String type);

	/**
	 * 根据用户ID获取安保公司
	 *
	 * @param userid
	 * @return
	 */
	SecurityCompany findByUserid(Long userid);
	/**
	 * 根据用户名获取安保公司
	 *
	 * @param userName
	 * @return
	 */
	SecurityCompany findByUserName(String userName);

	/**
	 * 根据公司注册号（营业执照号)获取安保公司
	 *
	 * @param socialCode
	 * @return
	 */
	SecurityCompany findBySocialCode(String socialCode);

	/**
	 * 根据名称模糊查找安保公司列表
	 *
	 * @param dto
	 * @return
	 */
	CompanySearchDto search(CompanySearchDto dto);

	/**
	 * 根据名称模糊查找安保公司列表
	 *
	 * @param dto
	 * @return
	 */
	CompanySearchDto searchForPersonInsuredState(CompanySearchDto dto);

	/**
	 * 新增或更新安保公司信息
	 *
	 * @param company
	 */
	void saveOrUpdate(SecurityCompany company);

	/**
	 * 新增或更新安保公司信息(与SAAS对接)
	 *
	 * @param company
	 */
	void saveOrUpdateForSAAS(SecurityCompany company);

	void saveOrUpdateForFX(SecurityCompany company);

	/**
	 * 生成保安员导入模板
	 *
	 * @param file
	 */
	void buildTemplate(SecurityCompany company, File file) throws Exception;

	/**
	 * 获取全部公司的区域分布画像
	 *
	 * @return
	 */
	List<ReportData> findAllAreaReport();

	/**
	 * 获取全部公司的规模画像
	 *
	 * @return
	 */
	Map<String, String[]> findAllScaleReport();

	/**
	 * 获取全部任务的基本画像
	 *
	 * @return
	 */
	Map<String, String[]> findAllTaskLevelReport();

	/**
	 * 指定公司的保安员专业水平画像
	 *
	 * @param id
	 * @return
	 */
	List<ReportData> findProfessionLevelReport(Long id);

	/**
	 * 指定公司的保安员购买保险比例画像
	 *
	 * @param id
	 * @return
	 */
	List<ReportData> findSecurityPersonReport(Long id);


	/**
	 * 指定公司的保安员学习比例画像
	 *
	 * @param id
	 * @return
	 */
	List<ReportData> findSecurityPersonStudyReport(Long id);

	Long getSecurityTotalCount(Long id);

	/**
	 * 指定公司的保安员祖籍画像
	 *
	 * @param id
	 * @return
	 */
	Map<String, String[]> findNativeReport(Long id);

	/**
	 * 指定公司的任务分类画像
	 *
	 * @param id
	 * @return
	 */
	Map<String, String[]> findTaskCatalogReport(Long id);

	/**
	 * 指定公司的任务级别画像
	 *
	 * @param id
	 * @return
	 */
	List<ReportData> findTaskLevelReport(Long id);

	/**
	 * 获取该公司学习统计时长排名，value为时长，name名字。
	 *
	 * @param id
	 * @return
	 */
	List<ReportData> getStudyListDesc(Long id);

	AjaxResult checkCompanyPolicy();

	Long findNoPowerCount(Long id);

	PersonStudySearchDTO personStudySearch(PersonStudySearchDTO dto);

	void resetPwd(Long companyid);

	void deleteCompany(Long companyid);

	void updateCompany(SecurityCompany company);

	void updateCompanyAccout(SecurityCompany company);

	CompanySearchDto searchForManager(CompanySearchDto dto);
	/**
	 *
	 * @Decription:查询管理公司list
	 * @author：zhongjianhui
	 * @method  searchForManagerList_table
	 * @date：2018/9/27 10:14
	 * @params： * @param p
	 * @return com.bcxin.ars.model.PageResult
	 */
	PageResult searchForManagerList_table(Map<Object, Object> p);

	void exportCompanys(List<SecurityCompany> data, File file);

	void exportCompanysData(List<SecurityCompany> data, File file);

	void buildCompanyTemplate(File file) throws Exception;

	Map<String, Object> importCompany(File targetFile) throws Exception;

	Map<String, Object> importCompanyData(File targetFile) throws Exception;

	void saveOrUpdateForDS(SecurityCompany securityCompany);

	SecurityCompany findByRawId(Long rawid);

	SecurityCompany findByInRawId(Long inrawid);

	List<SecurityCompany> searchForExportData(CompanySearchDto dto);

	void updateExport(SecurityCompany securityCompany);

	String changeToARSSafeRange(String securityScopeType);

	void saveForImport(SecurityCompany securityCompany);

	CompanyReportData dataStatisticsReport(ReportDataSearchDto searchDto);

	SupervisionSearchDto supervisionSearch(SupervisionSearchDto searchDto);

	PageResult querySupervisionList(SupervisionSearchDto searchDto);

	Long supervisionSearchCount(SupervisionSearchDto searchDto);

	Long dataStatisticsPersonTotalReport(SupervisionSearchDto searchDto);

	Long dataStatisticsPolicyReport(SupervisionSearchDto searchDto);

	JSONObject supervisionTotal(SupervisionSearchDto searchDto);

	JSONObject supervisionDetail(Long companyId);

	JSONObject companySecurityDetail(Long companyId);

	void updateOperatorphone(SecurityCompany securityCompany);

	/**
	 * @Decription:搜索有修改待同步到外网的数据
     * @param startDate 开始时间
     * @return
     */
	List<SecurityCompany> searchForExport(String startDate);

	/***
	 * 批量发送短信
	 * @param phones 手机列表
	 */
	void batchSendMessage(List<String> phones);

	List<ZTree> getCompanyTree();

	SecurityCompany getCurrentUserCompany();

	/**
	 * 批量导入人员
	 * by llc 2018-08-20
	 *
	 * @param list
	 * @param user
	 * @param company
	 */
	List<Map<String, String>> batchImportPerson(List<Map<String, String>> list,int batchId, User user, SecurityCompany company);

	/**
	 *获取同步到外网的数据列表
	 * @param startDate 开始日期
	 */
	List<SecurityCompany> findDSOutList(String startDate);

	/**
	 * @Decription:批量保存修改
	 * @param list
	 * @return
	 */
	void importBatch(List<SecurityCompany> list);

	/**
	 * 公司分页查询
	 * @param dto
	 * @param page
	 */
    void searchForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page);



    /**
     * 公司分页查询用于预警
     * @param dto
     * @param page
     */
    void situationForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page);

    void updateCertificatesPhoto(List<SecurityCompany> companys);


    /***
     * 根据公安服务安全平台ComId获取单位信息
     * @param comId
     * @return
     */
    SecurityCompany findByComId(Long comId);

    /***
     * 根据任务ID获取公司信息
     * @param comId
     * @return
     */
    SecurityCompany findByComTaskId(Long comId);

    void searchConfessComForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page);

    List<SecurityCompany> findSubCompany(String parentId);

	List<String> selectCompanyName(String institutionType);

    void publicSearchForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page);

    void revokeCompany(Long companyid);

	void resetCompanyCode();
}
