package com.bcxin.ars.service;

import java.util.List;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.HistorySearchDto;
import com.bcxin.ars.model.SearchHistory;
import com.bcxin.ars.model.User;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

/**
 * 搜索历史服务类
 * @author Ethan
 */
public interface SearchHistoryService {
	
	void save(SearchHistory searchHistory);
	
	public List<SearchHistory> findByUserid(Long userid);
	
	public SearchHistory findById(Long id);
	
	public void save(String context,String searchType,User user);
	
	public void saveOrUpdate(String context,String searchType,User user);
	
	public HistorySearchDto search(HistorySearchDto dto);
	
	public AjaxResult searchHistory(HistorySearchDto dto);

	public AjaxResult deleteHistory(long id);

	public AjaxResult deleteAllHistory();

    void searchForPage(HistorySearchDto searchDto, AjaxPageResponse<SearchHistory> page);
}