package com.bcxin.ars.service;

import java.util.List;

import com.bcxin.ars.model.Permission;

/**
 * 权限服务类
 * @author Ethan
 */
public interface PermissionService {

	/**
	 * 通过角色获取权限
	 * @param role
	 * @return
	 */
	List<Permission> findByRole(Long roleid, String roletype,String moduletype);

	/**
	 * 新增或更新角色权限
	 * @param permission
	 */
	void save(Permission permission);
	
	/**
	 * 新增或更新角色权限
	 * @param permission
	 */
	void saveOrUpdate(Long roleid, Long[] operationIds, String roletype);
	
	/**
	 * 删除权限
	 * @param permission
	 */
	void delete(Permission permission);

	/**
	 * 通过角色删除权限
	 * @param role
	 */
	void deleteByRole(Long roleid, String roletype);


	/***
	 *
	 * @param user
	 * @return
	 */
	List<Permission> findByUserId(Long user);


	List<Permission> findByGAUserId(Long userid);

	/***
	 * 获取所有权限列表菜单
	 * @return  权限列表
	 */
	List<Permission> findAllForPlatform(Integer platform);

	void saveOrUpdateForDS(Permission permission);

}
