import Layout from '@/layout';

const distributionRouter = {
  path: '/distribution',
  component: Layout,
  redirect: '/distribution/index',
  name: 'Distribution',
  meta: {
    title: '分销',
    icon: 'clipboard',
  },
  children: [
    {
      path: 'earningReport',
      component: () => import('@/views/distribution/earningReport'),
      name: 'earningReport',
      meta: { title: '业绩报表', icon: '' },
      children: [
        {
          path: 'distributionPeople',
          component: () => import('@/views/distribution/earningReport/distributionPeople'),
          name: 'distributionPeople',
          meta: { title: '分销员账单', icon: '' },
        },

        {
          path: 'distributionCompany',
          component: () => import('@/views/distribution/earningReport/distributionCompany'),
          name: 'distributionCompany',
          meta: { title: '分销商账单', icon: '' },
        },

        {
          path: 'channelCommission',
          component: () => import('@/views/distribution/earningReport/channelCommission'),
          name: 'channelCommission',
          meta: { title: '渠道佣金', icon: '' },
        }
      ]
    },

    {
      path: 'performanceBill',
      component: () => import('@/views/distribution/performanceBill'),
      name: 'performanceBill',
      meta: { title: '业绩账单', icon: '' },
      children: [
        {
          path: 'distributor',
          component: () => import('@/views/distribution/performanceBill/distributor'),
          name: 'performanceDistributor',
          meta: { title: '分销员账单', icon: '' },
        },

        {
          path: 'companyBill',
          component: () => import('@/views/distribution/performanceBill/companyBill'),
          name: 'performanceCompanyBill',
          meta: { title: '分销商账单', icon: '' },
        },

        {
          path: 'channelBill',
          component: () => import('@/views/distribution/performanceBill/channelBill'),
          name: 'performanceChannelBill',
          meta: { title: '渠道商账单', icon: '' },
        }
      ]
    }
  ],
};

export default distributionRouter;
