/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2014-2016 abel533@gmail.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package tk.mybatis.springboot.controller;

import com.github.pagehelper.util.StringUtil;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import tk.mybatis.springboot.model.SmsRecord;
import tk.mybatis.springboot.service.SmsRecordService;
import tk.mybatis.springboot.util.HuaWeiRespConst;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author liuzh
 * @since 2015-12-19 11:10
 */
@Controller
@RequestMapping("/sms")
@Transactional
public class IndexController {


    @Resource
    private SmsRecordService smsRecordService;

    @RequestMapping("/search")
    public String view(HttpServletRequest req){
        String mobile = req.getParameter("mobile");
        List<SmsRecord> list = Lists.newArrayList();
        if (StringUtil.isNotEmpty(mobile)) {
            list = smsRecordService.selectByMobile(mobile);
            for (SmsRecord sms:list) {
                sms.setRet(HuaWeiRespConst.get(sms.getRet()));
            }
        }
        req.setAttribute("smsList",list);
        return "view";
    }

    @RequestMapping("/resetSend/{code}")
    public void resetSend(@PathVariable String code){
        if("m0gjs2JHfak55s".equals(code)){
            smsRecordService.selectReset();
        }
    }

}
