/*
 * Decompiled with CFR 0.152.
 */
package com.wlsk.plugin.qiniu.route.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.qiniu.common.QiniuException;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.BucketInfo;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.storage.model.FileListing;
import com.qiniu.util.Auth;
import com.wlsk.plugin.qiniu.config.PluginQiNiuOssConfig;
import com.wlsk.plugin.qiniu.domain.cs.QiNiuOssClientConfig;
import com.wlsk.plugin.qiniu.domain.cs.SliceConfigCs;
import com.wlsk.plugin.qiniu.domain.model.DirectoryOssInfo;
import com.wlsk.plugin.qiniu.domain.model.FileOssInfo;
import com.wlsk.plugin.qiniu.domain.model.OssInfoVo;
import com.wlsk.plugin.qiniu.route.QiniuRoute;
import com.wlsk.plugin.qiniu.util.OssPathUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QiniuRouteImpl
implements QiniuRoute {
    private static final Logger log = LoggerFactory.getLogger(QiniuRouteImpl.class);
    private Configuration configuration;
    @Autowired
    private PluginQiNiuOssConfig pluginQiNiuOssConfig;

    @Override
    public Auth initAuth(String accessKey, String secretKey) {
        if (StringUtils.isEmpty((CharSequence)accessKey) || StringUtils.isEmpty((CharSequence)secretKey)) {
            return Auth.create((String)this.pluginQiNiuOssConfig.getAccessKey(), (String)this.pluginQiNiuOssConfig.getSecretKey());
        }
        return Auth.create((String)accessKey, (String)secretKey);
    }

    @Override
    public String initBucket(String bucketName) {
        Auth auth = this.initAuth(null, null);
        Configuration configuration = this.initConfiguration();
        BucketManager bucketManager = new BucketManager(auth, configuration);
        try {
            BucketInfo bucketInfo = bucketManager.getBucketInfo(bucketName);
            if (ObjectUtil.isNull((Object)bucketInfo)) {
                bucketManager.createBucket(bucketName, this.pluginQiNiuOssConfig.getClientConfig().getRegion().getRegion());
            }
        }
        catch (QiniuException e) {
            log.error("\u521b\u5efaBucket\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        return bucketName;
    }

    @Override
    public Configuration initConfiguration() {
        Configuration configuration = null;
        if (ObjectUtil.isNull((Object)this.pluginQiNiuOssConfig)) {
            configuration = this.configuration;
        } else {
            configuration = Optional.ofNullable(this.pluginQiNiuOssConfig.getClientConfig()).orElse(new QiNiuOssClientConfig()).toClientConfig(this.pluginQiNiuOssConfig.getRegion());
            SliceConfigCs sliceConfig = this.pluginQiNiuOssConfig.getSliceConfig();
            configuration.resumableUploadAPIVersion = Configuration.ResumableUploadAPIVersion.V2;
            configuration.resumableUploadMaxConcurrentTaskCount = sliceConfig.getTaskNum();
            configuration.resumableUploadAPIV2BlockSize = sliceConfig.getPartSize().intValue();
        }
        return configuration;
    }

    @Override
    public OssInfoVo upload(InputStream inputStream, String fileName) {
        Configuration configuration = this.initConfiguration();
        UploadManager uploadManager = new UploadManager(configuration);
        try {
            uploadManager.put(inputStream, this.getKey(fileName, false), this.getUpToken(), null, null);
        }
        catch (QiniuException e) {
            String errorMsg = String.format("%s\u4e0a\u4f20\u5931\u8d25", fileName);
            log.error(errorMsg, (Throwable)e);
            throw new RuntimeException(e);
        }
        return this.getInfo(fileName, false);
    }

    @Override
    public String getBasePath() {
        return this.pluginQiNiuOssConfig.getBasePath();
    }

    @Override
    public OssInfoVo getInfo(String targetName, Boolean isRecursion) {
        String key = this.getKey(targetName, false);
        OssInfoVo ossInfo = this.getBaseInfo(targetName);
        if (isRecursion.booleanValue() && this.isDirectory(key).booleanValue()) {
            BucketManager bucketManager = new BucketManager(this.initAuth(null, null), this.initConfiguration());
            FileListing listFiles = null;
            try {
                listFiles = bucketManager.listFiles(this.initBucket(this.pluginQiNiuOssConfig.getBucket()), key, "", 1000, "/");
            }
            catch (QiniuException e) {
                throw new RuntimeException(e);
            }
            ArrayList<OssInfoVo> fileOssInfos = new ArrayList<OssInfoVo>();
            ArrayList<OssInfoVo> directoryInfos = new ArrayList<OssInfoVo>();
            if (ObjectUtil.isNotEmpty((Object)listFiles.items)) {
                for (FileInfo fileInfo : listFiles.items) {
                    fileOssInfos.add(this.getInfo(OssPathUtil.replaceKey(fileInfo.key, this.getBasePath(), false), false));
                }
            }
            if (ObjectUtil.isNotEmpty((Object)listFiles.commonPrefixes)) {
                for (String string : listFiles.commonPrefixes) {
                    String target = OssPathUtil.replaceKey(string, this.getBasePath(), true);
                    directoryInfos.add(this.getInfo(target, true));
                }
            }
            if (ObjectUtil.isNotEmpty(fileOssInfos) && fileOssInfos.get(0) instanceof FileOssInfo) {
                ReflectUtil.setFieldValue((Object)ossInfo, (String)"fileInfos", fileOssInfos);
            }
            if (ObjectUtil.isNotEmpty(directoryInfos) && directoryInfos.get(0) instanceof DirectoryOssInfo) {
                ReflectUtil.setFieldValue((Object)ossInfo, (String)"directoryInfos", directoryInfos);
            }
        }
        ossInfo.setFullPath(this.pluginQiNiuOssConfig.getDomain() + this.pluginQiNiuOssConfig.getBasePath() + ossInfo.getName());
        return ossInfo;
    }

    private String getUpToken() {
        return this.initAuth(null, null).uploadToken(this.initBucket(this.pluginQiNiuOssConfig.getBucket()));
    }

    private OssInfoVo getBaseInfo(String targetName) {
        OssInfoVo ossInfo;
        String key = this.getKey(targetName, false);
        if (this.isFile(targetName).booleanValue()) {
            ossInfo = new FileOssInfo();
            try {
                BucketManager bucketManager = new BucketManager(this.initAuth(null, null), this.initConfiguration());
                FileInfo fileInfo = bucketManager.stat(this.initBucket(this.pluginQiNiuOssConfig.getBucket()), key);
                String putTime = DateUtil.date((long)(fileInfo.putTime / 10000L)).toString("yyyy-MM-dd HH:mm:ss");
                ossInfo.setLength(Convert.toStr((Object)fileInfo.fsize));
                ossInfo.setCreateTime(putTime);
                ossInfo.setLastUpdateTime(putTime);
            }
            catch (QiniuException e) {
                String errorMsg = String.format("\u83b7\u53d6%s\u4fe1\u606f\u5931\u8d25", targetName);
                log.error(errorMsg, (Throwable)e);
                throw new RuntimeException(errorMsg, e);
            }
        } else {
            ossInfo = new DirectoryOssInfo();
        }
        ossInfo.setName(StrUtil.equals((CharSequence)targetName, (CharSequence)"/") ? targetName : FileNameUtil.getName((String)targetName));
        ossInfo.setPath(OssPathUtil.replaceKey(targetName, ossInfo.getName(), true));
        return ossInfo;
    }
}

