/*
 * Decompiled with CFR 0.152.
 */
package com.wlsk.plugin.qiniu.domain.cs;

import com.qiniu.storage.Configuration;
import com.wlsk.plugin.qiniu.domain.enums.QiNiuRegionEnum;

public class QiNiuOssClientConfig {
    public QiNiuRegionEnum region = QiNiuRegionEnum.AUTOREGION;
    public boolean useHttpsDomains = true;
    public boolean accUpHostFirst = true;
    public boolean useDefaultUpHostIfNone = true;
    public int putThreshold = 0x400000;
    public int connectTimeout = 10;
    public int writeTimeout = 0;
    public int readTimeout = 30;
    public int dispatcherMaxRequests = 64;
    public int dispatcherMaxRequestsPerHost = 16;
    public int connectionPoolMaxIdleCount = 32;
    public int connectionPoolMaxIdleMinutes = 5;
    public int retryMax = 5;

    public Configuration toClientConfig() {
        Configuration configuration = new Configuration();
        configuration.region = this.region.buildRegion();
        configuration.useHttpsDomains = this.useHttpsDomains;
        configuration.accUpHostFirst = this.accUpHostFirst;
        configuration.useDefaultUpHostIfNone = this.useDefaultUpHostIfNone;
        configuration.putThreshold = this.putThreshold;
        configuration.connectTimeout = this.connectTimeout;
        configuration.writeTimeout = this.writeTimeout;
        configuration.readTimeout = this.readTimeout;
        configuration.dispatcherMaxRequests = this.dispatcherMaxRequests;
        configuration.dispatcherMaxRequestsPerHost = this.dispatcherMaxRequestsPerHost;
        configuration.connectionPoolMaxIdleCount = this.connectionPoolMaxIdleCount;
        configuration.connectionPoolMaxIdleMinutes = this.connectionPoolMaxIdleMinutes;
        configuration.retryMax = this.retryMax;
        return configuration;
    }

    public Configuration toClientConfig(String region) {
        Configuration configuration = new Configuration();
        configuration.region = QiNiuRegionEnum.getRegionEnum(region).buildRegion();
        configuration.useHttpsDomains = this.useHttpsDomains;
        configuration.accUpHostFirst = this.accUpHostFirst;
        configuration.useDefaultUpHostIfNone = this.useDefaultUpHostIfNone;
        configuration.putThreshold = this.putThreshold;
        configuration.connectTimeout = this.connectTimeout;
        configuration.writeTimeout = this.writeTimeout;
        configuration.readTimeout = this.readTimeout;
        configuration.dispatcherMaxRequests = this.dispatcherMaxRequests;
        configuration.dispatcherMaxRequestsPerHost = this.dispatcherMaxRequestsPerHost;
        configuration.connectionPoolMaxIdleCount = this.connectionPoolMaxIdleCount;
        configuration.connectionPoolMaxIdleMinutes = this.connectionPoolMaxIdleMinutes;
        configuration.retryMax = this.retryMax;
        return configuration;
    }

    public QiNiuRegionEnum getRegion() {
        return this.region;
    }

    public boolean isUseHttpsDomains() {
        return this.useHttpsDomains;
    }

    public boolean isAccUpHostFirst() {
        return this.accUpHostFirst;
    }

    public boolean isUseDefaultUpHostIfNone() {
        return this.useDefaultUpHostIfNone;
    }

    public int getPutThreshold() {
        return this.putThreshold;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getDispatcherMaxRequests() {
        return this.dispatcherMaxRequests;
    }

    public int getDispatcherMaxRequestsPerHost() {
        return this.dispatcherMaxRequestsPerHost;
    }

    public int getConnectionPoolMaxIdleCount() {
        return this.connectionPoolMaxIdleCount;
    }

    public int getConnectionPoolMaxIdleMinutes() {
        return this.connectionPoolMaxIdleMinutes;
    }

    public int getRetryMax() {
        return this.retryMax;
    }

    public QiNiuOssClientConfig setRegion(QiNiuRegionEnum region) {
        this.region = region;
        return this;
    }

    public QiNiuOssClientConfig setUseHttpsDomains(boolean useHttpsDomains) {
        this.useHttpsDomains = useHttpsDomains;
        return this;
    }

    public QiNiuOssClientConfig setAccUpHostFirst(boolean accUpHostFirst) {
        this.accUpHostFirst = accUpHostFirst;
        return this;
    }

    public QiNiuOssClientConfig setUseDefaultUpHostIfNone(boolean useDefaultUpHostIfNone) {
        this.useDefaultUpHostIfNone = useDefaultUpHostIfNone;
        return this;
    }

    public QiNiuOssClientConfig setPutThreshold(int putThreshold) {
        this.putThreshold = putThreshold;
        return this;
    }

    public QiNiuOssClientConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public QiNiuOssClientConfig setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public QiNiuOssClientConfig setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public QiNiuOssClientConfig setDispatcherMaxRequests(int dispatcherMaxRequests) {
        this.dispatcherMaxRequests = dispatcherMaxRequests;
        return this;
    }

    public QiNiuOssClientConfig setDispatcherMaxRequestsPerHost(int dispatcherMaxRequestsPerHost) {
        this.dispatcherMaxRequestsPerHost = dispatcherMaxRequestsPerHost;
        return this;
    }

    public QiNiuOssClientConfig setConnectionPoolMaxIdleCount(int connectionPoolMaxIdleCount) {
        this.connectionPoolMaxIdleCount = connectionPoolMaxIdleCount;
        return this;
    }

    public QiNiuOssClientConfig setConnectionPoolMaxIdleMinutes(int connectionPoolMaxIdleMinutes) {
        this.connectionPoolMaxIdleMinutes = connectionPoolMaxIdleMinutes;
        return this;
    }

    public QiNiuOssClientConfig setRetryMax(int retryMax) {
        this.retryMax = retryMax;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QiNiuOssClientConfig)) {
            return false;
        }
        QiNiuOssClientConfig other = (QiNiuOssClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseHttpsDomains() != other.isUseHttpsDomains()) {
            return false;
        }
        if (this.isAccUpHostFirst() != other.isAccUpHostFirst()) {
            return false;
        }
        if (this.isUseDefaultUpHostIfNone() != other.isUseDefaultUpHostIfNone()) {
            return false;
        }
        if (this.getPutThreshold() != other.getPutThreshold()) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getWriteTimeout() != other.getWriteTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.getDispatcherMaxRequests() != other.getDispatcherMaxRequests()) {
            return false;
        }
        if (this.getDispatcherMaxRequestsPerHost() != other.getDispatcherMaxRequestsPerHost()) {
            return false;
        }
        if (this.getConnectionPoolMaxIdleCount() != other.getConnectionPoolMaxIdleCount()) {
            return false;
        }
        if (this.getConnectionPoolMaxIdleMinutes() != other.getConnectionPoolMaxIdleMinutes()) {
            return false;
        }
        if (this.getRetryMax() != other.getRetryMax()) {
            return false;
        }
        QiNiuRegionEnum this$region = this.getRegion();
        QiNiuRegionEnum other$region = other.getRegion();
        return !(this$region == null ? other$region != null : !((Object)((Object)this$region)).equals((Object)other$region));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QiNiuOssClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseHttpsDomains() ? 79 : 97);
        result = result * 59 + (this.isAccUpHostFirst() ? 79 : 97);
        result = result * 59 + (this.isUseDefaultUpHostIfNone() ? 79 : 97);
        result = result * 59 + this.getPutThreshold();
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getWriteTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + this.getDispatcherMaxRequests();
        result = result * 59 + this.getDispatcherMaxRequestsPerHost();
        result = result * 59 + this.getConnectionPoolMaxIdleCount();
        result = result * 59 + this.getConnectionPoolMaxIdleMinutes();
        result = result * 59 + this.getRetryMax();
        QiNiuRegionEnum $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : ((Object)((Object)$region)).hashCode());
        return result;
    }

    public String toString() {
        return "QiNiuOssClientConfig(region=" + this.getRegion() + ", useHttpsDomains=" + this.isUseHttpsDomains() + ", accUpHostFirst=" + this.isAccUpHostFirst() + ", useDefaultUpHostIfNone=" + this.isUseDefaultUpHostIfNone() + ", putThreshold=" + this.getPutThreshold() + ", connectTimeout=" + this.getConnectTimeout() + ", writeTimeout=" + this.getWriteTimeout() + ", readTimeout=" + this.getReadTimeout() + ", dispatcherMaxRequests=" + this.getDispatcherMaxRequests() + ", dispatcherMaxRequestsPerHost=" + this.getDispatcherMaxRequestsPerHost() + ", connectionPoolMaxIdleCount=" + this.getConnectionPoolMaxIdleCount() + ", connectionPoolMaxIdleMinutes=" + this.getConnectionPoolMaxIdleMinutes() + ", retryMax=" + this.getRetryMax() + ")";
    }
}

