/*
 * Decompiled with CFR 0.152.
 */
package com.wlsk.plugin.utils;

import cn.hutool.core.convert.Convert;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtils {
    public static String getParameter(String name) {
        return ServletUtils.getRequest().getParameter(name);
    }

    public static String getParameter(String name, String defaultValue) {
        return Convert.toStr((Object)ServletUtils.getRequest().getParameter(name), (String)defaultValue);
    }

    public static Integer getParameterToInt(String name) {
        return Convert.toInt((Object)ServletUtils.getRequest().getParameter(name));
    }

    public static Integer getParameterToInt(String name, Integer defaultValue) {
        return Convert.toInt((Object)ServletUtils.getRequest().getParameter(name), (Integer)defaultValue);
    }

    public static Boolean getParameterToBool(String name) {
        return Convert.toBool((Object)ServletUtils.getRequest().getParameter(name));
    }

    public static Boolean getParameterToBool(String name, Boolean defaultValue) {
        return Convert.toBool((Object)ServletUtils.getRequest().getParameter(name), (Boolean)defaultValue);
    }

    public static HttpServletRequest getRequest() {
        try {
            return ServletUtils.getRequestAttributes().getRequest();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HttpServletResponse getResponse() {
        try {
            return ServletUtils.getRequestAttributes().getResponse();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HttpSession getSession() {
        return ServletUtils.getRequest().getSession();
    }

    public static ServletRequestAttributes getRequestAttributes() {
        try {
            RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
            return (ServletRequestAttributes)attributes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getHeader(HttpServletRequest request, String name) {
        String value = request.getHeader(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        return ServletUtils.urlDecode(value);
    }

    public static Map<String, String> getHeaders(HttpServletRequest request) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration enumeration = request.getHeaderNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = request.getHeader(key);
                map.put(key, value);
            }
        }
        return map;
    }

    public static String renderString(HttpServletResponse response, String string) {
        try {
            response.setStatus(200);
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

