/*
 * Decompiled with CFR 0.152.
 */
package com.wlsk.plugin.domain.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.wlsk.plugin.domain.cs.RespCode;
import java.io.Serializable;
import javax.validation.constraints.NotNull;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int code;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String msg;
    private String status;
    private long timestamp = System.currentTimeMillis();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private T data;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String exception;

    public Result() {
    }

    private Result(T data) {
        this.data = data;
    }

    @NotNull
    public static <T> Result<?> tokenInvalid() {
        Result<T> result = new Result<T>();
        result.setStatus(Status.HTTP_UNAUTHORIZED.getMsg());
        result.setCode(RespCode.TOKEN_VALID);
        result.setMsg("\u8bf7\u767b\u5f55\u540e\u91cd\u8bd5!");
        return result;
    }

    public static <T> Result<T> SUCCESS() {
        return new Result<T>().success();
    }

    public static <T> Result<T> SUCCESS(String message) {
        return new Result<T>().success(message);
    }

    public static <T> Result<T> SUCCESS(Integer code, String message) {
        return new Result<T>().success(code, message);
    }

    public static <T> Result<T> SUCCESS(T data) {
        return new Result<T>(data).success();
    }

    public static <T> Result<T> SUCCESS(T data, String message) {
        return new Result<T>(data).success(message);
    }

    public static <T> Result<T> FAIL() {
        return new Result<T>().failure();
    }

    public static <T> Result<T> FAIL(String message) {
        return new Result<T>().failure(message);
    }

    public static <T> Result<T> FAIL(Integer code, String message) {
        return new Result<T>().failure(code, message);
    }

    public static <T> Result<T> FAIL(T data) {
        return new Result<T>(data).failure();
    }

    public static <T> Result<T> FAIL(T data, String message) {
        return new Result<T>(data).failure(message);
    }

    private Result success() {
        this.status = Status.SUCCESS.getMsg();
        this.code = Code.OK.getCode();
        return this;
    }

    private Result success(String message) {
        this.status = Status.SUCCESS.getMsg();
        this.code = Code.OK.getCode();
        this.msg = message;
        return this;
    }

    private Result success(int code, String message) {
        this.status = Status.SUCCESS.getMsg();
        this.code = code;
        this.timestamp = System.currentTimeMillis();
        this.msg = message;
        return this;
    }

    private Result failure() {
        this.status = Status.ERROR.getMsg();
        this.code = Code.FAILURE.getCode();
        return this;
    }

    private Result failure(String message) {
        this.status = Status.ERROR.getMsg();
        this.code = Code.FAILURE.getCode();
        this.msg = message;
        return this;
    }

    private Result failure(int code, String message) {
        this.status = Status.ERROR.getMsg();
        this.code = code;
        this.msg = message;
        return this;
    }

    private Result failure(int code, String message, String status) {
        this.status = status;
        this.code = code;
        this.msg = message;
        return this;
    }

    public boolean ok() {
        return this.code == Code.OK.getCode() && this.status.equals(Status.SUCCESS.getMsg());
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        return "Result{code=" + this.code + ", msg='" + this.msg + "', status='" + this.status + "', timestamp=" + this.timestamp + ", data=" + this.data + ", exception='" + this.exception + "'}";
    }

    public static enum Status {
        SUCCESS("success"),
        ERROR("error"),
        HTTP_UNAUTHORIZED("Unauthorized"),
        HTTP_FORBIDDEN("Forbidden"),
        HTTP_NOT_FOUND("Not Found"),
        HTTP_BAD_METHOD("Method Not Allowed"),
        HTTP_UNSUPPORTED_TYPE("Unsupported Media Type");

        private String msg;

        public String getMsg() {
            return this.msg;
        }

        private Status(String code) {
            this.msg = code;
        }
    }

    public static enum Code {
        OK(200),
        FAILURE(500),
        NotFound(404);

        private int code;

        public int getCode() {
            return this.code;
        }

        private Code(int code) {
            this.code = code;
        }
    }

    public static enum Msg {
        ERROR("\u8bf7\u6c42\u9519\u8bef"),
        HTTP_UNAUTHORIZED("\u672a\u6388\u6743"),
        HTTP_FORBIDDEN("\u8bf7\u6c42\u7981\u6b62"),
        HTTP_NOT_FOUND("\u8bf7\u6c42\u63a5\u53e3\u672a\u627e\u5230"),
        HTTP_BAD_METHOD("\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u5141\u8bb8"),
        HTTP_UNSUPPORTED_TYPE("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u4e0d\u5141\u8bb8");

        private final String msg;

        public String getMsg() {
            return this.msg;
        }

        private Msg(String msg) {
            this.msg = msg;
        }
    }
}

