package com.bcxin.platform.util.constants;

/**
 * 公用常量编码
 */
public final class CommonConst {


	public final static String DEFAULT_VALIDATE_CODE = "123456";

	public final static String TRACK_ = "TRACK_"; // 公安子站轨迹地址


	public final static String OPEN_SUBSTATION = "OPEN_SUBSTATION"; // 是否开启陕西子站地址默认站点(0：未开启,1：开启)

	public final static String MEET_INCOME_COMID = "MEET_INCOME_COMID"; // 会议收入企业ID

	public final static String ORDER_YW_EMAIL = "ORDER_YW_EMAIL"; // 订单处理人邮箱，多个逗号隔开

	public final static String SYS_PIC_HTTP_ADDR = "SYS_PIC_HTTP_ADDR"; // 订单处理人邮箱，多个逗号隔开

	public final static String PAYMENT_PLATFORM_URL = "PAYMENT_PLATFORM_URL"; // 支付平台服务地址

	public final static String THIRD_SALARY_URL = "THIRD_SALARY_URL"; // 第三方薪酬系统URL

	public final static String BDP_URL = "BDP_URL"; // 百川信数据分发中心URL

	public final static String PLAT_COMID = "PLAT_COMID"; // 平台企业ID

	public final static String YWRZ_URL = "YWRZ_URL"; // 业务日志接口URL

	/************ sys_config配置 ************/

	/************ 其他常量配置 ************/

	public final static String Y = "1"; // 是

	public final static String N = "0"; // 否

	public final static String OP_SUCCESS = "操作成功";
	public final static String OP_FAILURE = "操作失败";


	public final static String APP_KIND = "1";//百联保投保人角色标识
	public final static String INS_KIND = "2";//百联保被保人角色标识

	/**
	 * 已删除
	 */
	public final static String DELETE = "1"; // 已删除

	public final static String RETTYPE_SUCCESS = "0"; // 返回成功

	public final static String RETTYPE_FAIL = "-1"; // 返回失败

	public final static String DATE_CODE_YM = "yyyyMM"; // 日期编码

	public final static String DATE_CODE_YMD = "yyyy-MM-dd"; // 日期编码

	public final static String DATE_CODE_LONG = "yyyy-MM-dd HH:mm:ss"; // 日期编码

	public final static String ENCODE_UTF8_TEXT = "text/html; charset=UTF-8"; // 字符集编码UTF-8

	public final static String XLS = "xls"; // excel 1997-2003格式

	public final static String XLSX = "xlsx"; // excel 2003-2011格式

	public final static String SEPARATOR = "\\."; // 分隔符 分割文件名

	public final static String SLASH = "/"; // 斜杠

	public final static String EQUAL = "="; // 等号

	public final static String AND = "&"; // 与

	public final static String VIRGULE = "|"; // 竖线

	public final static String COLON_CN = "："; // 中文冒号

	public final static String COLON = ":"; // 冒号

	public final static String SEMICOLON = ";"; // 分号

	public final static String MINUS = "-"; // 减号

	public final static String DOT = "."; // 点

	public final static String COMMA = ","; // 逗号

	public final static String SIGN = "#"; // #

	public final static String COLON_SLASH = "://"; // 斜杠冒号

	public final static String DOLLAR = "$"; // 美元符号

	public final static String NULLSTRING = "<br/>"; // 空行

	public final static String BLANK_CHAR = ""; // 空字符串

	public final static String CONNECT_CHAR = "_"; // 空字符串

	public final static int LOOSE_PAGE_NUMBER = 10; // 宽松页码

	public final static int COMPACT_PAGE_NUMBER = 20; // 紧凑页码

	public final static String HTTP_OK = "200";

	public final static String HTTP_FAIL = "300";

	public final static String IMAGE_FORM = "jpg|jpeg|gif|png|bmp|JPG|JPEG|GIF|PNG|BMP"; // 图片格式

	public final static String PLATFORM = "SAAS"; // 平台名称

	/************ 统一认证客户端类型：1web段、2手机端 ************/
	public final static String CLIENTTYPE_WEB = "1"; // WEB端
	public final static String CLIENTTYPE_MOBILE = "2"; // 手机端

	/******* 百课堂平台ID ********/
	public final static String PLATFORMID_BKT_MH = "1401"; // 百课堂-门户网站
	public final static String PLATFORMID_BKT_BG = "1402"; // 百课堂-后台管理
	/******* 百保盾平台ID ********/
	public final static String PLATFORMID_BBD = "11"; // 百保盾平台
	/******* PSS公共安全平台ID ********/
	public final static String PLATFORMID_PSS = "12"; // PSS平台
	/************ 通用边界值（int）,用于数字类字段参数初始化引用 ************/
	public final static int BOUNDARY_INT_ZERO = 0; // 通用值0
	public final static int BOUNDARY_INT_ONE = 1; // 通用值1
	public final static int BOUNDARY_INT_TWO = 2; // 通用值2
	/******* 审批系统管理 ********/
	public static final String ACTIVITI_TASKTYPE1 = "1";
	public static final String ACTIVITI_TASKTYPE2 = "2";
	public static final String ACTIVITI_TASKTYPE3 = "3";
	public static final String ACTIVITI_TASK = "task";
	public static final String ACTIVITI_END_TASK = "endTask";
	public static final String ACTIVITI_PROCESS = "process";
	public static final String ACTIVITI_GATEWAY = "gateway";
	/******* POST 请求超时时间 ********/
	public static final String POS_TIME_OUT = "POS_TIME_OUT";
	/*************** 腾讯云相关配置 ****************/
	// 腾讯云SECRETID
	public static final String TENCENT_SECRETID = "TENCENT_SECRETID";
	// 腾讯云SECRETKEY
	public static final String TENCENT_SECRETKEY = "TENCENT_SECRETKEY";
	// 腾讯云SDKAPPID
	public static final String TENCENT_SDKAPPID = "TENCENT_SDKAPPID";
	// 腾讯云动态库的地址
	public static final String TENCENT_LIBPATH = "TENCENT_LIBPATH";
	// 腾讯云私钥地址
	public static final String TENCENT_EC_KEY = "TENCENT_EC_KEY";
	// 腾讯云公钥地址
	public static final String TENCENT_PUBLIC_KEY = "TENCENT_PUBLIC_KEY";
	// 腾讯云接口服务器地址
	public static final String TENCENT_IM_URL = "TENCENT_IM_URL";
	// 腾讯云管理员账号
	public static final String TENCENT_ADMIN = "TENCENT_ADMIN";
	/*************** 账号加密方式 ****************/
	public static final String ENCRYTYPE_PSS = "3";

	/*************** 企业同步日志 接口执行状态 ****************/
	public static final String INF_EXEC_STATUS_SUCCESS = "1";
	public static final String INF_EXEC_STATUS_FAILED = "0";
	public static final String INF_EXEC_STATUS_NOT_STARTED = "2";

	/******百课堂支付 防止重复提交时间*****/
	/* 30秒 */
	public static final int CACHE_EXPIRE_SECONDS_HALF_MIN = 30;

	/*************** 渤海联名卡相关配置 ****************/
	// 联名卡申请地址
	public static final String BOHAI_JOINTLYCARD_APPLY_URL = "BOHAI_JOINTLYCARD_APPLY_URL";
	// 联名卡申请查询地址
	public static final String BOHAI_JOINTLYCARD_QUERY_URL = "BOHAI_JOINTLYCARD_QUERY_URL";
	// 联名卡申请加密key
	public static final String BOHAI_JOINTLYCARD_APPLY_AESKEY = "BOHAI_JOINTLYCARD_APPLY_AESKEY";
}