package com.bcxin.platform.mapper.order;


import com.bcxin.platform.domain.order.ComOrderDetail;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 企业订单详情
 *
 * @author llc
 * @date 2020-01-15
 */
@Component
public interface ComOrderDetailMapper{

    /**
     * 插入企业订单详情列表
     * @param orderDetailList
     * @author llc
     * @date 2020-01-15
     * @return
     */
    int insertComOrderDetailList(@Param("list") List<ComOrderDetail> orderDetailList);


    /**
     * 获取订单明细列表
     * @param orderIdList
     * @author llc
     * @date 2020-01-17
     * @return
     */
    List<Map<String,Object>> getOrderDetailListByOrderIdS(@Param("list") List<Long> orderIdList);

    /**
     * <b> 根据订单详情列重新组装数据 </b>
     * @author ZXF
     * @create 2020/04/22 0022 10:55
     * @version
     * @注意事项 </b>
     */
    List<Map<String,String>> packageOrderDetail(@Param("list") List<ComOrderDetail> list);

    /**
     * <b> 根据详情id列查询机构名称（多个逗号隔开） </b>
     * @author ZXF
     * @create 2020/05/28 0028 11:02
     * @version
     * @注意事项 </b>
     */
    List<Map<String,String>> getAssignedOrgNameByComOrderDetailIds(@Param("list") List<String> list);

    List<Map<String,String>> getOrderDetailListByOrderId(@Param("comOrderId") Long comOrderId);

    /**
     * <b> 查询明天到期的订单信息 </b>
     * @author ZXF
     * @create 2020/05/27 0027 18:03
     * @version
     * @注意事项 </b>
     */
    List<Map<String,String>> findDueOrderList();

    List<Map<String,String>> findOrderAndProductListByOrderId(@Param("comOrderId") Long comOrderId);

    /**
     * <b> 根据被分配的机构id查询关联的资源信息 </b>
     * @author ZXF
     * @create 2020/05/25 0025 17:42
     * @version
     * @注意事项 </b>
     */
    List<Map<String,String>> getOrderDetailListByAssignedOrgId(@Param("assignedOrgId") Long assignedOrgId);

}