package com.bcxin.platform.dto.grant;

import com.bcxin.platform.domain.grant.PerJointlyCard;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 人员联名卡dto
 *
 * @author llc
 * @date 2020-07-21
 */
@Data
public class PerJointlyCardDTO extends PerJointlyCard {

    /** 关键字 */
    @ApiModelProperty(value = "关键字")
    private String keyword ;

    /** 部门Id */
    @ApiModelProperty(value = "部门")
    private Long departId ;

    /** 是否全部选中 */
    @ApiModelProperty(value = "是否全部选中")
    private String isCheckAll ;

    /** 人员ID集合 */
    @ApiModelProperty(value = "人员ID集合")
    private String perIds ;

    /** 姓名 */
    @ApiModelProperty(value = "姓名")
    private String name ;

    /** 身份证 */
    @ApiModelProperty(value = "身份证")
    private String idCardNo ;

    /** 手机号 */
    @ApiModelProperty(value = "手机号")
    private String mobilePhone ;

    /** 性别 */
    @ApiModelProperty(value = "性别")
    private String sex ;

    /**
     * 部门ID集合
     */
    @ApiModelProperty(value = "部门ID集合")
    private String departIds;

    /**
     * 部门Id列表
     */
    @ApiModelProperty(value = "部门Id列表")
    private List<Long> departIdList;

    /**
     * 人员位置经度
     */
    @ApiModelProperty(value = "人员位置经度")
    private String perLongitude;

    /**
     * 人员位置纬度
     */
    @ApiModelProperty(value = "人员位置纬度")
    private String perLatitude;

}
