package com.bcxin.obpm.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.bcxin.obpm.mapper.ObpmCompanyMapper;
import com.bcxin.obpm.domain.ObpmCompany;
import com.bcxin.obpm.service.ObpmCompanyService;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;


/**
 * V5企业Service业务层处理
 * 
 * @author lin
 * @date 2021-06-06
 */
@Service
public class ObpmCompanyServiceImpl implements ObpmCompanyService{

    @Resource
    private ObpmCompanyMapper obpmCompanyMapper;

    /**
     * 查询V5企业
     * 
     * @param ID V5企业ID
     * @return V5企业
     */
    @Override
    public ObpmCompany selectObpmCompanyById(String ID){
        return obpmCompanyMapper.selectObpmCompanyById(ID);
    }

    /**
     * 查询V5企业列表
     * 
     * @return V5企业
     */
    @Override
    public List<ObpmCompany> selectObpmCompanyList(){
        return obpmCompanyMapper.selectObpmCompanyList();
    }

}
