package com.bcxin.oaflow.mapper;

import com.bcxin.oaflow.domain.LeaveApplication;
import com.bcxin.oaflow.dto.OaBusinessDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 请假Mapper接口
 * 
 * @author lin
 * @date 2021-09-01
 */
public interface LeaveApplicationMapper{

    /**
     * 查询请假
     * 
     * @param id 请假ID
     * @return 请假
     */
    LeaveApplication findById(String id);

    /**
     * 查询请假列表
     * 
     * @param tlkPerIds
     * @param schedulDate
     * @return 请假集合
     */
    List<LeaveApplication> selectList(@Param("list")List<String> tlkPerIds,@Param("schedulDate")String schedulDate);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<LeaveApplication> findByBatchId(@Param("list") List<LeaveApplication> list);

    /**
     * 查询出差列表
     *
     * @param tlkPerId
     * @param schedulDate
     * @return 出差集合
     */
    List<OaBusinessDto> findByUserId(@Param("tlkPerId")String tlkPerId, @Param("schedulDate")String schedulDate);
}
