package com.bcxin.platform.service.wallet.manage;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.wallet.PerWalletAccount;
import com.bcxin.platform.dto.SearchParamDTO;
import com.bcxin.platform.mapper.wallet.manage.PerWalletManageMapper;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.util.JwtUtil;
import com.bcxin.platform.util.constants.CommonConst;
import com.bcxin.platform.util.constants.PaymentServiceConst;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <b> 企业钱包信息 </b>
 * @author ZXF
 * @create 2019/09/02 0002 11:06
 * @version
 * @注意事项 </b>
 */
@Service
public class PerWalletManageServiceImpl implements PerWalletManageService {

    private Logger logger = LoggerFactory.getLogger(PerWalletManageServiceImpl.class);

    @Autowired
    private PerWalletManageMapper perWalletMapper;
    @Autowired
    private CommonService commonService;


    /**
     * <b> 企业钱包列表的分页查询 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:46
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<Map<String,Object>> pagePerInsList(SearchParamDTO dto) throws V5BusinessException {
        /*查询有效记录*/
        return perWalletMapper.pagePerWalletList(dto);
    }

    /**
     * <b> 查询企业钱包账户 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:46
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result getPerWalletAccountByPerId(SearchParamDTO dto) throws V5BusinessException {
        if (StringUtils.isEmpty(dto.getPerId())) {
            throw new V5BusinessException(Result.ERROR, "参数perId不能为空");
        }
        Map<String, Object> rec = perWalletMapper.getPerWalletAccountByPerId(Long.parseLong(dto.getPerId()));
        /*** 调用支付平台接口获取账户相关资料 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("perId", dto.getPerId());
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", JwtUtil.createJWT(p));//加密生成token
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        Result r1 = JSON.parseObject(
                HttpUtil.post(platUrl + PaymentServiceConst.GET_WALLET_ACCOUNT, requestMap)
                , Result.class);
        System.out.println(JSON.toJSONString(r1));
        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(r1.getRetType())) {
            Map<String, Object> map = (Map<String, Object>) r1.getData();
            /*** 账户状态 ***/
            rec.put("accountStatus",PaymentServiceConst.getAccountStatus(map.get("account_state").toString()));
            //获取金额
            p.put("walletAccountNo", rec.get("walletAccountNo"));
            requestMap.put("token", JwtUtil.createJWT(p));//加密生成token
            Result r2 = JSON.parseObject(
                    HttpUtil.post(platUrl + PaymentServiceConst.GET_COM_WALLET_ACCOUNT_AMOUNT, requestMap)
                    , Result.class);
            System.out.println(JSON.toJSONString(r2));
            if (Result.SUCCESS.equals(r2.getRetType())) {
                Map<String, Object> map2 = (Map<String, Object>) r2.getData();
                /*** 账户总额 ***/
                rec.put("totalAmount", map2.get("ledger_bal"));
                /*** 可用余额 ***/
                rec.put("availableAmount", map2.get("available_bal"));
                /*** 冻结金额 ***/
                rec.put("frozenAmount", map2.get("funds_held"));
            } else {
                /*** 返回失败则抛错 ***/
                return Result.fail(r2.getMsg());
            }
        } else {
            /*** 返回失败则抛错 ***/
            return Result.fail(r1.getMsg());
        }
        return Result.success(Result.SUCCESS_MSG, rec);
    }

    /**
     * <b> 更新企业钱包账户 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:48
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result updatePerWalletAccount(PerWalletAccount perWalletAccount) throws V5BusinessException {
        if (perWalletAccount.getPerId() == null) {
            throw new V5BusinessException(Result.ERROR, "参数perId不能为空");
        }
        if (StringUtils.isEmpty(perWalletAccount.getMobilePhone())) {
            throw new V5BusinessException(Result.ERROR, "参数绑定手机号不能为空");
        }
        int count = perWalletMapper.updatePerWalletAccount(perWalletAccount);
        if(count == 0){
            return Result.fail(Result.ERROR_MSG);
        }
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * <b> 获取企业钱包账户交易明细 </b>
     * @author ZXF
     * @create 2019/09/03 0003 10:36
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<Map<String,Object>> getPerWalletAccountTradeDetail(SearchParamDTO dto,Integer page,Integer rows) throws V5BusinessException {

        if (dto.getPerId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
        }
        if (StringUtils.isEmpty(dto.getWalletAccountNo())) {
            throw new V5BusinessException(Result.ERROR, "企业钱包账户号不能为空");
        }
        if (page == null) {
            throw new V5BusinessException(Result.ERROR, "第几页不能为空");
        }
        if (rows == null) {
            throw new V5BusinessException(Result.ERROR, "每页多少行不能为空");
        }
        if (StringUtils.isEmpty(dto.getStartTime())) {
            throw new V5BusinessException(Result.ERROR, "开始日期不能为空");
        }
        if (StringUtils.isEmpty(dto.getEndTime())) {
            throw new V5BusinessException(Result.ERROR, "结束日期不能为空");
        }

        /*** 调用支付平台接口获取账户交易明细 ***/

        Map<Object, Object> p = new HashMap<>();
        p.put("id", dto.getPerId());
        p.put("pageNumber", page.toString());
        p.put("pageSize", rows.toString());
        p.put("walletAccountNo", dto.getWalletAccountNo());
        p.put("startDate", dto.getStartTime());
        p.put("endDate", dto.getEndTime());

        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.GET_COM_WALLET_ACCOUNT_TRADE_DETAIL, requestMap);
        Result result = JSON.parseObject(resultStr, Result.class);
        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {

            Map<String, Object> map = (Map<String, Object>) result.getData();
            if (Integer.parseInt(map.get("total_size").toString()) == 0) {
                return new ArrayList();
            } else {
                /*** 解析返回的列表数据 ***/
                ArrayList<Map> recordlist = JSON.parseObject(map.get("balance_records").toString(), new TypeReference<ArrayList<Map>>() {
                });
                List<Map<String, Object>> list = new ArrayList<>();
                if (recordlist.size() > 0) {
                    for (Map<String, Object> record : recordlist) {
                        Map<String, Object> m = new HashMap<>();
                        m.put("trade_date", record.get("trade_date").toString().substring(0, record.get("trade_date").toString().length() - 2)); // 交易时间
                        m.put("trade_flow_no", record.get("trade_flow_no")); // 交易流水号
                        m.put("flow_no", record.get("flow_no")); // 账务流水号
                        m.put("accounts_deal_type", PaymentServiceConst.getAccountDealType(record.get("accounts_deal_type").toString())); //账务处理类型
                        m.put("accounts_deal_date", record.get("accounts_deal_date").toString().substring(0, record.get("accounts_deal_date").toString().length() - 2)); // 账务处理时间
                        m.put("amount", record.get("amount")); // 交易金额
                        m.put("balance", record.get("balance")); // 交易后余额
                        m.put("direction", PaymentServiceConst.getDirection(record.get("direction").toString())); // 资金流向
                        m.put("hand_status", PaymentServiceConst.getHandStatus(record.get("hand_status").toString())); // 处理状态
                        m.put("create_date", record.get("create_date").toString().substring(0, record.get("create_date").toString().length() - 2)); // 订单创建时间
                        m.put("serviceType", PaymentServiceConst.getServiceType(record.get("service_code").toString())); // 服务类型
                        m.put("trade_type", PaymentServiceConst.getTradeType(record.get("trade_type").toString())); // 交易类型
                        m.put("account_in", StringUtils.isEmpty(record.get("account_in").toString())?"-":record.get("account_in")); // 收款方账户
                        m.put("account_out", StringUtils.isEmpty(record.get("account_out").toString())?"-":record.get("account_out")); // 付款方账户
                        m.put("wallet_account_no", dto.getWalletAccountNo()); // 主体账户号
                        m.put("perId", dto.getPerId()); // 主体账户号
                        // 收款方账户中文
                        if (StringUtils.isEmpty(record.get("account_in").toString())) {
                            m.put("account_in_name", "-");
                        } else {
                            String perName = perWalletMapper.getPerNameByWalletNo(record.get("account_in").toString());
                            m.put("account_in_name",StringUtils.isEmpty(perName)?"-":perName);
                        }
                        // 收款方账户中文
                        if (StringUtils.isEmpty(record.get("account_out").toString())) {
                            m.put("account_out_name", "-");
                        } else {
                            String perName = perWalletMapper.getPerNameByWalletNo(record.get("account_out").toString());
                            m.put("account_out_name",StringUtils.isEmpty(perName)?"-":perName);
                        }
                        m.put("memo", StringUtils.isEmpty(record.get("memo").toString())?"-":record.get("memo")); // 备注
                        list.add(m);
                    }
                }
                return list;
            }
        } else {
            /*** 返回失败则抛错 ***/
            logger.error(result.getMsg());
            return new ArrayList();
        }

    }

    /**
     * <b> 电子回单 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:19
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result getPerAccountTradeVoucher(SearchParamDTO dto) throws V5BusinessException {
        if (dto.getTradeFlowNo() == null) {
            throw new V5BusinessException(Result.ERROR, "交易流水号不能为空");
        }
        /*** 调用支付平台接口获取电子回单 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("perId", dto.getPerId());
        p.put("bizOrderNo", dto.getTradeFlowNo());
        p.put("walletAccountNo", dto.getWalletAccountNo());
        System.out.println(p.toString());
        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        return JSON.parseObject(
                HttpUtil.post(platUrl + PaymentServiceConst.ACCOUNT_TRADE_VOUCHER, requestMap)
                , Result.class);//base_content
    }


    /**
     * <b> 交易凭证 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:20
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result getPerAccountPayVoucher(SearchParamDTO dto) throws V5BusinessException {
        if (dto.getTradeFlowNo() == null) {
            throw new V5BusinessException(Result.ERROR, "交易流水号不能为空");
        }
        /*** 调用支付平台接口获取电子回单 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("bizOrderNo", dto.getTradeFlowNo());
        System.out.println(p.toString());
        //加密生成token
        String token = JwtUtil.createJWT(p);
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.ACCOUNT_PAY_VOUCHER, requestMap);
        return JSON.parseObject(resultStr, Result.class);//
    }

}
