package com.bcxin.platform.service.wallet;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.wallet.ComWallet;
import com.bcxin.platform.domain.wallet.ComWalletAccount;
import com.bcxin.platform.domain.wallet.ComWalletProcess;
import com.bcxin.platform.domain.wallet.ComWalletTrade;
import com.bcxin.platform.dto.wallet.*;

import javax.servlet.http.HttpServletResponse;

/**
 * 企业钱包服务
 *
 * @author llc
 * @date 2019-06-21
 */
public interface ComWalletService {

    /**
     * 获取企业钱包服务开通情况
     *
     * @param comWallet
     * @return
     * @author llc
     * @date 2019-06-21
     */
    Result getComWalletServiceOpenInfo(ComWallet comWallet) throws V5BusinessException;

    /**
     * 获取企业钱包服务当前开通步骤
     *
     * @param comWalletProcess
     * @return
     * @author llc
     * @date 2019-06-21
     */
    Result getComWalletCurrentProcess(ComWalletProcess comWalletProcess) throws V5BusinessException;


    /**
     * 发送验证码
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-06-22
     */
    Result sendVerifyCode(ComWalletAccountDTO dto) throws V5BusinessException;


    /**
     * 保存开户资料
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-06-21
     * @update by llc 2020-09-10
     */
    Result saveAccountInfo(ComWalletAccountDTO dto) throws V5BusinessException;


    /**
     * 保存开户资料第二步
     *
     * @param comWalletAccount
     * @return
     * @author llc
     * @date 2019-06-21
     */
    Result saveAccountInfoStepTwo(ComWalletAccount comWalletAccount) throws V5BusinessException;


    /**
     * 获取企业钱包账户
     *
     * @param comWalletAccount
     * @author llc
     * @date 2019-06-21
     */
    Result getComWalletAccount(ComWalletAccount comWalletAccount) throws V5BusinessException;

    /**
     * <b> 会员档案认证 </b>
     * @author ZXF
     * @create 2023/02/17 0017 15:55
     * @version
     * @注意事项 </b>
     */
    Result getAccountConfirm(ComWalletAccount comWalletAccount) throws V5BusinessException;

    /**
     * 获取企业钱包账户金额
     *
     * @param comWalletAccount
     * @author llc
     * @date 2019-06-24
     */
    Result getComWalletAccountAmount(ComWalletAccount comWalletAccount) throws V5BusinessException;


    /**
     * 获取企业钱包账户交易明细
     *
     * @param dto
     * @author llc
     * @date 2019-06-21
     */
    Result getComWalletAccountTradeDetail(ComWalletAccountDTO dto) throws V5BusinessException;

    /**
     * <b> 获取企业钱包账户交易明细（请求转存数据，当天只能查到昨天的数据） </b>
     * @author ZXF
     * @create 2023/04/23 0023 10:37
     * @version
     * @注意事项 </b>
     */
    Result thisComWalletAccountTradeDetail(ComWalletAccountDTO dto) throws V5BusinessException;

    public Result comWalletAccountTradeDetailSch();

    Result comWalletAccountTradeDetailTask(String startDate, String endDate);

    ///**
    // * 对接支付平台获取企业钱包账户交易明细
    // * @return
    // * @author lp
    // * @date 2019-12-09
    // */
    //List<ComWalletAccountDetail> getAccountTradeDetailByComId(Long comId, String walletAccountNo, String startDate, String endDate);


    /**
     * 获取企业钱包充值token
     *
     * @param dto
     * @author llc
     * @date 2019-06-26
     */
    Result getWalletRechargeToken(ComWalletAccountDTO dto) throws V5BusinessException;

    /**
     * 企业钱包开户回调
     *
     * @param token
     * @author llc
     * @date 2019-06-28
     */
    Result comWalletRegisterCallback(String token) throws V5BusinessException, Exception;

    /**
     * 企业钱包充值回调
     *
     * @param token
     * @author llc
     * @date 2019-06-28
     */
    Result comWalletRechargeCallback(String token) throws V5BusinessException, Exception;


    /**
     * 获取企业充值交易状态
     *
     * @param comWalletTrade
     * @author llc
     * @date 2019-06-28
     */
    Result getWalletTradeInfo(ComWalletTrade comWalletTrade) throws V5BusinessException;

    /**
     * <b> 根据业务编码或业务交易流水号查询交易信息 </b>
     * @author ZXF
     * @create 2023/03/23 0023 10:20
     * @version
     * @注意事项 </b>
     */
    Result getComWalletTradeBySeqAndCode(ComWalletTrade comWalletTrade) throws V5BusinessException;

    /**
     * 企业钱包账户提现
     *
     * @param dto
     * @author llc
     * @date 2019-06-26
     */
    Result comWalletAccountExtract(ComWalletAccountDTO dto) throws V5BusinessException;

    /**
     * <b> 批量提现 </b>
     * @author ZXF
     * @create 2023/09/01 0001 15:48
     * @version
     * @注意事项 </b>
     */
    Result batchExtract(ComWallet comWallet);

    /**
     * 企业消费分账接口
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-08-20
     */
    Result comWalletAccountConsumeLedger(ComWalletConsumeLedgerDTO dto);

    /**
     * 企业账户金额冻结/解冻
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-08-27
     */
    Result comWalletAccountLock(ComWalletTransferDTO dto);

    /**
     * 企业消费转账接口
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-08-27
     */
    Result comWalletAccountTransfer(ComWalletTransferDTO dto);

    /**
     * <b> 确认支付：支付申请成功后调这个接口完成最终转账 </b>
     * @author ZXF
     * @create 2023/04/21 0021 10:30
     * @version
     * @注意事项 </b>
     */
    Result checkTransfer(ComCheckTransferDTO comCheckTransferDTO);

    /**
     * <b> 取消支付：支付申请成功后调这个接口取消转账 </b>
     * @author ZXF
     * @create 2023/04/21 0021 10:30
     * @version
     * @注意事项 </b>
     */
    Result cancelTransfer(ComCheckTransferDTO comCheckTransferDTO);

    /**
     * <b> 企业异步转账接口 </b>
     * @author ZXF
     * @create 2023/04/06 0006 10:51
     * @version
     * @注意事项 </b>
     */
    Result syncComWalletAccountTransfer(ComWalletTransferDTO dto);

    /**
     * <b> 平台异步转账接口 </b>
     * @author ZXF
     * @create 2023/02/27 0027 15:41
     * @version
     * @注意事项 平台转账也是用的上面企业转账接口进行转账，当前接口的目的是将平台转账的信息录入任务表通过异步完成转账调用
     */
    Result syncPlatWalletAccountTransfer(ComWalletTransferDTO dto) throws V5BusinessException;
    /**
     * <b> 平台异步转账接口(白天跑) </b>
     * @author ZXF
     * @create 2023/02/27 0027 15:41
     * @version
     * @注意事项 平台转账也是用的上面企业转账接口进行转账，当前接口的目的是将平台转账的信息录入任务表通过异步完成转账调用
     */
    Result platWalletAccountTransfer(ComWalletTransferDTO dto) throws V5BusinessException;

    String getComAccountTradeVoucher(ComWalletTradeDTO dto) throws V5BusinessException;

    /**
     * <b> 电子回单获取任务 </b>
     * @author ZXF
     * @create 2023/04/21 0021 17:06
     * @version
     * @注意事项 </b>
     */
    Result taskTradeVoucher(String tradeDate) throws V5BusinessException;

    String getComAccountPayVoucher(ComWalletTradeDTO dto) throws V5BusinessException;


    /**
     * 企业钱包账户对账数据生成
     *
     * @author llc
     * @date 2019-09-16
     */
    Result createComWalletReconciliation(String testDate);

    /**
     * 获取企业钱包账户对账数据
     *
     * @author llc
     * @date 2019-09-19
     */
    Result getComWalletReconciliation(ComWalletTradeDTO dto);

    /**
     * 导出企业钱包账户对账数据
     *
     * @author llc
     * @date 2019-09-20
     */
    Result exportComWalletReconciliation(ComWalletTradeDTO dto, HttpServletResponse response);

    /**
     * 查询待发放补贴
     *
     * @author llc
     * @date 2020-10-16
     */
    Result getDffSubsidyList(ComWalletTransferDTO dto);


    /**
     * 发送补贴验证码
     *
     * @author llc
     * @date 2020-10-22
     */
    Result sendsubSidyVerificationCode(ComWalletTransferDTO dto);


    /**
     * 获取百保盾补贴详情页面地址
     *
     * @author llc
     * @date 2020-10-14
     */
    Result getBbdSubsidyPageUrl(ComWalletTransferDTO dto);

    /**
     * 发放保安员资格证补贴
     *
     * @author llc
     * @date 2020-10-14
     */
    Result grantBayZgzSubsidy(ComWalletTransferDTO dto);


    /**
     * 发放职业技能培训补贴
     *
     * @author llc
     * @date 2020-10-14
     */
    Result grantZyjnpxSubsidy(ComWalletTransferDTO dto);

    /**
     * 查询已发放补贴
     *
     * @author llc
     * @date 2020-10-16
     */
    Result getYffSubsidyList(ComWalletTransferDTO dto);

    /**
     * 查询已发放补贴统计信息
     *
     * @author llc
     * @date 2020-10-22
     */
    Result getYffSubsidyInfo(ComWalletTransferDTO dto);

}