package com.bcxin.platform.service.insurance;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.obpm.mapper.ObpmUserMapper;
import com.bcxin.platform.common.constant.DictConst;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.IdcardUtils;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.bean.ObjectUtils;
import com.bcxin.platform.common.utils.blb.AjaxResult;
import com.bcxin.platform.common.utils.blb.InsPreservationDetailVo;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.domain.insurance.ComIns;
import com.bcxin.platform.domain.insurance.ComInsBootScheme;
import com.bcxin.platform.domain.insurance.ComInsGuaProject;
import com.bcxin.platform.domain.temporary.ComProject;
import com.bcxin.platform.dto.excel.InsPerExcelBean;
import com.bcxin.platform.dto.excel.NotIncludedInsurancePerExcelBean;
import com.bcxin.platform.dto.excel.UnderWarrantyPerExcelBean;
import com.bcxin.platform.dto.excel.UninsuredPerExcelBean;
import com.bcxin.platform.dto.insurance.*;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.mapper.insurance.*;
import com.bcxin.platform.mapper.temporary.ComProjectMapper;
import com.bcxin.platform.service.bbd.BbdTestService;
import com.bcxin.platform.service.blb.BlbTestService;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.oauth.RedisUtil;
import com.bcxin.platform.service.temporary.ComProjectService;
import com.bcxin.platform.util.BLBSyncDataException;
import com.bcxin.platform.util.DateUtils;
import com.bcxin.platform.util.PageInfoUtils;
import com.bcxin.platform.util.ThreadPool;
import com.bcxin.platform.util.constants.CommonConst;
import com.bcxin.platform.util.constants.DictMessageTypeConst;
import com.bcxin.platform.util.http.MD5Util;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.*;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Author: 陈堂君
 * @Date: 2017/12/28
 * @Description:
 * @Modified By:
 */
@Service("comInsService")
@Transactional("transactionManager")
public class ComInsServiceImpl implements ComInsService {
	@Resource
	private StringRedisTemplate stringRedisTemplate;

	@Resource
	private ComOnlineInsPerMapper comOnlineInsPerMapper;
	@Resource
	private ComOnlineInsSignMapper comOnlineInsSignMapper;

	@Resource
	private ComInsMapper comInsMapper;
	@Resource
	private ComProjectMapper comProjectMapper;

	@Resource
	private ComInsGuaProjectMapper comInsGuaProjectMapper;

	@Resource
	private ComInsPrincipalMapper comInsPrincipalMapper;

	@Resource
	private PerBaseInfoMapper perBaseInfoMapper;

	@Resource
	private ObpmUserMapper obpmUserMapper;

	@Resource
	private ComBaseInfoMapper comBaseInfoMapper;
	@Resource
	private CommonService commonService;
	@Resource
	private IdWorker idWorker;
	@Resource
	private BlbTestService blbTestService;
	@Resource
	private BbdTestService bbdTestService;
	@Resource
	private RedisUtil redisUtil;

	@Override
	public Result getComInsPage(ComInsDTO dto) throws V5BusinessException {
		if (dto.getComId() == null) {
			throw new V5BusinessException(Result.ERROR, "参数comId不能为空");
		}
		//百联保激活用户
		HttpUtil.get(blbTestService.blbActivateUserLinkUrl(dto.getComId(),""));
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		List<Map<String, Object>> list = comInsMapper.getComInsPage(dto);
		return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
	}

	@Override
	public Result getPerInsPage(ComInsDTO dto) throws V5BusinessException {
		if (dto.getCreateBy() == null) {
			throw new V5BusinessException(Result.ERROR, "参数perId不能为空");
		}
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		List<Map<String, Object>> list = comInsMapper.getPerInsPage(dto.getCreateBy());
		return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
	}

	@Override
	public Result getPerInsPageNew(ComInsDTO dto) throws V5BusinessException {
		if (dto.getCreateBy() == null) {
			throw new V5BusinessException(Result.ERROR, "参数perId不能为空");
		}
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		List<Map<String, Object>> list = comInsMapper.getPerInsPageNew(dto.getComId(),dto.getIdCard());
		return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
	}

	@Override
	public Result getComInsByIdcard(ComInsDTO dto) throws V5BusinessException {
		if (dto.getComId() == null) {
			throw new V5BusinessException(Result.ERROR, "参数comId不能为空");
		}
		if (dto.getIdCard() == null) {
			throw new V5BusinessException(Result.ERROR, "参数idCard不能为空");
		}
		return Result.success(Result.SUCCESS_QUERY_MSG, comInsMapper.getComInsByIdcard(dto));
	}

	@Override
	public Result findComInsByIdcard(ComInsDTO dto) throws V5BusinessException {
		if (dto.getComId() == null) {
			throw new V5BusinessException(Result.ERROR, "参数comId不能为空");
		}
		if (dto.getPerId() == null) {
			throw new V5BusinessException(Result.ERROR, "参数perId不能为空");
		}
		String[] perIds = {String.valueOf(dto.getPerId())};
		String idCardNo = perBaseInfoMapper.getIdCardNosByPerIds(perIds);
		if(StringUtils.isEmpty(idCardNo)){
			throw new V5BusinessException(Result.ERROR, "idCardNo不存在");
		}
		dto.setIdCard(idCardNo);
		return Result.success(Result.SUCCESS_QUERY_MSG, comInsMapper.getComInsByIdcardAndXS(dto));
	}

	@Override
	public Result getComInsDetail(ComInsDTO dto) throws V5BusinessException {
		if (dto.getComInsId() == null) {
			throw new V5BusinessException(Result.ERROR, "参数comInsId不能为空");
		}
		Map<String, Object> rec = comInsMapper.selectById(dto.getComInsId());
		List<ComInsGuaProject> list = comInsGuaProjectMapper.selectItemsById(dto.getComInsId());
		Map<String, Object> m = Maps.newHashMap();
		m.put("comIns", rec);
		m.put("comInsGuaProjectList", list);
		return Result.success(Result.SUCCESS_QUERY_MSG, m);
	}

	@Override
	public Result saveComInsUnderline(ComInsDTO dto) throws V5BusinessException {
		if (dto.getProductName().length() > 20) {
			throw new V5BusinessException(Result.ERROR, "保险产品名称不能超过20个字符");
		}
		if(!checkPolicyNo(dto)){
			return Result.fail("保单号已存在！");
		}
		dto.setBuyMode(DictConst.BUYMODE_XXGM);// 2线下购买，1线上购买
		// 保险基本信息，如果有ID就修改，如果没ID就新增
		IdWorker id = idWorker;
		Long comInsId = id.nextId();
		dto.setInsAddEventId(1L); // TODO 不用事件ID，增加一个审核标志位来处理
		if ("null".equals(dto.getPolicyUrl())) {// 可能数据错乱问题，出现过该情况，所以做了设空处理
			dto.setPolicyUrl(CommonConst.BLANK_CHAR);
		}
		int sg = 0;//用来标识业务是新增还是修改
		if (dto.getComInsId() == null) { // 插入
			dto.setComInsId(comInsId);
			// 线下的保单，购买时间默认当前，用于查询时排序
			dto.setBuyTime(new Date());
			comInsMapper.insert(dto);
		} else { // 修改
			sg = 1;
			comInsMapper.update(dto);
		}
		//线下保单录入，如果标识为百联保购买就调百联保接口给对应订单打上来源标识
		if("1".equals(dto.getIsBlbBuy())){
			String platformSign = commonService.getSystemConfig("PLATFORM_SIGN");
			String token = MD5Util.buildMD5(dto.getPolicyNo()+platformSign);
			blbTestService.blbSetSign(token,dto.getPolicyNo(),platformSign);
		}
		// 保障项目，全部删除，再全部添加
		comInsGuaProjectMapper.delete(dto.getComInsId());// 先全部删除
		List<ComInsGuaProject> list = JSON.parseArray(dto.getComInsGuaProjectList(), ComInsGuaProject.class);
		if (dto.getComInsGuaProjectList() != null) { // 全部添加
			int i = 1;
			for (ComInsGuaProject rec : list) {
				rec.setSeq(i++);
				rec.setGuaranteeProjectId(id.nextId());
				rec.setComInsId(dto.getComInsId());
				rec.setComId(dto.getComId());
				comInsGuaProjectMapper.insert(rec);
			}
		}
		//发消息给osp管理人员
//		String comName = comBaseInfoMapper.getComNameByID(dto.getComId());
//		if(StringUtils.isNotEmpty(comName)){
//			String title = MsgConst.TYPE_010301_POLICY_SAVE_TITLE;
//			String content = MsgConst.TYPE_010301_POLICY_SAVE_CONTENT;
//			if(sg == 1){
//				title = MsgConst.TYPE_010301_POLICY_UPDATE_TITLE;
//				content = MsgConst.TYPE_010301_POLICY_UPDATE_CONTENT;
//			}
//			title = title.replace("{comName}", comName);
//			content = content.replace("{productName}",dto.getProductName())
//					.replace("{policyNo}", dto.getPolicyNo())
//					.replace("{bzTime}", DateUtils.formatDate(dto.getEffectStartDate())+"~"+DateUtils.formatDate(dto.getEffectEndDate()));
//			//给客服发邮件
//			String emails = commonService.getSystemConfig(CommonConst.KEFU_EMAIL);
//			if(StringUtils.isNotEmpty(emails)){
//				commonService.sendEmailMessage(title,content,DictMessageTypeConst.MESSAGETYPE_010301,emails);
//			}
//		}
		return Result.success(Result.SUCCESS_MSG, String.valueOf(dto.getComInsId()));
	}

	/**
	 * <b> 校验保单号是否重复 </b>
	 * @author ZXF
	 * @create 2020/04/23 0023 16:50
	 * @version
	 * @注意事项 </b>
	 */
	private boolean checkPolicyNo(ComInsDTO dto){
		//查询保单号存在几条
		Integer count = comInsMapper.isPolicyNo(dto);
		if(dto.getComInsId() == null){
			return count!=0?false:true;
		}else{
			//查询这个保单记录和保单号是否一致
			Integer c_count = comInsMapper.isPolicyNo(dto);
			return c_count!=0?true:count!=0?false:true;
		}
	}

	@Override
	public Result deleteComInsUnderline(ComInsDTO dto) throws V5BusinessException {
		// 删除前校验是否有保障项目，如果没有才可以删除
		// if (comInsGuaProjectMapper.selectItemsById(dto.getComInsId()).size()
		// > 0) {
		// throw new V5BusinessException(Result.ERROR, "还有保障项目关联，不可以删除");
		// }
		//线下订单对应已关联人员数据清空
		comOnlineInsPerMapper.delXXPerInfo(dto.getComInsId());
		//订单标记删除
		if (comInsMapper.delete(dto.getComInsId()) == 0) {
			throw new V5BusinessException(Result.ERROR, CommonConst.OP_FAILURE);
		}
		return Result.success(CommonConst.OP_SUCCESS);
	}

	/**
	 * <b> 更新授权申请书地址 </b>
	 * @author ZXF
	 * @create 2020/06/05 0005 14:39
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result saveAuthFile(ComInsDTO dto) throws V5BusinessException {
		if (dto.getComInsId() == null) {
			throw new V5BusinessException(Result.ERROR, "参数comInsId不能为空");
		}
		if (StringUtils.isEmpty(dto.getAuthFileUrl())) {
			throw new V5BusinessException(Result.ERROR, "参数authFileUrl不能为空");
		}
		ComIns comIns = new ComIns();
		comIns.setAuthFileUrl(dto.getAuthFileUrl());
		comIns.setComInsId(dto.getComInsId());
		comIns.setUpdateTime(new Date());
		comIns.setUpdateBy(dto.getPerId());
		//更新授权申请书地址
		if (comInsMapper.update(comIns) == 0) {
			throw new V5BusinessException(Result.ERROR, Result.ERROR_MSG);
		}
		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * <b> 初始化管理员创建为保险负责人 </b>
	 * @author ZXF
	 * @create 2019/05/24 0024 16:10
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result initSavePrincipal(Long comId, Long perId, Long createBy){
		if(perId == null){
			return Result.fail("未选择人员！");
		}
		List<Map> cnoList = perBaseInfoMapper.getByComIdAndPerId(comId,createBy,perId);
		if (cnoList.size() == 0) {
			return Result.fail("未匹配到对应人员信息！");
		}
		int resval = comInsPrincipalMapper.insertBatchPrincipal(cnoList);
		if(resval == 0){
			return Result.fail("保险负责人信息更新异常！");
		}
		return Result.success("操作成功！");
	}

	/**
	 * 百联保对接，在线企业保险链接生成
	 *
	 * @param dto
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/3 13:53
	 */
	@Override
	public Result getOnlineInsBlbLink(ComInsDTO dto) throws V5BusinessException {
		if (dto.getComId() == null) {
			throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
		}
		//百联保激活用户
		HttpUtil.get(blbTestService.blbActivateUserLinkUrl(dto.getComId(),""));
		if(StringUtils.isEmpty(dto.getBusinessType())){
			String url = blbTestService.blbLinkUrl(dto.getComId(),"");
			return Result.success(Result.SUCCESS_QUERY_MSG, url);
		}
		IdWorker id = idWorker;
		String cacheId = BSEnum.get(dto.getBusinessType())+"-cacheIdForInsPerIds" + id.nextId();

		// 获取企业信息
		List<BLBComInfoDTO> list = new ArrayList();
		List<BLBComInfoDTO> company = comInsMapper.getCompanyByComID(dto.getComId());
		BLBComInfoDTO com = company.get(0);
		// 如果投保人信息不存在，就默认创建一条空的投保人信息（相当于初始化）
		if (com == null) {
			com = new BLBComInfoDTO();
			com.setKind(CommonConst.APP_KIND);
		}
		list.add(com);

		// 设置到缓存中，8分钟后过期
		stringRedisTemplate.opsForValue().set(redisUtil.REDIS_PREFIX_KEY + ":INS:" + cacheId, JSON.toJSONString(list), 8 * 60,
				TimeUnit.SECONDS);

		String url = blbTestService.getCompnayAndPersonPutCacheUrl(
				"1"
				,cacheId);
//		String url = blbTestService.blbLinkUrl(dto.getComId(),"");
		return Result.success(Result.SUCCESS_QUERY_MSG, url);
	}

	/**
	 * <b> 在线企业保险用户激活链接生成 </b>
	 * @author ZXF
	 * @create 2021/02/23 0023 13:24
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result activateOnlineInsBlbUserLink(ComInsDTO dto) throws V5BusinessException {
		if (dto.getComId() == null) {
			throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
		}
		String url = blbTestService.blbActivateUserLinkUrl(dto.getComId(),"");
		return Result.success(Result.SUCCESS_QUERY_MSG, url);
	}

	/**
	 * 百联保对接，企业保险详情链接生成
	 *
	 * @param dto
	 * @return
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/4 11:29
	 */
	@Override
	public Result getOnlineInsBlbDetailLink(ComInsDTO dto) throws V5BusinessException {
		if (Strings.isNullOrEmpty(dto.getOrderId())) {
			throw new V5BusinessException(Result.ERROR, "订单ID不能为空");
		}
		String url = blbTestService.getBlbDetailLinkUrl(dto.getOrderId());
		return Result.success(Result.SUCCESS_QUERY_MSG, url);
	}

	/**
	 * 保全页面链接生成，不带人员信息
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/3 9:56
	 */
	@Override
	public Result getOnlineInsBlbPreservationPageLink(ComInsBootScheme dto) {
		if (dto.getComId() == null) {
			throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
		}
		//百联保激活用户
		HttpUtil.get(blbTestService.blbActivateUserLinkUrl(dto.getComId(),""));
		String url = blbTestService.getBlbPreservationPageLinkUrl();
		return Result.success(Result.SUCCESS_QUERY_MSG, url);
	}

	/**
	 * <b> 订单列表页面链接生成 </b>
	 * @author ZXF
	 * @create 2019/05/22 0022 10:21
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result getOnlineInsBlbOrderPageLink(ComInsDTO dto) {
		String blbUrl = blbTestService.getBlbOrderPageLinkUrl(dto.getBusinessType());
		return Result.success(Result.SUCCESS_QUERY_MSG, blbUrl);
	}

	/**
	 * <b> 理赔列表页面链接生成 </b>
	 * @author ZXF
	 * @create 2019/12/13 0013 13:57
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result getOnlineInsBlbReportPageLink(ComInsDTO dto) {
		String blbUrl = blbTestService.getBlbReportPageLinkUrl();
		return Result.success(Result.SUCCESS_QUERY_MSG, blbUrl);
	}

	/**
	 * 获得百联保保险产品列表
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/3 10:00
	 */
	@Override
	public Result getBlbProList(ComInsBootScheme dto) {

		String result = blbTestService.getBlbProList();
		List<Map> resList = JSON.parseObject(result, List.class);
		return Result.success(Result.SUCCESS_QUERY_MSG, resList);
	}

	/**
	 * 根据企业ID获取企业的信息，为兼容对接
	 *
	 * @param dto
	 * @return
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/4 13:15
	 */
	@Override
	public AjaxResult findCompnayAndPersonByUserid(ComInsDTO dto) throws V5BusinessException {
		if (dto.getComId() == null) {
			throw new V5BusinessException(Result.ERROR, "ID不能为空");
		}
		// 获取企业信息
		List<BLBComInfoDTO> company = comInsMapper.getCompanyByComID(dto.getComId());
		// 如果投保人信息不存在，就默认创建一条空的投保人信息（相当于初始化）
		if (company.size() == 0) {
			BLBComInfoDTO bciDto = new BLBComInfoDTO();
			bciDto.setKind(CommonConst.APP_KIND);
			company.add(bciDto);
		}
		// 获取企业的人员信息
		String person_num = commonService.getSystemConfig("BLB_INS_NUM");
		List<BLBComInfoDTO> persons = comInsMapper.getPersonByComID(dto.getComId(), Integer.parseInt(person_num));
		company.addAll(persons);
		return AjaxResult.success(Result.SUCCESS_QUERY_MSG, company);
	}

	/**
	 * 根据缓存ID获得对应的保全人员信息
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/3/29 16:54
	 */
	@Override
	public AjaxResult findPerIdsByCacheId(ComInsDTO dto) {
		String key = redisUtil.REDIS_PREFIX_KEY + ":INS:" + dto.getCacheId();
		String result = stringRedisTemplate.opsForValue().get(key);
		stringRedisTemplate.delete(key); // 取完就要删除
		if (result == null) {
			return AjaxResult.fail("CODE-9900", "key不存在或已删除", null);
		}
		List<InsPreservationDetailVo> list = JSON.parseArray(result, InsPreservationDetailVo.class);
		return AjaxResult.success(Result.SUCCESS_QUERY_MSG, list);
	}

	/**
	 * <b> 根据缓存ID获得已选择的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 10:35
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result findCompnayAndPersonByCacheId(ComInsDTO dto) {
		String key = redisUtil.REDIS_PREFIX_KEY + ":INS:" + dto.getCacheId();
		String result = stringRedisTemplate.opsForValue().get(key);
		stringRedisTemplate.delete(key); // 取完就要删除
		if (result == null) {
			return Result.fail("key不存在或已删除");
		}
		List<BLBComInfoDTO> list = JSON.parseArray(result, BLBComInfoDTO.class);
		return Result.success(Result.SUCCESS_QUERY_MSG, list);
	}

	/**
	 * 企业保全列表的保险详情链接生成
	 *
	 * @param dto
	 * @return
	 */
	@Override
	public Result getOnlineInsBlbPreservationLink(ComInsDTO dto) throws V5BusinessException {
		if (Strings.isNullOrEmpty(dto.getOrderId())) {
			throw new V5BusinessException(Result.ERROR, "订单ID不能为空");
		}
		if (Strings.isNullOrEmpty(dto.getReviseType())) {
			throw new V5BusinessException(Result.ERROR, "保全类型增减不能为空");
		}
		if (Strings.isNullOrEmpty(dto.getPerIds())) {
			throw new V5BusinessException(Result.ERROR, "保全人员ID列表不能为空");
		}
		IdWorker id = idWorker;
		String cacheId = BSEnum.get(dto.getBusinessType())+"-cacheIdForInsPerIds" + id.nextId();
		String[] strArr = dto.getPerIds().split(",");
		List<Map> mapList = Lists.newArrayList();
		Map map = null;
		for (String str : strArr) {
			map = Maps.newHashMap();
			map.put("perId", str);
			mapList.add(map);
		}
		// 配置要参加保全的人员列表
		List<InsPreservationDetailVo> vo = comOnlineInsPerMapper.getBlbVoByPerIds(dto.getOrderId(), mapList);
		// 设置到缓存中，8分钟后过期
		stringRedisTemplate.opsForValue().set(redisUtil.REDIS_PREFIX_KEY + ":INS:" + cacheId, JSON.toJSONString(vo), 8 * 60,
				TimeUnit.SECONDS);

		String blbUrl = blbTestService.getBlbPreservationLinkUrl(dto.getReviseType(),dto.getOrderId(),cacheId);
		return Result.success(Result.SUCCESS_QUERY_MSG, blbUrl);
	}

	/**
	 * <b> 选择订单和人员信息推送到百联保做增员保全 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 14:43
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result saveInsBlbAddPreservationService(ComInsDTO dto) throws V5BusinessException {
		if (Strings.isNullOrEmpty(dto.getOrderId())) {
			throw new V5BusinessException(Result.ERROR, "订单ID不能为空");
		}
		if (Strings.isNullOrEmpty(dto.getPerIds())) {
			throw new V5BusinessException(Result.ERROR, "保全人员ID列表不能为空");
		}
		String[] strArr = dto.getPerIds().split(",");
		List<Map> mapList = Lists.newArrayList();
		Map map = null;
		for (String str : strArr) {
			map = Maps.newHashMap();
			map.put("perId", str);
			mapList.add(map);
		}
		// 配置要参加保全的人员列表
		List<InsPreservationDetailVo> vo = comOnlineInsPerMapper.getBlbVoByPerIdsWithNotOrder(dto.getOrderId(), mapList);
		if (vo.size()==0) {
			throw new V5BusinessException(Result.ERROR, "未匹配到人员信息");
		}
		return blbTestService.blbAddPreservationService(
				String.valueOf(dto.getComId())
				,dto.getOrderId()
				,JSONArray.toJSONString(vo)
				,DateUtils.formatDate(dto.getStartTime(), "yyyy-MM-dd"));
	}

	/**
	 * <b> 选择订单和人员信息推送到百联保做减员保全 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 14:43
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result saveInsBlbMinusPreservationService(ComInsDTO dto) throws V5BusinessException {
		if (Strings.isNullOrEmpty(dto.getOrderId())) {
			throw new V5BusinessException(Result.ERROR, "订单ID不能为空");
		}
		if (Strings.isNullOrEmpty(dto.getPerIds())) {
			throw new V5BusinessException(Result.ERROR, "保全人员ID列表不能为空");
		}
		String[] strArr = dto.getPerIds().split(",");
		List<Map> mapList = Lists.newArrayList();
		Map map = null;
		for (String str : strArr) {
			map = Maps.newHashMap();
			map.put("perId", str);
			mapList.add(map);
		}
		// 配置要参加保全的人员列表
		List<InsPreservationDetailVo> vo = comOnlineInsPerMapper.getBlbVoByPerIds(dto.getOrderId(), mapList);
		if (vo.size()==0) {
			throw new V5BusinessException(Result.ERROR, "未匹配到人员信息");
		}
		return blbTestService.blbMinusPreservationService(
				String.valueOf(dto.getComId())
				,dto.getOrderId()
				,JSONArray.toJSONString(vo)
				,DateUtils.getTomorrow());
	}

	/**
	 * <b> 选择在保未录入列表人员做减员保全 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 14:43
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result saveInsBlbMinusPreservationByNotIncluded(ComInsDTO dto) throws V5BusinessException {
		if (Strings.isNullOrEmpty(dto.getOrderId())) {
			throw new V5BusinessException(Result.ERROR, "订单ID不能为空");
		}
		if (Strings.isNullOrEmpty(dto.getInsPerDetailIds())) {
			throw new V5BusinessException(Result.ERROR, "在保ID列表不能为空");
		}
		String[] strArr = dto.getInsPerDetailIds().split(",");
		List<Map> mapList = Lists.newArrayList();
		Map map = null;
		for (String str : strArr) {
			map = Maps.newHashMap();
			map.put("insPerDetailId", str);
			mapList.add(map);
		}
		// 配置要参加保全的在保未录入人员列表
		String idCards = comOnlineInsPerMapper.getBlbVoByInsPerDetailIds(dto.getOrderId(), mapList);
		if (StringUtils.isEmpty(idCards)) {
			throw new V5BusinessException(Result.ERROR, "未匹配到在保人员信息");
		}

		return blbTestService.blbMinusPreservationByNotIncluded(
				String.valueOf(dto.getComId())
				,dto.getOrderId()
				,idCards
				,DateUtils.getTomorrow());
	}

	/**
	 * <b> 接收页面的用户信息添加到缓存，返回生成的百联保访问地址 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 10:43
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result findCompnayAndPersonPutCache(ComInsDTO dto) throws V5BusinessException {
		if (dto.getComId() == null) {
			throw new V5BusinessException(Result.ERROR, "comId不能为空");
		}
		if (Strings.isNullOrEmpty(dto.getPerIds())) {
			throw new V5BusinessException(Result.ERROR, "人员ID列表不能为空");
		}
		IdWorker id = idWorker;
		String cacheId = BSEnum.get(dto.getBusinessType())+"-cacheIdForInsPerIds" + id.nextId();
		String[] strArr = dto.getPerIds().split(",");

		// 获取企业信息
		List<BLBComInfoDTO> list = new ArrayList();
		List<BLBComInfoDTO> company = comInsMapper.getCompanyByComID(dto.getComId());
		BLBComInfoDTO com = company.get(0);
		ComProject project = null;
		if("1".equals(dto.getBusinessType())){
			if (Strings.isNullOrEmpty(dto.getTlkProjectId())) {
				throw new V5BusinessException(Result.ERROR, "活动项目不能为空");
			}
			project = comProjectMapper.getItemsBytlkProjectId(dto.getTlkProjectId());
		}
		// 如果投保人信息不存在，就默认创建一条空的投保人信息（相当于初始化）
		if (com == null) {
			com = new BLBComInfoDTO();
			com.setKind(CommonConst.APP_KIND);
		}
		if(project!=null){
			com.setProject_name(project.getProjectName());
			com.setProject_address(project.getAddress());
			com.setProject_start_time(DateUtils.formatTime(project.getStartTime()));
			com.setProject_end_time(DateUtils.formatTime(project.getEndTime()));
		}
		list.add(com);
		List<BLBComInfoDTO> persons = comInsMapper.getPersonByperIds(strArr);
		list.addAll(persons);

		// 设置到缓存中，8分钟后过期
		stringRedisTemplate.opsForValue().set(redisUtil.REDIS_PREFIX_KEY + ":INS:" + cacheId, JSON.toJSONString(list), 8 * 60,
				TimeUnit.SECONDS);

		String blbUrl = blbTestService.getCompnayAndPersonPutCacheUrl(
				dto.getReviseType()
				,cacheId);

		return Result.success(Result.SUCCESS_QUERY_MSG, blbUrl);
	}

	/**
	 * 订单信息回传的接口
	 *
	 * @param dto
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/8 15:55
	 */
	@Override
	public AjaxResult saveOrderInfo(BLBAPIDTO dto) throws BLBSyncDataException {
		IdWorker id = idWorker;
		dto.setBuyMode(DictConst.BUYMODE_XSGM); // 1 线上购买， 2线下购买
		dto.setBlbOrderId(dto.getOrderId());
		dto.setInsAddEventId(1L);// TODO 保险事件ID
		dto.setBlbProductCode(dto.getProductCode());

		// 根据订单号判断，如果订单号不存在，就新增，如果订单已经存在就修改
		List<Map> list = comInsMapper.selectByBlbOrderId(dto.getBlbOrderId());
		Long cid;
		if(StringUtils.isNotEmpty(dto.getProjectName())){
			ComProject comProject = comProjectMapper.getItemsByProjectName(dto.getProjectName());
			if(comProject != null){
				dto.setTlkProjectId(comProject.getTlkProjectId());
			}
		}
		if (list.size() == 0) { // 新增
			cid = id.nextId();
			dto.setComInsId(cid);
			comInsMapper.insert(dto);
		} else { // 修改
			Map<String, String> map = list.get(0);
			cid = Long.parseLong(map.get("comInsId"));
			dto.setComInsId(cid);
			comInsMapper.update(dto);
		}

		// 用户列表刷新，新增和修改用户
		List<Map> userList = JSON.parseArray(dto.getUserList(), Map.class);
		List<Map> userListAll = Lists.newArrayList();
//		List<Long> perIds = Lists.newArrayList();
		userList.forEach(val -> {
			Map rec = Maps.newHashMap();
//			Long perId = comInsMapper.getPerIdByComIDAndIdCardNo(dto.getComId(), String.valueOf(val.get("idCardNo")));
			rec.put("comInsId", cid);
			rec.put("idCardNo", String.valueOf(val.get("idCardNo")));
			rec.put("name", String.valueOf(val.get("name")));
			rec.put("insPerDetailId", id.nextId());
			rec.put("createTime", new Date());
			rec.put("comId", dto.getComId());
//			rec.put("perId", perId);
			userListAll.add(rec);
//			if(perId != null){
//				perIds.add(perId);
//			}
			// rec.setCreateBy();
			// rec.setPerId("获取人员ID");//暂时不记录人员ID，有可能先买保险再录入
			// 如果这个用户存在，就忽略
		});
		if (userListAll.size() == 0) {
			throw new BLBSyncDataException("CODE-4000", "接受到的数据列表为空，无任何数据更新", null);
		}
		int resval = comOnlineInsPerMapper.insertBatchPerInfo(userListAll);
		if (resval != userListAll.size()) {
			throw new BLBSyncDataException("CODE-1000", "订单初始化人员插入失败，插入条数和应插入数不符合" + resval + "/" + userList.size(),
					null);
		}
		if(StringUtils.isEmpty(dto.getTlkProjectId())){
			List<String> tlkRelationIds = comOnlineInsPerMapper.findTlkRelationIds(String.valueOf(dto.getComId()), userListAll);
			if(tlkRelationIds.size()>0) {
				obpmUserMapper.updateInsureByIds("1", tlkRelationIds);
			}
		}else{
			//保存保单信息
			if(StringUtils.isNotEmpty(dto.getPolicyUrl())) {
				String piUrl = obpmUserMapper.getProjectInsureUrl(dto.getTlkProjectId());
				JSONArray arr = new JSONArray();
				JSONObject obj = new JSONObject();
				obj.put("name", dto.getPolicyNo() + ".pdf");
				obj.put("path", dto.getPolicyUrl());
				if (StringUtils.isNotEmpty(piUrl)) {
	            	if(!piUrl.contains(dto.getPolicyUrl())){
						arr = JSONArray.parseArray(piUrl);
						arr.add(obj);
						piUrl = arr.toJSONString();
					}
				} else {
					arr.add(obj);
					piUrl = arr.toJSONString();
				}
				obpmUserMapper.updateProjectInsureUrl(dto.getTlkProjectId(), piUrl);
			}
			obpmUserMapper.updateInsureByIdcardNos("1",dto.getPolicyNo(), dto.getTlkProjectId(), userListAll);
		}
		/*ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectComBaseInfoById(dto.getComId());
		//如果是v5映射的企业走数据分发平台的业务
		List<Map> li = Lists.newArrayList();
		if(perIds.size()>0){
			List<Map> inL = perBaseInfoMapper.packageTLInsureData(perIds,String.valueOf(dto.getComId()),String.valueOf(comBaseInfoDB.getTlkComId()),DictConst.INSUREDSTATES_ZB,"__wGomeHJBz6CpLFCCl4y","__qFCcCnozYNwzoG3O6Ms");
			li.addAll(inL);
		}
		bbdTestService.tlSyncPerPolicyStatus(li);*/

		//重新统计在保人员数量
		changeInsPerCount(cid);
		return AjaxResult.success(Result.SUCCESS_MSG, null);

	}

	/**
	 * <b> 订单在保人员回传的接口 </b>
	 * @author ZXF
	 * @create 2022/08/24 0024 15:49
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public AjaxResult saveOfflineOrderPerson(BLBAPIDTO dto) throws BLBSyncDataException {
		IdWorker id = idWorker;
		List<Map> list = comInsMapper.selectByBlbPolicyNo(dto.getPolicyNo());
		if (list.size() == 0) {
			throw new BLBSyncDataException("CODE-4001", "保单不存在", null);
		}
		Map<String, String> map = list.get(0);
		dto.setTlkProjectId(String.valueOf(map.get("tlkProjectId")));
		long cid = Long.parseLong(map.get("comInsId") + "");
		// 用户列表刷新，新增和修改用户
		List<Map> userList = JSON.parseArray(dto.getUserList(), Map.class);
		List<Map> userListAll = Lists.newArrayList();
		userList.forEach(val -> {
			Map rec = Maps.newHashMap();
			rec.put("comInsId", cid);
			rec.put("idCardNo", String.valueOf(val.get("idCardNo")));
			rec.put("name", String.valueOf(val.get("name")));
			rec.put("insPerDetailId", id.nextId());
			rec.put("createTime", new Date());
			rec.put("comId", String.valueOf(map.get("comId")));
			userListAll.add(rec);
		});
		if (userListAll.size() == 0) {
			throw new BLBSyncDataException("CODE-4000", "接受到的数据列表为空，无任何数据更新", null);
		}
		//先清理当前保单已关联的人员数据
		comOnlineInsPerMapper.delXXPerInfo(cid);
		int resval = comOnlineInsPerMapper.insertBatchPerInfo(userListAll);
		if (resval != userListAll.size()) {
			throw new BLBSyncDataException("CODE-1000", "订单初始化人员插入失败，插入条数和应插入数不符合" + resval + "/" + userList.size(),
					null);
		}
		if(StringUtils.isEmpty(dto.getTlkProjectId())){
			List<String> tlkRelationIds = comOnlineInsPerMapper.findTlkRelationIds(String.valueOf(dto.getComId()), userListAll);
			if(tlkRelationIds.size()>0) {
				obpmUserMapper.updateInsureByIds("1", tlkRelationIds);
			}
		}else{
			//保存保单信息
			if(StringUtils.isNotEmpty(dto.getPolicyUrl())) {
				String piUrl = obpmUserMapper.getProjectInsureUrl(dto.getTlkProjectId());
				JSONArray arr = new JSONArray();
				JSONObject obj = new JSONObject();
				obj.put("name", dto.getPolicyNo() + ".pdf");
				obj.put("path", dto.getPolicyUrl());
				if (StringUtils.isNotEmpty(piUrl)) {
					if(!piUrl.contains(dto.getPolicyUrl())){
						arr = JSONArray.parseArray(piUrl);
						arr.add(obj);
						piUrl = arr.toJSONString();
					}
				} else {
					arr.add(obj);
					piUrl = arr.toJSONString();
				}
				obpmUserMapper.updateProjectInsureUrl(dto.getTlkProjectId(), piUrl);
			}
			obpmUserMapper.updateInsureByIdcardNos("1", dto.getPolicyNo(), dto.getTlkProjectId(), userListAll);
		}
		//重新统计在保人员数量
		changeInsPerCount(cid);
		return AjaxResult.success(Result.SUCCESS_MSG, null);
	}

	/**
	 * <b> 保存电子保单地址 </b>
	 * @author ZXF
	 * @create 2019/05/10 0010 14:37
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public AjaxResult savePolicyUrl(BLBAPIDTO dto) throws BLBSyncDataException {
		if (StringUtils.isEmpty(dto.getOrderId())) {
			throw new BLBSyncDataException("CODE-4001", "订单ID不能为空", null);
		}
		if (StringUtils.isEmpty(dto.getPolicyUrl())) {
			throw new BLBSyncDataException("CODE-4002", "电子保单地址不能为空", null);
		}
		int count = comInsMapper.updatePolicyUrlByOrderId(dto.getOrderId(),dto.getPolicyUrl());
		if(count == 0){
			throw new BLBSyncDataException("CODE-4003", "电子保单地址更新失败", null);
		}
		return AjaxResult.success(Result.SUCCESS_MSG, null);

	}

	/**
	 * <b> 根据百联保订单id删除saas保单信息 </b>
	 * @author ZXF
	 * @create 2019/05/10 0010 14:37
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public AjaxResult deletePolicy(BLBAPIDTO dto) throws BLBSyncDataException {
		if (StringUtils.isEmpty(dto.getOrderId())) {
			throw new BLBSyncDataException("CODE-4001", "订单ID不能为空", null);
		}
		comInsMapper.deleteComInsByBlbOrderId(dto.getOrderId());
		comOnlineInsPerMapper.delPerByBlbOrderId(dto.getOrderId());

		return AjaxResult.success(Result.SUCCESS_MSG, null);
	}

	/**
	 * 保全信息回传接口
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/3/28 10:25
	 * @param dto
	 * @return
	 */
	@Override
	public AjaxResult savePerservationInfo(BLBAPIDTO dto) throws BLBSyncDataException {
		// 根据订单编号，获得对应的SAAS的保险ID
		List<Map> list = comInsMapper.selectByBlbOrderId(dto.getOrder_no());
		if (list.size() == 0) {
			return AjaxResult.fail("CODE-9001", "同步失败，保险订单(ID:"+dto.getOrder_no()+")不存在", null);
		}
		dto.setTlkProjectId(String.valueOf(list.get(0).get("tlkProjectId")));
		IdWorker id = idWorker;
		List<Map> addList = Lists.newArrayList();
		// {count:2,0:350702198802151319#张三#1,1:350702198802151319#李四#1}
		// 1标识增加，2标识减员
		JSONObject jsonObject = JSON.parseObject(dto.getCardList());
		Integer count = Integer.valueOf(String.valueOf(jsonObject.get("count")));

		List<Map> cnoList = Lists.newArrayList();
		Map map = null;
//		List<Long> z_perIds = Lists.newArrayList();
//		List<Long> j_perIds = Lists.newArrayList();
		for (int i = 0; i <= count; i++) {
			// row:452226198409034254#张三#2
			String row = String.valueOf(jsonObject.get(i + ""));
//			Long perId = comInsMapper.getPerIdByComIDAndIdCardNo(Long.parseLong(dto.getUser_id()), row.split("#")[0]);
			if (DictConst.PERSERVATION_ZY.equals(row.split("#")[2])) {
				// 增员
				Map rec = Maps.newHashMap();
				rec.put("comInsId", String.valueOf(list.get(0).get("comInsId")));
				rec.put("idCardNo", row.split("#")[0]);
				rec.put("name", row.split("#")[1]);
				rec.put("insPerDetailId", id.nextId());
				rec.put("createTime", new Date());
				rec.put("comId", dto.getUser_id());
//				rec.put("perId", perId);
//				if(perId != null){
//					z_perIds.add(perId);
//				}
				addList.add(rec);
			} else if (DictConst.PERSERVATION_JY.equals(row.split("#")[2])) {
				// 减员
				map = Maps.newHashMap();
				map.put("idCardNo", row.split("#")[0]);
//				if(perId != null){
//					j_perIds.add(perId);
//				}
				cnoList.add(map);
			} else {
				throw new BLBSyncDataException("CODE-9002", "出现违规数据，未标识增员和减员，放弃本次同步", null);
			}
		}
		if (addList.size() != 0) {
			int resval = comOnlineInsPerMapper.insertBatchPerInfo(addList);
			if (resval != addList.size()) {
				throw new BLBSyncDataException("CODE-9003", "订单初始化人员插入失败，插入条数和应插入数不符合" + resval + "/" + addList.size(),
						null);
			}
			if(StringUtils.isEmpty(dto.getTlkProjectId())){
				List<String> tlkRelationIds = comOnlineInsPerMapper.findTlkRelationIds(dto.getUser_id(), addList);
				if(tlkRelationIds.size()>0){
					obpmUserMapper.updateInsureByIds("1",tlkRelationIds);
				}
			}else{
				obpmUserMapper.updateInsureByIdcardNos("1", String.valueOf(list.get(0).get("policyNo")), dto.getTlkProjectId(), addList);
			}
		}
		if (cnoList.size() != 0) {
			comOnlineInsPerMapper.delPerInfo(String.valueOf(list.get(0).get("comInsId")), cnoList);
			if(StringUtils.isEmpty(dto.getTlkProjectId())){
				List<String> tlkRelationIds = comOnlineInsPerMapper.findTlkRelationIds(dto.getUser_id(), cnoList);
				if(tlkRelationIds.size()>0) {
					obpmUserMapper.updateInsureByIds("0", tlkRelationIds);
				}
			}else{
				obpmUserMapper.updateInsureByIdcardNos("0","", dto.getTlkProjectId(), cnoList);
			}
		}
		/*ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectComBaseInfoById(Long.parseLong(dto.getUser_id()));
		//如果是v5映射的企业走数据分发平台的业务
		List<Map> li = Lists.newArrayList();
		if(z_perIds.size()>0){
			List<Map> inL = perBaseInfoMapper.packageTLInsureData(z_perIds,String.valueOf(comBaseInfoDB.getComId()),String.valueOf(comBaseInfoDB.getTlkComId()),DictConst.INSUREDSTATES_ZB,"__wGomeHJBz6CpLFCCl4y","__qFCcCnozYNwzoG3O6Ms");
			li.addAll(inL);
		}
		if(j_perIds.size()>0){
			List<Map> inL1 = perBaseInfoMapper.packageTLInsureData(j_perIds,String.valueOf(comBaseInfoDB.getComId()),String.valueOf(comBaseInfoDB.getTlkComId()),DictConst.INSUREDSTATES_BZB,"__wGomeHJBz6CpLFCCl4y","__qFCcCnozYNwzoG3O6Ms");
			li.addAll(inL1);
		}
		bbdTestService.tlSyncPerPolicyStatus(li);*/

		// 重新计算在线保险表的订单人数
		BLBAPIDTO rec = new BLBAPIDTO();
		rec.setComInsId(Long.valueOf(String.valueOf(list.get(0).get("comInsId"))));
		Map cnt = comInsMapper.countByComInsId(rec.getComInsId());
		// 获得再保人数
		rec.setPerNum(Integer.valueOf(String.valueOf(cnt.get("cnt"))));
		int resval = comInsMapper.update(rec);
		if (resval == 0) {
			throw new BLBSyncDataException("CODE-9004", "保险记录表com_online_ins_per修改失败", null);
		}

		return AjaxResult.success(Result.SUCCESS_MSG, null);
	}

	/**
	 * <b> 被标记为线下百联保购买的保单保全信息回传接口 </b>
	 * @author ZXF
	 * @create 2022/08/25 0025 10:25
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public AjaxResult saveOfflinePerservationInfo(BLBAPIDTO dto) throws BLBSyncDataException {
		// 根据订单编号，获得对应的SAAS的保险ID
		List<Map> list = comInsMapper.selectByBlbPolicyNo(dto.getPolicyNo());
		if (list.size() == 0) {
			return AjaxResult.fail("CODE-9001", "同步失败，保险订单(PolicyNo:"+dto.getPolicyNo()+")不存在", null);
		}
		dto.setTlkProjectId(String.valueOf(list.get(0).get("tlkProjectId")));
		IdWorker id = idWorker;
		List<Map> addList = Lists.newArrayList();
		// {count:2,0:350702198802151319#张三#1,1:350702198802151319#李四#1}
		// 1标识增加，2标识减员
		JSONObject jsonObject = JSON.parseObject(dto.getCardList());
		Integer count = Integer.valueOf(String.valueOf(jsonObject.get("count")));

		List<Map> cnoList = Lists.newArrayList();
		Map map = null;
		Map mapIns = list.get(0);
		String comInsId = mapIns.get("comInsId")+"";
		String comId = mapIns.get("comId")+"";
		for (int i = 0; i <= count; i++) {
			String row = String.valueOf(jsonObject.get(i + ""));
			if (DictConst.PERSERVATION_ZY.equals(row.split("#")[2])) {
				// 增员
				Map rec = Maps.newHashMap();
				rec.put("comInsId", comInsId);
				rec.put("idCardNo", row.split("#")[0]);
				rec.put("name", row.split("#")[1]);
				rec.put("insPerDetailId", id.nextId());
				rec.put("createTime", new Date());
				rec.put("comId", comId);
				addList.add(rec);
			} else if (DictConst.PERSERVATION_JY.equals(row.split("#")[2])) {
				// 减员
				map = Maps.newHashMap();
				map.put("idCardNo", row.split("#")[0]);
				cnoList.add(map);
			} else {
				throw new BLBSyncDataException("CODE-9002", "出现违规数据，未标识增员和减员，放弃本次同步", null);
			}
		}
		if (addList.size() != 0) {
			int resval = comOnlineInsPerMapper.insertBatchPerInfo(addList);
			if (resval != addList.size()) {
				throw new BLBSyncDataException("CODE-9003", "订单初始化人员插入失败，插入条数和应插入数不符合" + resval + "/" + addList.size(),
						null);
			}
			if(StringUtils.isEmpty(dto.getTlkProjectId())){
				List<String> tlkRelationIds = comOnlineInsPerMapper.findTlkRelationIds(comId, addList);
				if(tlkRelationIds.size()>0){
					obpmUserMapper.updateInsureByIds("1",tlkRelationIds);
				}
			}else{
				obpmUserMapper.updateInsureByIdcardNos("1",dto.getPolicyNo(), dto.getTlkProjectId(), addList);
			}
		}
		if (cnoList.size() != 0) {
			comOnlineInsPerMapper.delPerInfo(comInsId, cnoList);
			if(StringUtils.isEmpty(dto.getTlkProjectId())){
				List<String> tlkRelationIds = comOnlineInsPerMapper.findTlkRelationIds(comId, cnoList);
				if(tlkRelationIds.size()>0) {
					obpmUserMapper.updateInsureByIds("0", tlkRelationIds);
				}
			}else{
				obpmUserMapper.updateInsureByIdcardNos("0","", dto.getTlkProjectId(), cnoList);
			}
		}

		// 重新计算在线保险表的订单人数
		BLBAPIDTO rec = new BLBAPIDTO();
		rec.setComInsId(Long.valueOf(comInsId));
		Map cnt = comInsMapper.countByComInsId(rec.getComInsId());
		// 获得再保人数
		rec.setPerNum(Integer.valueOf(String.valueOf(cnt.get("cnt"))));
		int resval = comInsMapper.update(rec);
		if (resval == 0) {
			throw new BLBSyncDataException("CODE-9004", "保险记录表com_online_ins_per修改失败", null);
		}

		return AjaxResult.success(Result.SUCCESS_MSG, null);
	}

	/**
	 * <b> 保全缴费待支付消息处理接口 </b>
	 * @author ZXF
	 * @create 2019/05/21 0021 16:07
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public AjaxResult sendInsUnpaidMsg(BLBAPIDTO dto) throws BLBSyncDataException {
		if (dto.getComId() == null) {
			return AjaxResult.fail("CODE-9005", "comId不能为空", null);
		}
//		String perIds = comInsPrincipalMapper.getPerIdByComId(dto.getComId());
//		String title = MsgConst.TYPE_010205_UNPAID_REMINDER_TITLE;
//		String content = MsgConst.TYPE_010205_UNPAID_REMINDER_CONTENT;
//		commonService.sendSysMessage(title,content,DictMessageTypeConst.MESSAGETYPE_010205,perIds,String.valueOf(dto.getComId()));
		return AjaxResult.success(Result.SUCCESS_MSG, null);
	}

	/**
	 * 企业初始化提示，根据企业所属规则去判断是否需要保险提示
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/3/29 14:10
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public Result promptInitEnterpriseIns(ComInsDTO dto) throws V5BusinessException {
		if (dto.getComId() == null) {
			return Result.fail("企业ID不能为空");
		}
		Map result = Maps.newHashMap();
		// 判断公司是否买了保险，线上线下保险都没有的情况提示去买保险
		List<Map> list = comInsMapper.selectOnlineByComId(dto.getComId(), null);
		if (list.size() == 0) {// 没有买过线上或线下保险
			result.put("isIns", "0");
			return Result.success(Result.SUCCESS_QUERY_MSG, result);
		}
		int isPerCntRight = 1; // 是否人数满足，默认满足
		int isGuaProjectRight = 1; // 是否满足政策的保障责任， 默认满足

		// 判断投保人数， 企业在职的员工数量 和 保险中的人数总和
		Map perCnt = comInsMapper.getInsPerCntIsRight(dto.getComId());
		if (perCnt != null && "0".equals(String.valueOf(perCnt.get("isPerCntRight")))) {
			isPerCntRight = 0;
			result.put("diffPerCnt", perCnt.get("diffCnt"));// 如果投保人数不足，会显示该字段
		}

		// 判断线下保险保障责任是否符合政策要求
		List<Map> guaProjects = comInsMapper.getInsGuaProjectIsRight(dto.getComId());
		if (guaProjects.size() != 0) { // 不为0，说明有规定保障责任，线下的可以直接判断掉
			for (Map guaProject : guaProjects) {
				// 先判断线下的
				if ("0".equals(String.valueOf(guaProject.get("isGood")))) { // 说明线下有保障责任不符合规定
					isGuaProjectRight = 0;
					break; // 不再判断，如有需求改动，可以把比对的明细发出来
				}
			}
		}
		// //判断线上保险,这边只有订单ID，需要开接口判断线上的
		Map blbOnlineMap = getBlbInsMap(dto);
		if (blbOnlineMap.keySet().size() > 0) {
			for (Map guaProject : guaProjects) {// 遍历政策要求的保障项目
				String guaShouldBeCode = String.valueOf(guaProject.get("guaProjectCode")); // 保障编码
				Double guaShouldBeFee = Double.valueOf(String.valueOf(guaProject.get("shouldBe"))); // 要求的保费值
				Double guaBlbFee = Double.valueOf(String.valueOf(blbOnlineMap.get(guaShouldBeCode))); // 在线购买的保费
				if (guaShouldBeFee > guaBlbFee) { // 在线购买的保险不符合政策要求
					isGuaProjectRight = 1;
					break; // 不再判断，如有需求改动，可以把比对的明细发出来
				}
			}
		}

		// 综合和判断
		if (isPerCntRight == 0 && isGuaProjectRight == 1) {
			result.put("isIns", "1");// 投保人数不符合
			return Result.success(Result.SUCCESS_QUERY_MSG, result);
		}
		if (isPerCntRight == 1 && isGuaProjectRight == 0) {
			result.put("isIns", "2"); // 保障项目不符合规定
			return Result.success(Result.SUCCESS_QUERY_MSG, result);
		}
		if (isPerCntRight == 0 && isGuaProjectRight == 0) {
			result.put("isIns", "3"); // 保障项目和投保人数不符合规定
			return Result.success(Result.SUCCESS_QUERY_MSG, result);
		}
		result.put("isIns", "9"); // 不需要提示
		return Result.success(Result.SUCCESS_QUERY_MSG, result);
	}

	/**
	 * 得到在线保险的保障信息，
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/4 17:26
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	private Map getBlbInsMap(ComInsDTO dto) throws V5BusinessException {
		// 获得在线保险
		Map blbGuaMap = Maps.newHashMap();
		try {
			List<Map> list = comInsMapper.selectOnlineByComId(dto.getComId(), 1);
			String result = blbTestService.getBlbProList();
			List<Map> resList = JSON.parseArray(result, Map.class); // 获取到了产品列表的信息
			for (Map comInsRow : list) {// 保险产品列表
				String productCode = String.valueOf(
						comInsRow.get("blbProductCode") == null ? "" : comInsRow.get("blbProductCode").toString());// 获取SAAS每个订单产品编码
				for (Map blbProRow : resList) { // 根据产品编码获取BLB对应的保障责任信息
					if (productCode.equals(String.valueOf(blbProRow.get("proCode")))) {
						List<Map> res = JSON.parseArray(String.valueOf(blbProRow.get("resList")), Map.class);
						for (Map r : res) { // 遍历保障责任
							if (r.get("fcy") != null && r.get("guaProjectCode") != null) {
								blbGuaMap.put(r.get("guaProjectCode"), NumberUtil
										.div(Double.valueOf(String.valueOf(r.get("fcy"))), new Double(10000)));
							}
						}
					}
				}
			}
		} catch (Exception e) {
			throw new V5BusinessException(Result.ERROR, "获取保险产品列表失败");
		}
		return blbGuaMap;
	}

	/**
	 * 保全提示，0无保险去购买，1需要做保全，
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/3/29 14:11
	 */
	@Override
	public Result promptInitPerAddDelIns(ComInsDTO dto) {
		Map result = Maps.newHashMap();
		// 判断公司是否买了保险，线上保险都没有的情况提示去买保险
		List<Map> list = comInsMapper.selectOnlineByComId(dto.getComId(), 1);

		if (list.size() == 0) {// 没有在blb 买过保险
			result.put("isIns", "0"); // false 没有买保险
			return Result.success(Result.SUCCESS_QUERY_MSG, result);
		} else {
			// 在blb买过保险，是否需要增员，是否需要减员
			result.put("isIns", "1");
			String needInsPerIds = comOnlineInsPerMapper.getInsingPerIds(dto.getComId());
			result.put("needInsPerIds", needInsPerIds);
			String needNoInsPerIds = comOnlineInsPerMapper.getNoInsPerIds(dto.getComId());
			result.put("needNoInsPerIds", needNoInsPerIds);
			return Result.success(Result.SUCCESS_QUERY_MSG, result);
		}
	}

	/**
	 * 保存方案书
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:40
	 */
	@Override
	public Result saveBookScheme(ComInsBootScheme dto) throws V5BusinessException {
		IdWorker id = idWorker;
		dto.setComInsBootSchemeId(id.nextId());
		dto.setCreateTime(new Date());
		comOnlineInsPerMapper.saveBootScheme(dto);
		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * 根据产品编码和地区进行判断，返回对应的pdf链接
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/4 10:57
	 */
	@Override
	public Result getBootSchemePdfLink(ComInsDTO dto) {
		String province = "";
		if ("450000".equals(dto.getProvince())) {
			province = "GX";
		}
		if ("610000".equals(dto.getProvince())) {
			province = "SX";
		}
		if ("100000".equals(dto.getProvince())) {
			province = "SC";
		}
		String pdfUrl = commonService.getSystemConfig("BCXIN_" + province + "_" + dto.getProCode());
		if ("null".equals(pdfUrl)) {
			return Result.fail("没有获取到对应的pdf");
		}
		return Result.success(Result.SUCCESS_MSG, pdfUrl);
	}

	/**
	 * 读取企业初始化温馨提示的接口
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/4 16:28
	 */
	@Override
	public Result promptCompanyInitGen(ComInsDTO dto) {
		String pic = commonService.getSystemConfig("BCXIN_PROMPT_PIC");
		if ("null".equals(pic)) {
			return Result.fail("没有获取到对应的温馨提示图片地址");
		}
		return Result.success(Result.SUCCESS_MSG, pic);
	}

	/**
	 * 根据保险规则通知当前登录的企业
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/17 13:48
	 * @return
	 */
	@Override
	public Result sendInsPromptToCompany(ComInsDTO dto) throws V5BusinessException {
		Map insRule = comInsMapper.getInsRuleByComId(dto.getComId()); // 查询出所有的保险规则
		if (insRule != null) {
			if ("0".equals(String.valueOf(insRule.get("isSendSysNotice")))) {// 如果是不发送直接跳过这个规则
				return Result.success(Result.SUCCESS_QUERY_MSG);
			}
			List<Map> list = comInsMapper.getComAdminInfo(dto.getComId()); // 获得要发送的人
			if (list.size() != 0) {
				int mark = 0; // 标记是否需要发送通知
				// 发送频次判断
				if ("1".equals(String.valueOf(insRule.get("sendCycleType")))) { // 1按次发送
					Map cnt = comInsMapper.getComHisMsgCnt(dto.getComId(), DictMessageTypeConst.MESSAGETYPE_010203);
					if (Convert.toInt(NumberUtil.sub(Convert.toDouble(insRule.get("sendTimes")),
							Convert.toDouble(cnt.get("total")))) > 0) {
						mark = 1;
					}
				} else { // 2是按周发送
					int currDayOfWeek = DateUtils.dayOfWeek(DateUtils.formatDate(new Date()));
					if (String.valueOf(insRule.get("weekSend")).indexOf(Convert.toStr(currDayOfWeek)) >= 0) { // 说明存在枚举的星期数据中
						mark = 1;
					}
				}
				if (mark == 1) {
					// 如果保障项目不符合规定，就调用罗总的接口发送通知
//					Result res = promptInitEnterpriseIns(dto);
//					Map map = (Map) res.getData();
//					// 如果是2和3，那么就是保障项目不符合规定
//					if ("2".equals(String.valueOf(map.get("isIns"))) || "3".equals(String.valueOf(map.get("isIns")))) {
//						Map params = CollUtil.newHashMap();
//						params.put("title", "系统安全提示！");
//						params.put("content", insRule.get("initContent"));
//						params.put("messageType", DictMessageTypeConst.MESSAGETYPE_010203);// 保险购买引导提示
//						params.put("ids", list.get(0).get("perId"));// 查询该企业的管理员
//						params.put("platId", "10");// SAAS平台标识
//						params.put("way", "3");// APP
//						HttpUtils.doPost(
//								commonService.getSystemConfig("SYS_PIC_HTTP_ADDR") + "/public/message/send-message",
//								params);
//					}
				}
			}
		}
		return Result.success(Result.SUCCESS_QUERY_MSG, "没有可以用的保险规则");
	}

	/**
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/18 18:07
	 */
	@Override
	public Result getInsBootPage(ComInsDTO dto) throws V5BusinessException {
		if (dto.getComId() == null) {
			throw new V5BusinessException(Result.ERROR, "参数comId不能为空");
		}
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		List<Map> list = comInsMapper.getInsBootPage(dto);
		return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
	}

	/**
	 * 获取线上人员参保列表
	 *
	 * @apiNote 作者 zhangye
	 * @since 创建于 2018/9/20 16:07
	 */
	@SuppressWarnings({ "rawtypes" })
	@Override
	public Result getOnlineInsPerList(ComOnlineInsPerDTO dto) throws V5BusinessException {
		String idCardNoJson = dto.getIdCardNoJson();
		if (StringUtils.isEmpty(idCardNoJson)) {
			throw new V5BusinessException(Result.BUSINESS_ERROR, "离职人员列表不能为空");
		}
		Long comId = dto.getComId();
		List<String> idCardNoList = JSON.parseArray(idCardNoJson, String.class);
		Map<String, Object> condition = new HashMap<String, Object>();
		condition.put("comId", comId);
		condition.put("list", idCardNoList);
		List<Map> resultMapList = comOnlineInsPerMapper.getOnlineInsPerList(condition);
		return Result.success(Result.SUCCESS_QUERY_MSG, resultMapList);
	}

	/**
	 * <b> 线上线下过期保险删除所有人员 </b>
	 *
	 * @author ZXF
	 * @create 2018/11/09 0009 13:36
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result delAllLosePerInfo() throws V5BusinessException {
		//保单到期前一个月/15天/3天
		String aDay = DateUtils.formatDate(DateUtils.addMonths(new Date(),1),"yyyy-MM-dd");//一个月
		String bDay = DateUtils.formatDate(DateUtils.addDays(new Date(),15),"yyyy-MM-dd");//15天
		String cDay = DateUtils.formatDate(DateUtils.addDays(new Date(),3),"yyyy-MM-dd");//3天
		List<Map<String, String>> bList = comInsMapper.findMaturingPolicy(aDay, bDay, cDay);
		//保单到期之日
		String dDay = DateUtils.formatDate(new Date(),"yyyy-MM-dd");//当天
//		List<Map<String, String>> tList = comInsMapper.findMaturingPolicy(dDay, "", "");
		//删除前先拿到对应人员的入离职记录
		List<String> delInsList = comOnlineInsPerMapper.allLoseTlkRelationIds();
		//删除人员
		comOnlineInsPerMapper.delAllLosePerInfo();
		if(delInsList.size() >0){
//			清空在保记录后同步更新智能人事在保状态
			obpmUserMapper.updateInsureByIds("0",delInsList);
		}
		//如果是临保类过期保险
		List<String> list = comInsMapper.allLosePolicyNos();
		if(list.size() >0){
			obpmUserMapper.updateUnInsureByPolicyNos("0", list);
		}
//		String title,content;
//		for(Map<String,String> map : bList){
//			title = MsgConst.TYPE_010202_B_EXPIRATION_REMINDER_TILTE;
//			content = MsgConst.TYPE_010202_B_EXPIRATION_REMINDER_CONTENT.replace("{productName}", map.get("productName"))
//					.replace("{policyNo}", map.get("policyNo"))
//					.replace("{endTime}", map.get("effectEndDate"))
//					.replace("{perNum}", String.valueOf(map.get("perNum")));
//			commonService.sendSysMessage(title,content, DictMessageTypeConst.MESSAGETYPE_010202,map.get("perIds"),map.get("comId"));
//		}
//		for(Map<String,String> map : tList){
//			title = MsgConst.TYPE_010202_T_EXPIRATION_REMINDER_TITLE;
//			content = MsgConst.TYPE_010202_T_EXPIRATION_REMINDER_CONTENT.replace("{productName}", map.get("productName"))
//					.replace("{policyNo}", map.get("policyNo"))
//					.replace("{endTime}", map.get("effectEndDate"))
//					.replace("{perNum}", String.valueOf(map.get("perNum")));
//			commonService.sendSysMessage(title,content, DictMessageTypeConst.MESSAGETYPE_010202,map.get("perIds"),map.get("comId"));
//		}
		return Result.success(Result.SUCCESS_QUERY_MSG);
	}

	/**
	 * <b> 根据条件查询未投保的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:53
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result findUninsuredPerList(InsPerDTO dto) throws V5BusinessException {
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		if("-1".equals(dto.getDepartId())){
			dto.setOrgType(DictConst.ORGTYPE_GS);
		}
		if (dto.getComId() == null) {
			throw new V5BusinessException(Result.ERROR, "参数comId不能为空");
		}
		PageInfoUtils pageInfoUtils;
		if("1".equals(dto.getBusinessType())){
			List<Map> list = comOnlineInsSignMapper.findUninsuredPerList(dto);
			pageInfoUtils = new PageInfoUtils(list);
			pageInfoUtils.setOther(comOnlineInsSignMapper.findUninsuredPerListCount(dto));
		}else{
			List<Map> list = comOnlineInsPerMapper.findUninsuredPerList(dto);
			pageInfoUtils = new PageInfoUtils(list);
			pageInfoUtils.setOther(comOnlineInsPerMapper.findUninsuredPerListCount(dto));
		}
		//百联保激活用户
		HttpUtil.get(blbTestService.blbActivateUserLinkUrl(dto.getComId(),""));
		return Result.success(Result.SUCCESS_QUERY_MSG,pageInfoUtils);
	}

	/**
	 * <b> 导出根据条件筛选未投保的人员信息 </b>
	 * @author ZXF
	 * @create 2020/05/26 0026 10:22
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void exportUninsuredPerList(InsPerDTO dto, HttpServletResponse response) throws V5BusinessException {
		if("-1".equals(dto.getDepartId())){
			dto.setOrgType(DictConst.ORGTYPE_GS);
		}
		try {
			List<UninsuredPerExcelBean> list;
			if("1".equals(dto.getBusinessType())){
				list = comOnlineInsSignMapper.exportUninsuredPerList(dto);
			}else{
				list = comOnlineInsPerMapper.exportUninsuredPerList(dto);
			}
			OutputStream os = null;
			com.bcxin.platform.util.excel.ExcelUtil<UninsuredPerExcelBean> util = new com.bcxin.platform.util.excel.ExcelUtil(UninsuredPerExcelBean.class);
			response.setContentType("application/vnd.ms-excel");
			response.setHeader("Content-Disposition",
					"attachment;fileName=" + new String(("未投保人员清单.xls").getBytes("gb2312"), "ISO8859-1"));
			os = response.getOutputStream();
			util.exportExcel(list, "未投保人员清单", 65535, os);
		} catch (Exception e) {
			throw new V5BusinessException(Result.BUSINESS_ERROR,"未投保人员导出失败，ERROR:"+e.getMessage());
		}
	}

	/**
	 * <b> 根据条件查询已过滤的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:53
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result findFilterPerList(InsPerDTO dto) throws V5BusinessException {
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		List<Map> list;
		if("1".equals(dto.getBusinessType())){
			list = comOnlineInsSignMapper.findFilterPerList(dto);
		}else{
			list = comOnlineInsPerMapper.findFilterPerList(dto);
		}
		return Result.success(Result.SUCCESS_QUERY_MSG,new PageInfoUtils(list));
	}

	/**
	 * <b> 根据条件查询已投保的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:53
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result findUnderWarrantyPerList(InsPerDTO dto) throws V5BusinessException {
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		if("-1".equals(dto.getDepartId())){
			dto.setOrgType("1");
		}
		PageInfoUtils pageInfoUtils;
		if("1".equals(dto.getBusinessType())){
			List<Map> list = comOnlineInsSignMapper.findUnderWarrantyPerList(dto);
			pageInfoUtils = new PageInfoUtils(list);
			pageInfoUtils.setOther(comOnlineInsSignMapper.findUnderWarrantyPerListCount(dto));
		}else{
			List<Map> list = comOnlineInsPerMapper.findUnderWarrantyPerList(dto);
			pageInfoUtils = new PageInfoUtils(list);
			pageInfoUtils.setOther(comOnlineInsPerMapper.findUnderWarrantyPerListCount(dto));
		}

		/*** 开线程修改身份证x为大写 ***/
		ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
		threadPool.execute(new Runnable() {
			@Override
			public void run() {
				perBaseInfoMapper.updateIdcardNoByComId(dto.getComId());
			}
		});

		return Result.success(Result.SUCCESS_QUERY_MSG,pageInfoUtils);
	}

	/**
	 * <b> 导出根据条件筛选已投保的人员信息 </b>
	 * @author ZXF
	 * @create 2020/05/26 0026 10:22
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void exportUnderWarrantyPerList(InsPerDTO dto, HttpServletResponse response) throws V5BusinessException {
		if("-1".equals(dto.getDepartId())){
			dto.setOrgType("1");
		}
		try {
			List<UnderWarrantyPerExcelBean> list;
			if("1".equals(dto.getBusinessType())){
				list = comOnlineInsSignMapper.exportUnderWarrantyPerList(dto);
			}else{
				list = comOnlineInsPerMapper.exportUnderWarrantyPerList(dto);
			}
			OutputStream os = null;
			com.bcxin.platform.util.excel.ExcelUtil<UnderWarrantyPerExcelBean> util = new com.bcxin.platform.util.excel.ExcelUtil(UnderWarrantyPerExcelBean.class);
			response.setContentType("application/vnd.ms-excel");
			response.setHeader("Content-Disposition",
					"attachment;fileName=" + new String(("已投保人员清单.xls").getBytes("gb2312"), "ISO8859-1"));
			os = response.getOutputStream();
			util.exportExcel(list, "已投保人员清单", 65535, os);
		} catch (Exception e) {
			throw new V5BusinessException(Result.BUSINESS_ERROR,"已投保人员导出失败，ERROR:"+e.getMessage());
		}
	}

	/**
	 * <b> 根据条件查询已投保未录入的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:53
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result findNotIncludedInsurancePerList(InsPerDTO dto) throws V5BusinessException {
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		PageInfoUtils pageInfoUtils;
		if("1".equals(dto.getBusinessType())){
			List<Map> list = comOnlineInsSignMapper.findNotIncludedInsurancePerList(dto);
			pageInfoUtils = new PageInfoUtils(list);
			pageInfoUtils.setOther(comOnlineInsSignMapper.findNotIncludedInsurancePerListCount(dto));
		}else{
			List<Map> list = comOnlineInsPerMapper.findNotIncludedInsurancePerList(dto);
			pageInfoUtils = new PageInfoUtils(list);
			pageInfoUtils.setOther(comOnlineInsPerMapper.findNotIncludedInsurancePerListCount(dto));
		}
		return Result.success(Result.SUCCESS_QUERY_MSG,pageInfoUtils);
	}

	/**
	 * <b> 导出根据条件筛选已投保未录入的人员信息 </b>
	 * @author ZXF
	 * @create 2020/05/26 0026 10:22
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void exportNotIncludedInsurancePerList(InsPerDTO dto, HttpServletResponse response) throws V5BusinessException {
		try {
			List<NotIncludedInsurancePerExcelBean> list;
			if("1".equals(dto.getBusinessType())){
				list = comOnlineInsSignMapper.exportNotIncludedInsurancePerList(dto);
			}else{
				list = comOnlineInsPerMapper.exportNotIncludedInsurancePerList(dto);
			}
			OutputStream os = null;
			com.bcxin.platform.util.excel.ExcelUtil<NotIncludedInsurancePerExcelBean> util = new com.bcxin.platform.util.excel.ExcelUtil(NotIncludedInsurancePerExcelBean.class);
			response.setContentType("application/vnd.ms-excel");
			response.setHeader("Content-Disposition",
					"attachment;fileName=" + new String(("已投保未录入人员清单.xls").getBytes("gb2312"), "ISO8859-1"));
			os = response.getOutputStream();
			util.exportExcel(list, "已投保未录入人员清单", 65535, os);
		} catch (Exception e) {
			throw new V5BusinessException(Result.BUSINESS_ERROR,"已投保未录入人员导出失败，ERROR:"+e.getMessage());
		}
	}

	/**
	 * <b> 查询在保人员离职人数 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:53
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result findYIncumbencyPerCount(InsPerDTO dto) throws V5BusinessException {
		int count = comOnlineInsPerMapper.findYIncumbencyPerCount(dto);
//		if(count>0){
//			//存在在保离职人员就给主管理员发站内信
//			Long comId = dto.getComId();
//			new Thread(() -> {
//				String perId = perBaseInfoMapper.selectPerIdByComId(comId);
//				String title = MsgConst.TYPE_010205_POLICY_CANCELLATION_REMINDER_TITLE;
//				String content = MsgConst.TYPE_010205_POLICY_CANCELLATION_REMINDER_CONTENT.replace("{num}", String.valueOf(count));
//				commonService.sendSysMessage(title,content,DictMessageTypeConst.MESSAGETYPE_010205,perId,String.valueOf(comId));
//			}).start();
//		}
		return Result.success(Result.SUCCESS_QUERY_MSG,count);
	}

	/**
	 * <b> 查询线下或线上保险列表 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:53
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result findOfflineOrOnlinePolicy(InsPerDTO dto) throws V5BusinessException {
		List<Map> list = comInsMapper.findOfflineOrOnlinePolicy(dto);
		return Result.success(Result.SUCCESS_QUERY_MSG,list);
	}

	/**
	 * <b> 人员批量添加过滤记录 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result addBatchFilterPerson(ComInsDTO dto) throws V5BusinessException {
		comInsMapper.addBatchFilterPerson(dto.getComId(),dto.getPerIds().split(","));
		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * <b> 人员批量删除过滤记录 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result delBatchFilterPerson(ComInsDTO dto) throws V5BusinessException {
		comInsMapper.delBatchFilterPerson(dto.getComId(),dto.getPerIds().split(","));
		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * <b> 查询保单已关联在保人员数量 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result findUnderWarrantyPerListCount(InsPerDTO dto) throws V5BusinessException {
		Integer count = comOnlineInsPerMapper.findUnderWarrantyPerListCount(dto);
		return Result.success(Result.SUCCESS_MSG,count);
	}

	/**
	 * <b> 人员批量关联线下保单 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result addBatchRelevancePer(ComInsDTO dto) throws V5BusinessException {
		if(StringUtils.isEmpty(dto.getIdCards())){
			throw new V5BusinessException(Result.ERROR,"未检索到人员身份证信息！");
		}
		if(dto.getComInsId() == null){
			throw new V5BusinessException(Result.ERROR,"未检索到保单ID信息！");
		}
		Map<String, Object> comInsMap = comInsMapper.selectById(dto.getComInsId());
		if(!(comInsMap != null&&DictConst.BUYMODE_XXGM.equals(String.valueOf(comInsMap.get("buyMode"))))){
			throw new V5BusinessException(Result.ERROR,"订单不符合关联线下保单条件！");
		}
		dto.setTlkProjectId(String.valueOf(comInsMap.get("tlkProjectId")));
		List<Map> addList = Lists.newArrayList();
		String[] idCardArr = dto.getIdCards().split(",");
		IdWorker id = idWorker;
		Map rec = null;
//		List<Long> perIds = Lists.newArrayList();
		for(String c : idCardArr){
			rec = Maps.newHashMap();
//			Long perId = comInsMapper.getPerIdByComIDAndIdCardNo(dto.getComId(), c);
			rec.put("comInsId", String.valueOf(dto.getComInsId()));
			rec.put("idCardNo", c);
			rec.put("insPerDetailId", id.nextId());
			rec.put("createTime", new Date());
			rec.put("comId", dto.getComId());
//			if(perId != null){
//				perIds.add(perId);
//			}
			addList.add(rec);
		}
		if (addList.size() != 0) {
			int resval = comOnlineInsPerMapper.insertBatchPerInfo(addList);
			if (resval != addList.size()) {
				throw new V5BusinessException(Result.ERROR,"线下保单人员信息关联异常！");
			}
		}
		if(StringUtils.isEmpty(dto.getTlkProjectId())){
			List<String> tlkRelationIds = comOnlineInsPerMapper.findTlkRelationIds(String.valueOf(dto.getComId()), addList);
			if(tlkRelationIds.size()>0) {
				obpmUserMapper.updateInsureByIds("1", tlkRelationIds);
			}
		}else{
			obpmUserMapper.updateInsureByIdcardNos("1",String.valueOf(comInsMap.get("policyNo")), dto.getTlkProjectId(), addList);
		}
		/*ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectComBaseInfoById(dto.getComId());
		//如果是v5映射的企业走数据分发平台的业务
		List<Map> li = Lists.newArrayList();
		if(perIds.size()>0){
			List<Map> inL = perBaseInfoMapper.packageTLInsureData(perIds,String.valueOf(dto.getComId()),String.valueOf(comBaseInfoDB.getTlkComId()),DictConst.INSUREDSTATES_ZB,"__wGomeHJBz6CpLFCCl4y","__qFCcCnozYNwzoG3O6Ms");
			li.addAll(inL);
		}
		bbdTestService.tlSyncPerPolicyStatus(li);*/

		return Result.success("关联成功！");
	}

	/**
	 * <b> 线下保单添加备注 </b>
	 * @author ZXF
	 * @create 2020/04/20 0020 16:02
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result updateComInsRemark(ComInsDTO dto) throws V5BusinessException {
		if(StringUtils.isEmpty(dto.getRemark())){
			throw new V5BusinessException(Result.ERROR,"备注不能为空！");
		}
		if(dto.getComInsId() == null){
			throw new V5BusinessException(Result.ERROR,"未检索到保单ID信息！");
		}
		comInsMapper.updateComInsRemark(dto.getComInsId(),dto.getRemark());
		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * <b> 人员批量减员线下保单 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result minusBatchRelevancePer(ComInsDTO dto) throws V5BusinessException {
		if(StringUtils.isEmpty(dto.getIdCards())){
			throw new V5BusinessException(Result.ERROR,"未检索到人员身份证信息！");
		}
		if(dto.getComInsId() == null){
			throw new V5BusinessException(Result.ERROR,"未检索到订单ID信息！");
		}
		Map<String, Object> comInsMap = comInsMapper.selectById(dto.getComInsId());
		if(!(comInsMap != null&&DictConst.BUYMODE_XXGM.equals(String.valueOf(comInsMap.get("buyMode"))))){
			throw new V5BusinessException(Result.ERROR,"订单不符合线下减员条件！");
		}
		String[] idCardArr = dto.getIdCards().split(",");
		List<Map> cnoList = Lists.newArrayList();
		Map map = null;
//		List<Long> perIds = Lists.newArrayList();
		for (String car : idCardArr) {
			map = Maps.newHashMap();
//			Long perId = comInsMapper.getPerIdByComIDAndIdCardNo(dto.getComId(), car);
			map.put("idCardNo", car);
//			if(perId != null){
//				perIds.add(perId);
//			}
			cnoList.add(map);
		}
		if (cnoList.size() != 0) {
			int resval = comOnlineInsPerMapper.delPerInfo(String.valueOf(dto.getComInsId()),cnoList);
			if (resval == 0) {
				throw new V5BusinessException(Result.ERROR,"线下保单人员信息移除异常！");
			}
		}
		List<String> tlkRelationIds = comOnlineInsPerMapper.findTlkRelationIds(String.valueOf(dto.getComId()), cnoList);
		if(tlkRelationIds.size()>0) {
			obpmUserMapper.updateInsureByIds("0", tlkRelationIds);
		}
		/*String provinces = commonService.getSystemConfig("BDP_PROVINCES");
		ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectComBaseInfoById(dto.getComId());
		//如果是对应配置的省的企业走数据分发平台的业务
		List<Map> li = Lists.newArrayList();
		if(perIds.size()>0){
			List<Map> inL = perBaseInfoMapper.packageTLInsureData(perIds,String.valueOf(dto.getComId()),String.valueOf(comBaseInfoDB.getTlkComId()),DictConst.INSUREDSTATES_BZB,"__wGomeHJBz6CpLFCCl4y","__qFCcCnozYNwzoG3O6Ms");
			li.addAll(inL);
		}
		bbdTestService.tlSyncPerPolicyStatus(li);*/
		return Result.success("移除成功！");
	}

	/**
	 * <b> 人员投保提醒、人员减员提醒 </b>
	 * 1.统计（未投保人员）的人员大于0时，则提醒；
	 * 2.统计（投保状态=“已投保”&在职状态=“离职”）的人员大于0时，则提醒：
	 * @author ZXF
	 * @create 2019/05/15 0015 16:34
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result sendInsuranceOperationMsg() {
		String perIds = "";
		String title,content;
		//统计（未投保人员）的人员大于0时，则提醒；
		List<Map> list = comOnlineInsPerMapper.countUninsuredPerAndCom();
		for (Map map : list) {
//			perIds = String.valueOf(map.get("perIds"));
//			title = MsgConst.TYPE_010205_BUY_REMINDER_TITLE;
//			content = MsgConst.TYPE_010205_BUY_REMINDER_CONTENT.replace("{num}", String.valueOf(map.get("num")));
//			commonService.sendSysMessage(title,content,DictMessageTypeConst.MESSAGETYPE_010205,perIds,String.valueOf(map.get("comId")));
		}
		//统计（投保状态=“已投保”&在职状态=“离职”）的人员大于0时，则提醒
		list = comOnlineInsPerMapper.countYIncumbencyPerAndCom();
		for (Map map : list) {
//			perIds = String.valueOf(map.get("perIds"));
//			title = MsgConst.TYPE_010205_POLICY_CANCELLATION_REMINDER_TITLE;
//			content = MsgConst.TYPE_010205_POLICY_CANCELLATION_REMINDER_CONTENT.replace("{num}", String.valueOf(map.get("num")));
//			commonService.sendSysMessage(title,content,DictMessageTypeConst.MESSAGETYPE_010205,perIds,String.valueOf(map.get("comId")));
		}
		return Result.success("操作成功！");
	}

	/**
	 * <b> 批量删除保险负责人 </b>
	 * @author ZXF
	 * @create 2019/05/17 0017 16:43
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result delBatchPrincipal(ComInsPrincipalDTO dto) throws V5BusinessException {
		if(StringUtils.isEmpty(dto.getPerIds())){
			return Result.fail("未选择人员！");
		}
		String[] perIdArr = dto.getPerIds().split(",");
		int resval = comInsPrincipalMapper.delBatchPrincipal(dto.getComId(),perIdArr);
		if(resval == 0){
			return Result.fail("保险负责人信息删除异常！");
		}
		return Result.success("操作成功！");
	}

	/**
	 * <b> 批量插入保险负责人 </b>
	 * @author ZXF
	 * @create 2019/05/17 0017 16:41
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result insertBatchPrincipal(ComInsPrincipalDTO dto) throws V5BusinessException {
		return savePrincipal(dto.getComId(),dto.getPerIds(),dto.getPerId());
	}

	private Result savePrincipal(Long comId, String perIds, Long createBy){
		if(StringUtils.isEmpty(perIds)){
			return Result.fail("未选择人员！");
		}
		String[] perIdArr = perIds.split(",");
		String idCards = perBaseInfoMapper.getIdCardNosByPerIds(perIdArr);
		if(StringUtils.isEmpty(idCards)){
			return Result.fail("未匹配到人员，或未完善身份证信息！");
		}
		List<Map> cnoList = perBaseInfoMapper.getByComIdAndCardNo(comId,createBy,perIdArr);
		if (cnoList.size() == 0) {
			return Result.fail("未匹配到对应人员信息！");
		}
		int resval = comInsPrincipalMapper.insertBatchPrincipal(cnoList);
		if(resval == 0){
			return Result.fail("保险负责人信息更新异常！");
		}
		return Result.success("操作成功！");
	}

	/**
	 * <b> 根据企业ID，查询保险负责人列 </b>
	 * @author ZXF
	 * @create 2019/05/17 0017 16:45
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result selectPrincipalByComId(ComInsPrincipalDTO dto) throws V5BusinessException {
		if (dto.getComId() == null) {
			throw new V5BusinessException(Result.ERROR, "参数comId不能为空");
		}
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		List<Map> list = comInsPrincipalMapper.selectPrincipalByComId(dto.getComId());
		return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
	}

	/**
	 * <b> 搜索已投保未录入人员身份证去百联保匹配获取姓名 </b>
	 * @author ZXF
	 * @create 2020/01/06 0006 10:27
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result findBlbPerName() throws V5BusinessException {
		Result res;
		int m=0,n=500;
		for (int i = 0; i < 200; i++) {
			String idCards = comOnlineInsPerMapper.findIdCardByEmptyName(m,n);
			if(StringUtils.isEmpty(idCards)||"null".equals(idCards)){
				break;
			}
			m = n;
			n = n + 500;
			res = blbTestService.blbPerName(idCards);
			if(res.getRetType().equals(Result.SUCCESS)&&res.getData()!=null){
				List list = JSON.parseArray(String.valueOf(res.getData()),Map.class);
				if(list.size()>0){
					/* 通过临时表来操作是为了节省批量修改在保人员信息产生的大量循环，可以节省时间和内存 */
					//保存到临时表
					comOnlineInsPerMapper.saveTempInsPerName(list);
					//从临时表同步到在保人员表
					comOnlineInsPerMapper.updateNameByIdCards();
					//清空临时表
					comOnlineInsPerMapper.deleteTempInsPerName();
				}
			}
		}
		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * <b> 批量人员导入处理 </b>
	 * @param importBatchId 批次Id：将获取当前登录的perId当做批次Id,这样每次导入就可以将对应批次在临时表的数据删除掉
	 * @author ZXF
	 * @create 2020/01/15 0015 15:58
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result batchUploadInsPer(Long importBatchId, Long comId, MultipartFile file) throws Exception {
		List<Map<String, Object>> excellist;
		try (InputStream in = file.getInputStream()){
			/*读取excel，支持*/
			ExcelReader reader = ExcelUtil.getReader(in);
			reader.isIgnoreEmptyRow();
        	/*从第三行开始读取，因为第三行为标题行*/
			excellist = reader.read(2, 6, 2147483647);
		}catch (Exception e){
			throw new V5BusinessException(Result.BUSINESS_ERROR, "Excel模板文件异常！");
		}
		/* 得到有效数据行并完成key、value的转换,初步校验数据 */
		excellist = screenValidData(excellist);
		if(excellist.size()==0){
			return Result.fail("Excel文件无有效数据");
		}
		//清除批次id对应历史数据
		comOnlineInsPerMapper.deleteTempBatchInsPerImport(importBatchId);
		//存入临时表
		comOnlineInsPerMapper.saveTempBatchInsPerImport(excellist,importBatchId);
		//校验导入的人员是否存在人事的组织架构里
		comOnlineInsPerMapper.checkIdCardNoInPerBaseInfo(importBatchId, comId);
		//校验数据（身份证重复）
		comOnlineInsPerMapper.checkIdCardNoRepeat(importBatchId);
		//校验数据（重复投保）
		comOnlineInsPerMapper.checkIdCardNoInsurance(importBatchId, comId);
		//查询信息错误条数
		Integer errCount = comOnlineInsPerMapper.countErrOrSuccessTempBatchInsPerImport("0",importBatchId);
		//查询信息正确条数
		Integer successCount = comOnlineInsPerMapper.countErrOrSuccessTempBatchInsPerImport("1",importBatchId);

		Map<String,String> param = Maps.newHashMap();
		param.put("importBatchId",String.valueOf(importBatchId));
		param.put("errCount",String.valueOf(errCount));
		param.put("successCount",String.valueOf(successCount));
		return Result.success(Result.SUCCESS_MSG,param);
	}
	/**
	 * <b> 批量人员导入处理(临保业务根据项目校验人员是否可以投保) </b>
	 * @param tlkProjectId 项目Id
	 * @param importBatchId 批次Id：将获取当前登录的perId当做批次Id,这样每次导入就可以将对应批次在临时表的数据删除掉
	 * @author ZXF
	 * @create 2020/01/15 0015 15:58
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result batchUploadInsPer(String tlkProjectId,Long importBatchId, Long comId, MultipartFile file) throws Exception {
		List<Map<String, Object>> excellist;
		try (InputStream in = file.getInputStream()){
			/*读取excel，支持*/
			ExcelReader reader = ExcelUtil.getReader(in);
			reader.isIgnoreEmptyRow();
        	/*从第三行开始读取，因为第三行为标题行*/
			excellist = reader.read(2, 6, 2147483647);
		}catch (Exception e){
			throw new V5BusinessException(Result.BUSINESS_ERROR, "Excel模板文件异常！");
		}
		/* 得到有效数据行并完成key、value的转换,初步校验数据 */
		excellist = screenValidData(excellist);
		if(excellist.size()==0){
			return Result.fail("Excel文件无有效数据");
		}
		//清除批次id对应历史数据
		comOnlineInsPerMapper.deleteTempBatchInsPerImport(importBatchId);
		//存入临时表
		comOnlineInsPerMapper.saveTempBatchInsPerImport(excellist,importBatchId);
		//校验导入的人员是否存在活动项目里
		comOnlineInsSignMapper.checkIdCardNoInPerBaseInfo(tlkProjectId, importBatchId, comId);
		//校验数据（身份证重复）
		comOnlineInsPerMapper.checkIdCardNoRepeat(importBatchId);
		//校验数据（重复投保）
		comOnlineInsSignMapper.checkIdCardNoInsurance(tlkProjectId, importBatchId, comId);
		//查询信息错误条数
		Integer errCount = comOnlineInsPerMapper.countErrOrSuccessTempBatchInsPerImport("0",importBatchId);
		//查询信息正确条数
		Integer successCount = comOnlineInsPerMapper.countErrOrSuccessTempBatchInsPerImport("1",importBatchId);

		Map<String,String> param = Maps.newHashMap();
		param.put("importBatchId",String.valueOf(importBatchId));
		param.put("errCount",String.valueOf(errCount));
		param.put("successCount",String.valueOf(successCount));
		return Result.success(Result.SUCCESS_MSG,param);
	}

	/**
	 * <b> 批量人员导入处理(减员专用) </b>
	 * @param importBatchId 批次Id：将获取当前登录的perId当做批次Id,这样每次导入就可以将对应批次在临时表的数据删除掉
	 * @author ZXF
	 * @create 2020/01/15 0015 15:58
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result minusBatchUploadInsPer(Long importBatchId, Long comId, MultipartFile file) throws Exception {
		List<Map<String, Object>> excellist;
		try (InputStream in = file.getInputStream()){
			/*读取excel，支持*/
			ExcelReader reader = ExcelUtil.getReader(in);
			reader.isIgnoreEmptyRow();
        	/*从第三行开始读取，因为第三行为标题行*/
			excellist = reader.read(2, 6, 2147483647);
		}catch (Exception e){
			throw new V5BusinessException(Result.BUSINESS_ERROR, "Excel模板文件异常！");
		}
		/* 得到有效数据行并完成key、value的转换,初步校验数据 */
		excellist = screenValidData(excellist);
		if(excellist.size()==0){
			return Result.fail("Excel文件无有效数据");
		}
		//清除批次id对应历史数据
		comOnlineInsPerMapper.deleteTempBatchInsPerImport(importBatchId);
		//存入临时表
		comOnlineInsPerMapper.saveTempBatchInsPerImport(excellist,importBatchId);
		//校验导入的人员是否存在人事的组织架构里
//		comOnlineInsPerMapper.checkIdCardNoInPerBaseInfo(importBatchId, comId);
		//校验数据（身份证重复）
		comOnlineInsPerMapper.checkIdCardNoRepeat(importBatchId);
		//校验数据（不在企业下的在保人员中）
		comOnlineInsPerMapper.checkIsZb(importBatchId, comId);
		//查询信息错误条数
		Integer errCount = comOnlineInsPerMapper.countErrOrSuccessTempBatchInsPerImport("0",importBatchId);
		//查询信息正确条数
		Integer successCount = comOnlineInsPerMapper.countErrOrSuccessTempBatchInsPerImport("1",importBatchId);
		//根据批次Id和企业Id查询该批次人员对应的保单信息(对应批量导入减员功能返回的有效结果集)
		List<Map<String, String>> mapList = comOnlineInsPerMapper.findValidMinusInsByImportBatchId(importBatchId, comId);
		Map<String,Object> param = Maps.newHashMap();
		param.put("importBatchId",String.valueOf(importBatchId));
		param.put("errCount",String.valueOf(errCount));
		param.put("successCount",String.valueOf(successCount));
		param.put("minusInsList",mapList);
		return Result.success(Result.SUCCESS_MSG,param);
	}

	/**
	 * <b> 筛选组装有效数据 </b>
	 * @author ZXF
	 * @create 2020/01/15 0015 20:41
	 * @version
	 * @注意事项 </b>
	 */
	private List<Map<String, Object>> screenValidData(List<Map<String, Object>> excellist){
		String[] keys = {"name","idCardNo","birthday","idCardType","perType","sex","mobilePhone","number","isSuccess","errorMsg"};
		Map<String, Object> newMap;
		List<Map<String, Object>> mlist = Lists.newArrayList();
		int isNull;
		for(Map<String, Object> map : excellist){
			if(StringUtils.isEmpty(String.valueOf(map.get("姓名")))
					&&StringUtils.isEmpty(String.valueOf(map.get("职业")))
					&&StringUtils.isEmpty(String.valueOf(map.get("证件号码")))
					&&StringUtils.isEmpty(String.valueOf(map.get("手机号")))
					&&StringUtils.isEmpty(String.valueOf(map.get("出生日期")))
					&&StringUtils.isEmpty(String.valueOf(map.get("证件类型")))
					&&StringUtils.isEmpty(String.valueOf(map.get("性别")))){
				continue;
			}
			newMap = Maps.newHashMap();
			isNull = 0;
			for(Map.Entry<String, Object> entry : map.entrySet()){
				String val = String.valueOf(entry.getValue());
				switch (entry.getKey()) {
					case "姓名":
						newMap.put(keys[0],val);
						break;
					case "证件号码":
						newMap.put(keys[1],val);
						break;
					case "出生日期":
						if(StringUtils.isNotEmpty(val)){
							val = val.replace(" 00:00:00","");
						}
						newMap.put(keys[2],val);
						break;
					case "证件类型":
						if(StringUtils.isNotEmpty(val)){
							val = "居民身份证".equals(val) ? "0":"护照".equals(val) ? "3":"台胞证".equals(val) ? "4":"回乡证".equals(val) ? "5":"";
						}
						newMap.put(keys[3],val);
						break;
					case "职业":
						newMap.put(keys[4],val);
						break;
					case "性别":
						if(StringUtils.isNotEmpty(val)){
							val = "男".equals(val) ? "1":"女".equals(val) ? "2":"";
						}
						newMap.put(keys[5],val);
						break;
					case "手机号":
						newMap.put(keys[6],val);
						break;
					case "序号":
						newMap.put(keys[7],val);
						break;
					default:
						break;
				}
				if(StringUtils.isEmpty(val)&&StringUtils.isNotEmpty(entry.getKey())){
					isNull = 1;
				}
			}
			if(isNull == 1){
				newMap.put(keys[8],"0");
				newMap.put(keys[9],"存在空值或数据不合法");
			}else{
				String errMsg = "";
				//检查身份证
				if("0".equals(String.valueOf(newMap.get(keys[1])))){//如果是身份证，校验年龄
					if (!IdcardUtils.validateCard(String.valueOf(newMap.get(keys[1])))){
						errMsg = "身份证号码错误；";
					}
				}
				try {
					int age = DateUtil.ageOfNow(String.valueOf(newMap.get(keys[2])));
					if (age<16||age>65){
						errMsg = errMsg + "年龄不符合投保条件；";
					}
				}catch (Exception e){
					errMsg = errMsg + "出生日期格式不合法；";
				}
				//职业
				String car = String.valueOf(newMap.get(keys[4]));
				if(car.length()>1||!"1234".contains(car)){
					errMsg = errMsg+"职业编码错误；";
				}
				//检查手机
				if(!validateMobile(String.valueOf(newMap.get(keys[6])))){
					errMsg = errMsg+"手机号码错误；";
				}
				if(StringUtils.isNotEmpty(errMsg)){
					newMap.put(keys[8],"0");
					newMap.put(keys[9],errMsg);
				}else{
					newMap.put(keys[8],"1");
					newMap.put(keys[9],"");
				}
			}
			mlist.add(newMap);
		}
		return mlist;
	}

	/**
	 * 手机号验证
	 *
	 * @param mobile
	 * @return 验证通过返回true
	 */
	public static boolean validateMobile(String mobile) {
		Pattern p = null;
		Matcher m = null;
		boolean b = false;
		p = Pattern.compile("^[1][3,4,5,6,7,8,9][0-9]{9}$"); // 验证手机号
		m = p.matcher(mobile);
		b = m.matches();
		return b;
	}

	/**
	 * <b> 根据批次id导出该批次错误人员信息 </b>
	 * @author ZXF
	 * @create 2020/01/16 0016 14:05
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result downErrInsPer(String importBatchId, HttpServletResponse response) {
		try {
			OutputStream os = null;
			com.bcxin.platform.util.excel.ExcelUtil<InsPerExcelBean> util = new com.bcxin.platform.util.excel.ExcelUtil(InsPerExcelBean.class);
			response.setContentType("application/vnd.ms-excel");
			response.setHeader("Content-Disposition",
					"attachment;fileName=" + new String("错误人员信息.xls".getBytes("gb2312"), "ISO8859-1"));
			os = response.getOutputStream();
			List<InsPerExcelBean> list = comOnlineInsPerMapper.findErrTempBatchInsPerImport(Long.parseLong(importBatchId));
			util.exportExcel(list, "错误人员信息", 65535, os);
		} catch (Exception e) {
			throw new V5BusinessException(Result.ERROR, "导出Excel错误人员失败");
		}
		return Result.success("导出Excel错误人员成功");
	}

	/**
	 * <b> 批量模板上传人员做增员 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 14:43
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result tempBatchInsPerToAddPreservationService(ComInsDTO dto) throws V5BusinessException {
		if (Strings.isNullOrEmpty(dto.getImportBatchId())) {
			throw new V5BusinessException(Result.ERROR, "批次ID不能为空");
		}
		if (Strings.isNullOrEmpty(dto.getOrderId())) {
			throw new V5BusinessException(Result.ERROR, "订单ID不能为空");
		}
		// 配置要参加保全的人员列表
		List<InsPreservationDetailVo> vo = comOnlineInsPerMapper.getBlbVoByTempBatchInsPerImport(Long.parseLong(dto.getImportBatchId()));
		if (vo.size()==0) {
			throw new V5BusinessException(Result.ERROR, "未匹配到人员信息");
		}
		return blbTestService.blbAddPreservationService(
				String.valueOf(dto.getComId())
				,dto.getOrderId()
				,JSONArray.toJSONString(vo)
				,DateUtils.formatDate(dto.getStartTime(), "yyyy-MM-dd"));
	}

	/**
	 * <b> 批量模板上传人员关联线下保单 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result tempBatchInsPerToRelevance(ComInsDTO dto) throws V5BusinessException {
		if (Strings.isNullOrEmpty(dto.getImportBatchId())) {
			throw new V5BusinessException(Result.ERROR, "批次ID不能为空");
		}
		if(dto.getComInsId() == null){
			throw new V5BusinessException(Result.ERROR,"未检索到保单ID信息");
		}
		// 配置要参加保全的人员列表
		List<InsPreservationDetailVo> list = comOnlineInsPerMapper.getBlbVoByTempBatchInsPerImport(Long.parseLong(dto.getImportBatchId()));
		if (list.size()==0) {
			throw new V5BusinessException(Result.ERROR, "未匹配到人员信息");
		}
		int num = comInsMapper.offlineResidualFelatableQuantity(dto.getComInsId());
		if ((num - list.size())<0) {
			throw new V5BusinessException(Result.ERROR, "导入人员数量超出在保人数");
		}
		List<Map> addList = Lists.newArrayList();
		IdWorker id = idWorker;
		Map rec;
		for(InsPreservationDetailVo vo : list){
			rec = Maps.newHashMap();
			rec.put("comInsId", String.valueOf(dto.getComInsId()));
			rec.put("idCardNo", vo.getId_card());
			rec.put("name", vo.getName());
			rec.put("insPerDetailId", id.nextId());
			rec.put("createTime", new Date());
			rec.put("comId", dto.getComId());
			addList.add(rec);
		}
		if (addList.size() != 0) {
			int resval = comOnlineInsPerMapper.insertBatchPerInfo(addList);
			if (resval != addList.size()) {
				throw new V5BusinessException(Result.ERROR,"线下保单人员信息关联异常！");
			}
		}
		return Result.success("关联成功！");
	}

	/**
	 * <b> 查询批量模板人员信息添加到缓存，返回生成的百联保访问地址 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 10:43
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result findCompnayAndTempBatchInsPerPutCache(ComInsDTO dto) throws V5BusinessException {
		if (dto.getComId() == null) {
			throw new V5BusinessException(Result.ERROR, "comId不能为空");
		}
		if (Strings.isNullOrEmpty(dto.getImportBatchId())) {
			throw new V5BusinessException(Result.ERROR, "批次ID不能为空");
		}
		IdWorker id = idWorker;
		String cacheId = BSEnum.get(dto.getBusinessType())+"-cacheIdForInsPerIds" + id.nextId();

		List<BLBComInfoDTO> list = new ArrayList();
		// 获取企业信息
		List<BLBComInfoDTO> company = comInsMapper.getCompanyByComID(dto.getComId());
		BLBComInfoDTO com = company.get(0);
		ComProject project = null;
		if("1".equals(dto.getBusinessType())){
			if (Strings.isNullOrEmpty(dto.getTlkProjectId())) {
				throw new V5BusinessException(Result.ERROR, "活动项目不能为空");
			}
			project = comProjectMapper.getItemsBytlkProjectId(dto.getTlkProjectId());
		}
		// 如果投保人信息不存在，就默认创建一条空的投保人信息（相当于初始化）
		if (com == null) {
			com = new BLBComInfoDTO();
			com.setKind(CommonConst.APP_KIND);
		}
		if(project!=null){
			com.setProject_name(project.getProjectName());
			com.setProject_address(project.getAddress());
			com.setProject_start_time(DateUtils.formatTime(project.getStartTime()));
			com.setProject_end_time(DateUtils.formatTime(project.getEndTime()));
		}
		list.add(com);
		List<BLBComInfoDTO> persons = comOnlineInsPerMapper.getTempBatchInsPerByImportBatchId(Long.parseLong(dto.getImportBatchId()));
		list.addAll(persons);

		// 设置到缓存中，8分钟后过期
		stringRedisTemplate.opsForValue().set(redisUtil.REDIS_PREFIX_KEY + ":INS:" + cacheId, JSON.toJSONString(list), 8 * 60,
				TimeUnit.SECONDS);

		String blbUrl = blbTestService.getCompnayAndPersonPutCacheUrl(
				dto.getReviseType()
				,cacheId);
		return Result.success(Result.SUCCESS_QUERY_MSG, blbUrl);
	}

	/**
	 * <b> 定时查询线下保单中标注百联保的单子去百联保拉取在保人数 </b>
	 * @author ZXF
	 * @create 2020/04/20 0020 10:09
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result syncInsNumTaskToBLB() throws V5BusinessException {
		String policyNos = comInsMapper.findPolicysByOfflineBLBSign();
		if(StringUtils.isEmpty(policyNos)){
			return Result.success("暂无符合条件的保单！");
		}
		String token = MD5Util.buildMD5(policyNos);
		Result result = blbTestService.blbZBNum(token,policyNos);
		if(Result.ERROR.equals(result.getRetType())){
			return result;
		}
		if (result.getData() == null){
			return Result.fail("未找到数据！");
		}
		List<Map> list = JSONArray.parseArray(String.valueOf(result.getData()),Map.class);
		comInsMapper.updateZBNumByPolicyNo(list);
		return Result.success(Result.SUCCESS_QUERY_MSG);
	}

	/**
	 * <b> APP理赔列表 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 15:58
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result reportList(BLBAPIDTO dto) throws V5BusinessException {
		if (StringUtils.isEmpty(dto.getStatus())) {
			throw new V5BusinessException(Result.ERROR, "status不能为空");
		}
		if (dto.getPerId() == null) {
			throw new V5BusinessException(Result.ERROR, "参数perId不能为空");
		}
		String[] perIds = {String.valueOf(dto.getPerId())};
		String idCardNo = perBaseInfoMapper.getIdCardNosByPerIds(perIds);
		if(StringUtils.isEmpty(idCardNo)){
			throw new V5BusinessException(Result.ERROR, "idCardNo不存在");
		}
		dto.setIdCardNo(idCardNo);
		return Result.success(Result.SUCCESS_MSG,blbTestService.reportList(dto.getIdCardNo(), dto.getStatus(), dto.getComId()));
	}

	/**
	 * <b> 根据身份证查询有过参与投保的保单记录 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 18:08
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result findPolicyByIdCard(BLBAPIDTO dto) throws V5BusinessException {
		if (dto.getPerId() == null) {
			throw new V5BusinessException(Result.ERROR, "参数perId不能为空");
		}
		String[] perIds = {String.valueOf(dto.getPerId())};
		String idCardNo = perBaseInfoMapper.getIdCardNosByPerIds(perIds);
		if(StringUtils.isEmpty(idCardNo)){
			throw new V5BusinessException(Result.ERROR, "idCardNo不存在");
		}
		dto.setIdCardNo(idCardNo);
		return Result.success(Result.SUCCESS_MSG,blbTestService.findPolicyByIdCard(dto.getIdCardNo(), dto.getComId()));
	}

	/**
	 * <b> APP理赔记录详情 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 15:58
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result getReportById(BLBAPIDTO dto) throws V5BusinessException {
		if (StringUtils.isEmpty(dto.getReportId())) {
			throw new V5BusinessException(Result.ERROR, "reportId不能为空");
		}
		return Result.success(Result.SUCCESS_MSG,blbTestService.getReportById(dto.getReportId(), dto.getComId()));
	}

	/**
	 * <b> 通过图片地址上传到平安ibos平台，激活fileId并返回 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 16:35
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result getFileIdByPath(BLBAPIDTO dto) throws V5BusinessException {
		if (StringUtils.isEmpty(dto.getPath())) {
			throw new V5BusinessException(Result.ERROR, "path不能为空");
		}
		return Result.success(Result.SUCCESS_MSG,blbTestService.getFileIdByPath(dto.getPath(),dto.getComId()));
	}

	/**
	 * <b> APP提交报案信息 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 15:58
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result saveReport(BLBAPIDTO dto) throws V5BusinessException {
		return Result.success(Result.SUCCESS_MSG,blbTestService.saveReport(dto.getComId()));
	}

	/**
	 * <b> 报案理流程附件补传 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 15:58
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result saveUploadFile(BLBAPIDTO dto) throws V5BusinessException {
		return Result.success(Result.SUCCESS_MSG,blbTestService.saveUploadFile(dto.getComId()));
	}

	/**
	 * <b> 修改记录保单信息的在保人数 </b>
	 * @author ZXF
	 * @create 2019/05/15 0015 10:23
	 * @version
	 * @注意事项 </b>
	 */
	private void changeInsPerCount(Long comInsId) {
		if(comInsId == null){
			return;
		}
		new Thread(()->{
			comInsMapper.changeInsPerCount(comInsId);
		}).start();
	}
}
