package com.bcxin.platform.service.company.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.dto.company.ComDepartDto;
import com.bcxin.platform.mapper.company.PerOrgRelationMapper;
import com.bcxin.platform.service.company.PerOrgRelationService;
import com.bcxin.platform.util.PageInfoUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 人员组织关系Service业务层处理
 * 
 * @author task
 * @date 2021-04-09
 */
@Service
public class PerOrgRelationServiceImpl implements PerOrgRelationService {

    @Resource
    private PerOrgRelationMapper perOrgRelationMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询人员组织关系
     * 
     * @param perOrgRelationId 人员组织关系ID
     * @return 人员组织关系
     */
    @Override
    public PerOrgRelation selectPerOrgRelationById(Long perOrgRelationId){
        return perOrgRelationMapper.selectPerOrgRelationById(perOrgRelationId);
    }

    /**
     * 查询人员组织关系列表
     * 
     * @param perOrgRelation 人员组织关系
     * @return 人员组织关系
     */
    @Override
    public List<PerOrgRelation> selectPerOrgRelationList(PerOrgRelation perOrgRelation){
        return perOrgRelationMapper.selectPerOrgRelationList(perOrgRelation);
    }

    /**
     * 新增人员组织关系
     * 
     * @param perOrgRelation 人员组织关系
     * @return 结果
     */
    @Override
    public int insertPerOrgRelation(PerOrgRelation perOrgRelation){
        perOrgRelation.setPerOrgRelationId(idWorker.nextId());
        perOrgRelation.setCreateTime(DateUtils.getNowDate());
        return perOrgRelationMapper.insertPerOrgRelation(perOrgRelation);
    }

    /**
     * 修改人员组织关系
     * 
     * @param perOrgRelation 人员组织关系
     * @return 结果
     */
    @Override
    public int updatePerOrgRelation(PerOrgRelation perOrgRelation){
        perOrgRelation.setUpdateTime(DateUtils.getNowDate());
        return perOrgRelationMapper.updatePerOrgRelation(perOrgRelation);
    }

    /**
     * 删除人员组织关系对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deletePerOrgRelationByIds(String ids){
        return perOrgRelationMapper.deletePerOrgRelationByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除人员组织关系信息
     * 
     * @param perOrgRelationId 人员组织关系ID
     * @return 结果
     */
    @Override
    public int deletePerOrgRelationById(Long perOrgRelationId){
        return perOrgRelationMapper.deletePerOrgRelationById(perOrgRelationId);
    }

    /**
     * 获取驻勤模块公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2020-04-16
     * @return
     */
    @Override
    public Result getTaskDepartPerSonList(ComDepartDto comDepart) {
        if (comDepart.getComId() == null) {
            return Result.fail("请传企业ID");
        }
        if (comDepart.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comDepart.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if(comDepart.getDepartId() == null){
            return Result.fail("部门ID为空");
        }
        PerOrgRelation perOrgRelation = new PerOrgRelation();

        /*** 如果部门ID为空或者-1则代表传入的是企业 ***/

        if(comDepart.getDepartId() != null) {
            if (comDepart.getDepartId() == -1L) {
                perOrgRelation.setOrgId(comDepart.getComId());
            } else {
                perOrgRelation.setOrgId(comDepart.getDepartId());
            }
        }
        perOrgRelation.setComId(comDepart.getComId());
        PageHelper.startPage(comDepart.getPageNumber(), comDepart.getPageSize());
        List<Map<String, Object>> perList = perOrgRelationMapper.getTaskDepartPerSonList(perOrgRelation);

        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(perList));
    }

    /**
     * 获取选人公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2019-08-28
     * @return
     */
    @Override
    public Result getDepartPerSonList(ComDepartDto comDepart) {
        if (comDepart.getComId() == null) {
            return Result.fail("请传企业ID");
        }
        if (comDepart.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comDepart.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if(comDepart.getDepartId() == null){
            return Result.fail("部门ID为空");
        }
        PerOrgRelation perOrgRelation = new PerOrgRelation();

        /*** 如果部门ID为空或者-1则代表传入的是企业 ***/

        if(comDepart.getDepartId() != null) {
            if (comDepart.getDepartId() == -1L) {
                perOrgRelation.setOrgId(comDepart.getComId());
            } else {
                perOrgRelation.setOrgId(comDepart.getDepartId());
            }
        }
        perOrgRelation.setComId(comDepart.getComId());
        PageHelper.startPage(comDepart.getPageNumber(), comDepart.getPageSize());
        List<Map<String, Object>> perList = perOrgRelationMapper.getDepartPerSonList(perOrgRelation);

        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(perList));
    }

    @Override
    public PerOrgRelation selectPerOrgRelationByTlkId(String tlkRelationId) {
        return perOrgRelationMapper.selectPerOrgRelationByTlkId(tlkRelationId);
    }

    @Override
    public void saveBatch(List<PerOrgRelation> relationList) {
        perOrgRelationMapper.saveBatch(relationList);
    }


    @Override
    public Result getCommonPerListByKeyword(ComDepartDto comDepartDto) {
        if (comDepartDto.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comDepartDto.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if (StringUtil.isEmpty(comDepartDto.getKeyword())) {
            return Result.fail("关键字不能为空");
        }
        PageHelper.startPage(comDepartDto.getPageNumber(), comDepartDto.getPageSize());
        List<Map<String, String>> perList = perOrgRelationMapper.getCommonPerListByKeyword(comDepartDto.getComId(), comDepartDto.getKeyword());
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(perList));
    }


    /**
     * 获取华为会议选人公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2019-12-12
     * @return
     */
    @Override
    public Result getHuaweiDepartPerSonList(ComDepartDto comDepart) {
        if (comDepart.getComId() == null) {
            return Result.fail("请传企业ID");
        }
        if (comDepart.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comDepart.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if(comDepart.getDepartId() == null){
            return Result.fail("部门ID为空");
        }
        PerOrgRelation perOrgRelation = new PerOrgRelation();

        /*** 如果部门ID为空或者-1则代表传入的是企业 ***/

        if(comDepart.getDepartId() != null) {
            if (comDepart.getDepartId() == -1L) {
                perOrgRelation.setOrgId(comDepart.getComId());
            } else {
                perOrgRelation.setOrgId(comDepart.getDepartId());
            }
        }
        perOrgRelation.setComId(comDepart.getComId());
        PageHelper.startPage(comDepart.getPageNumber(), comDepart.getPageSize());
        List<Map<String, Object>> perList = perOrgRelationMapper.getHuaweiDepartPerSonList(perOrgRelation);

        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(perList));
    }

    @Override
    public PerOrgRelation findByPerId(Long perId) {
        return perOrgRelationMapper.findByPerId(perId);
    }

}
