package com.bcxin.platform.service.company;

import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.dto.company.ComDepartDto;

import java.util.List;

/**
 * 人员组织关系Service接口
 * 
 * @author task
 * @date 2021-04-09
 */
public interface PerOrgRelationService{

    /**
     * 查询人员组织关系
     * 
     * @param perOrgRelationId 人员组织关系ID
     * @return 人员组织关系
     */
    PerOrgRelation selectPerOrgRelationById(Long perOrgRelationId);

    /**
     * 查询人员组织关系列表
     * 
     * @param perOrgRelation 人员组织关系
     * @return 人员组织关系集合
     */
    List<PerOrgRelation> selectPerOrgRelationList(PerOrgRelation perOrgRelation);

    /**
     * 新增人员组织关系
     * 
     * @param perOrgRelation 人员组织关系
     * @return 结果
     */
    int insertPerOrgRelation(PerOrgRelation perOrgRelation);

    /**
     * 修改人员组织关系
     * 
     * @param perOrgRelation 人员组织关系
     * @return 结果
     */
    int updatePerOrgRelation(PerOrgRelation perOrgRelation);

    /**
     * 批量删除人员组织关系
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deletePerOrgRelationByIds(String ids);

    /**
     * 删除人员组织关系信息
     * 
     * @param perOrgRelationId 人员组织关系ID
     * @return 结果
     */
    int deletePerOrgRelationById(Long perOrgRelationId);

    /**
     * 获取驻勤模块公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2020-04-16
     * @return
     */
    Result getTaskDepartPerSonList(ComDepartDto comDepart);

    /**
     * 获取选人公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2019-08-28
     * @return
     */
    Result getDepartPerSonList(ComDepartDto comDepart);

    /**
     * 查询人员组织关系
     *
     * @param tlkRelationId v5人员组织关系ID
     * @return 人员组织关系
     */
    PerOrgRelation selectPerOrgRelationByTlkId(String tlkRelationId);

    void saveBatch(List<PerOrgRelation> relationList);


    /**
     * 关键字查询公共选人的接口
     * @param comDepartDto
     * @return
     * @author llc
     * @date 2019-08-28
     */
    Result getCommonPerListByKeyword(ComDepartDto comDepartDto);

    /**
     * 获取华为会议选人公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2019-12-12
     * @return
     */
    Result getHuaweiDepartPerSonList(ComDepartDto comDepart);

    PerOrgRelation findByPerId(Long perId);
}
